/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.mehvahdjukaar.polytone.Polytone;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class PropertiesUtils {
    public static Properties jsonToProperties(JsonElement element) {
        Properties properties = new Properties();
        if (element instanceof JsonObject) {
            JsonObject jo = (JsonObject)element;
            PropertiesUtils.iterateJsonObject(jo, properties, "");
        }
        return properties;
    }

    private static void iterateJsonObject(JsonObject jsonObject, Properties properties, String currentPath) {
        for (String key : jsonObject.keySet()) {
            JsonPrimitive s;
            String newPath;
            JsonElement value = jsonObject.get(key);
            String string = newPath = currentPath.isEmpty() ? key : currentPath + "." + key;
            if (value instanceof JsonObject) {
                JsonObject jo = (JsonObject)value;
                PropertiesUtils.iterateJsonObject(jo, properties, newPath);
                continue;
            }
            if (value instanceof JsonPrimitive && (s = (JsonPrimitive)value).isString()) {
                properties.setProperty(newPath, s.getAsString());
                continue;
            }
            if (!(value instanceof JsonArray)) continue;
            JsonArray ja = (JsonArray)value;
            StringBuilder builder = new StringBuilder();
            for (JsonElement e : ja) {
                JsonPrimitive p;
                if (!(e instanceof JsonPrimitive) || !(p = (JsonPrimitive)e).isString()) continue;
                builder.append(p.getAsString()).append(" ");
            }
            properties.setProperty(newPath, builder.toString().trim());
        }
    }

    public static JsonObject propertiesToJson(Properties properties) {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            String[] keys = key.split("\\.");
            JsonObject currentObject = jsonObject;
            for (int i = 0; i < keys.length - 1; ++i) {
                String currentKey = keys[i];
                if (!currentObject.has(currentKey)) {
                    JsonObject newObject = new JsonObject();
                    currentObject.add(currentKey, (JsonElement)newObject);
                    currentObject = newObject;
                    continue;
                }
                JsonElement element = currentObject.get(currentKey);
                if (!element.isJsonObject()) {
                    throw new IllegalArgumentException("Invalid properties file: Duplicate key found: " + currentKey);
                }
                currentObject = element.getAsJsonObject();
            }
            String finalKey = keys[keys.length - 1];
            if (currentObject.has(finalKey)) {
                throw new IllegalArgumentException("Invalid properties file: Duplicate key found: " + finalKey);
            }
            if (value.contains(" ")) {
                String[] values = value.split(" ");
                jsonObject.getAsJsonObject(keys[0]).addProperty(finalKey, values[0]);
                for (int i = 1; i < values.length; ++i) {
                    jsonObject.getAsJsonObject(keys[0]).getAsJsonArray(finalKey).add(values[i]);
                }
                continue;
            }
            jsonObject.getAsJsonObject(keys[0]).addProperty(finalKey, value);
        }
        return jsonObject;
    }

    public static Map<ResourceLocation, Properties> gatherProperties(ResourceManager resourceManager, String path) {
        FileToIdConverter converter = new FileToIdConverter(path, ".properties");
        HashMap<ResourceLocation, Properties> map = new HashMap<ResourceLocation, Properties>();
        Map res = converter.m_247457_(resourceManager);
        for (Map.Entry e : res.entrySet()) {
            try {
                BufferedReader reader = ((Resource)e.getValue()).m_215508_();
                try {
                    Properties properties = new Properties();
                    properties.load(reader);
                    ResourceLocation fileId = converter.m_245273_((ResourceLocation)e.getKey());
                    map.put(fileId, properties);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException ex) {
                Polytone.LOGGER.error("Couldn't parse property file {}:", e, (Object)ex);
            }
        }
        return map;
    }
}

