/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.CodecUtil;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class Parsed<T> {
    private final boolean isEnabled;
    private final T value;
    private final ResourceLocation id;
    private static final Codec<Boolean> CONDITION_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("polytone_ignore", (Object)false).forGetter(b -> b), (App)CodecUtil.withAlternative(Codec.STRING.listOf(), Codec.STRING, List::of).optionalFieldOf("require_mods", List.of()).forGetter(b -> List.of())).apply((Applicative)instance, (b, l) -> {
        if (b.booleanValue()) {
            return false;
        }
        for (String s : l) {
            if (PlatStuff.isModLoaded(s)) continue;
            return false;
        }
        return true;
    }));

    private Parsed(boolean isEnabled, T value, ResourceLocation id) {
        this.isEnabled = isEnabled;
        this.value = value;
        this.id = id;
    }

    public static <A> Parsed<A> success(A value, ResourceLocation id) {
        return new Parsed<A>(true, value, id);
    }

    public static <A> Parsed<A> of(A value, ResourceLocation id, boolean enabled) {
        return new Parsed<A>(enabled, value, id);
    }

    public T getResultOrPartial() {
        return this.value;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Optional<T> asOptional() {
        if (this.isEnabled) {
            return Optional.of(this.value);
        }
        return Optional.empty();
    }

    @Nullable
    public T orNull() {
        return this.isEnabled ? (T)this.value : null;
    }

    public static <T, J> Parsed<T> parseAlways(Decoder<T> codec, J input, DynamicOps<J> ops, ResourceLocation id, String jsonTypeName) {
        return Parsed.parseOptionalOrPartial(codec, codec, input, ops, id, jsonTypeName);
    }

    public static <T, J> Optional<T> parseOptional(Decoder<T> codec, J input, DynamicOps<J> ops, ResourceLocation id, String jsonTypeName) {
        Boolean enabled = (Boolean)((Pair)CONDITION_CODEC.decode(ops, input).getOrThrow(false, arg_0 -> ((Logger)Polytone.LOGGER).error(arg_0))).getFirst();
        try {
            if (enabled.booleanValue()) {
                return Optional.of(((Pair)codec.decode(ops, input).getOrThrow(false, arg_0 -> ((Logger)Polytone.LOGGER).error(arg_0))).getFirst());
            }
            return Optional.empty();
        }
        catch (Exception e) {
            throw new JsonParseException("Failed to decode " + jsonTypeName + " from file \"" + String.valueOf(id) + ".json\": ", (Throwable)e);
        }
    }

    @Nullable
    public static <T, J> T parseOrNull(Decoder<T> codec, J input, DynamicOps<J> ops, ResourceLocation id, String jsonTypeName) {
        return Parsed.parseOptional(codec, input, ops, id, jsonTypeName).orElse(null);
    }

    public static <T, J> Parsed<T> parseOptionalOrPartial(Decoder<T> fullCodec, Decoder<T> partialCodec, J input, DynamicOps<J> ops, ResourceLocation id, String jsonTypeName) {
        Object value;
        Boolean enabled = (Boolean)((Pair)CONDITION_CODEC.decode(ops, input).getOrThrow(false, arg_0 -> ((Logger)Polytone.LOGGER).error(arg_0))).getFirst();
        try {
            value = enabled.booleanValue() ? ((Pair)fullCodec.decode(ops, input).getOrThrow(false, arg_0 -> ((Logger)Polytone.LOGGER).error(arg_0))).getFirst() : ((Pair)partialCodec.decode(ops, input).getOrThrow(false, arg_0 -> ((Logger)Polytone.LOGGER).error(arg_0))).getFirst();
        }
        catch (Exception e) {
            throw new JsonParseException("Failed to decode " + jsonTypeName + " from file \"" + String.valueOf(id) + ".json\": ", (Throwable)e);
        }
        return new Parsed<Object>(enabled, value, id);
    }
}

