/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class CompoundReloader
extends SimplePreparableReloadListener<List<Object>> {
    private final List<PartialReloader<?>> children;
    private final List<Object> childrenResources = new ArrayList<Object>();

    public CompoundReloader(PartialReloader<?> ... reloaders) {
        this.children = List.of(reloaders);
    }

    protected List<Object> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (PartialReloader<?> c : this.children) {
            list.add(c.prepare(resourceManager));
        }
        return list;
    }

    protected void apply(List<Object> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        this.childrenResources.clear();
        this.childrenResources.addAll(object);
        if (level != null) {
            this.applyWithLevel(level.m_9598_(), false);
        }
    }

    public void applyWithLevel(RegistryAccess registryAccess, boolean firstLogin) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (!firstLogin) {
            this.resetWithLevel(false);
        }
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        for (int i = 0; i < this.childrenResources.size(); ++i) {
            PartialReloader<?> c = this.children.get(i);
            try {
                this.processTyped(c, this.childrenResources.get(i), (RegistryOps<JsonElement>)ops, registryAccess);
                continue;
            }
            catch (Exception e) {
                String message = String.valueOf(c) + " failed to parse some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        for (PartialReloader<?> c : this.children) {
            try {
                c.applyWithLevel(registryAccess, firstLogin);
            }
            catch (Exception e) {
                String message = String.valueOf(c) + " failed to apply some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        Polytone.LOGGER.info("Reloaded Polytone Resources in {} ms", (Object)stopwatch.elapsed().toMillis());
    }

    private <T> void processTyped(PartialReloader<T> reloader, Object object, RegistryOps<JsonElement> ops, RegistryAccess access) {
        reloader.parseWithLevel(object, ops, access);
    }

    public void resetWithLevel(boolean isLogOff) {
        for (PartialReloader<?> c : this.children) {
            c.resetWithLevel(isLogOff);
        }
    }

    public void earlyProcess(ResourceManager resourceManager) {
        for (PartialReloader<?> c : this.children) {
            c.earlyProcess(resourceManager);
        }
    }
}

