/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.particle.ParticleModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class ParticleModifiersManager
extends JsonImgPartialReloader {
    private final Multimap<ParticleType<?>, ParticleModifier> particleModifiers = HashMultimap.create();

    public ParticleModifiersManager() {
        super("particle_modifiers");
    }

    public void maybeModify(ParticleOptions options, Level level, Particle particle) {
        Collection mod = this.particleModifiers.get((Object)options.m_6012_());
        for (ParticleModifier modifier : mod) {
            modifier.modify(particle, level, options);
        }
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, RegistryOps<JsonElement> ops, RegistryAccess access) {
        ResourceLocation id;
        Object modifier;
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>(resources.textures());
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        Map parsedModifiers = Utils.sortedMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            ResourceLocation id2 = entry.getKey();
            modifier = Parsed.parseOptionalOrPartial(ParticleModifier.CODEC, ParticleModifier.PARTIAL_CODEC, json, ops, id2, "particle modifier");
            parsedModifiers.put(id2, modifier);
        }
        for (Map.Entry<ResourceLocation, Object> entry : parsedModifiers.entrySet()) {
            id = entry.getKey();
            Parsed parsed = (Parsed)entry.getValue();
            modifier = (ParticleModifier)parsed.getResultOrPartial();
            if (!((ParticleModifier)modifier).hasColormap() && textures.containsKey(id)) {
                ((ParticleModifier)modifier).setColormap(Colormap.createDefTriangle());
            }
            BlockColor tint = ((ParticleModifier)modifier).getColormap();
            ColormapsManager.tryAcceptingTexture(textures, id, tint, usedTextures, true);
            if (!parsed.isEnabled()) continue;
            this.addModifier(id, (ParticleModifier)modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<ResourceLocation, Object> entry : textures.entrySet()) {
            id = entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, ParticleModifier.ofColormap(defaultColormap));
        }
    }

    @Override
    protected void applyWithLevel(RegistryAccess access, boolean isLogIn) {
        if (!this.particleModifiers.isEmpty()) {
            Polytone.LOGGER.info("Registered {} particle modifiers", (Object)this.particleModifiers.size());
        }
    }

    private void addModifier(ResourceLocation pathId, ParticleModifier mod) {
        for (Holder p : mod.targets().compute(pathId, BuiltInRegistries.f_257034_)) {
            this.particleModifiers.put((Object)((ParticleType)p.m_203334_()), (Object)mod);
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.particleModifiers.clear();
    }

    public void addCustomParticleColor(ResourceLocation id, String color) {
        Optional opt = BuiltInRegistries.f_257034_.m_6612_(id);
        opt.ifPresent(t -> this.particleModifiers.put(t, (Object)ParticleModifier.ofColor(color)));
    }
}

