/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.BaseExpression;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ParticleContextExpression
extends BaseExpression {
    private static final String COLOR = "COLOR";
    private static final String SPEED = "SPEED";
    private static final String X = "X";
    private static final String Y = "Y";
    private static final String Z = "Z";
    private static final String DX = "DX";
    private static final String DY = "DY";
    private static final String DZ = "DZ";
    private static final String RED = "RED";
    private static final String GREEN = "GREEN";
    private static final String BLUE = "BLUE";
    private static final String ALPHA = "ALPHA";
    private static final String SIZE = "SIZE";
    private static final String LIFE = "LIFETIME";
    private static final String AGE = "AGE";
    private static final String ROLL = "ROLL";
    private static final String CUSTOM = "CUSTOM";
    public static final Codec<ParticleContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new ParticleContextExpression((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    private final boolean hasCustom;
    public static final ParticleContextExpression ZERO = new ParticleContextExpression("0");
    public static final ParticleContextExpression ONE = new ParticleContextExpression("1");
    public static final ParticleContextExpression PARTICLE_RAND = new ParticleContextExpression("(rand() * 2.0 - 1.0) * 0.4");

    public ParticleContextExpression(String expression) {
        super(expression);
        this.hasCustom = expression.contains(CUSTOM);
    }

    @Override
    protected void buildFunctions(BaseExpression.FunBuilder builder) {
        super.buildFunctions(builder);
    }

    @Override
    protected void buildVars(BaseExpression.VarBuilder builder) {
        super.buildVars(builder);
        builder.addAll(COLOR, SPEED, X, Y, Z, DX, DY, DZ, RED, GREEN, BLUE, ALPHA, SIZE, LIFE, AGE, ROLL, CUSTOM);
    }

    public double getValue(Particle particle, Level level) {
        Entity e;
        this.expression.setVariable(LIFE, particle.m_107273_());
        int pack = ColorUtils.pack(particle.f_107227_, particle.f_107228_, particle.f_107229_);
        this.expression.setVariable(COLOR, pack);
        this.expression.setVariable(RED, particle.f_107227_);
        this.expression.setVariable(GREEN, particle.f_107228_);
        this.expression.setVariable(BLUE, particle.f_107229_);
        this.expression.setVariable(SPEED, Mth.m_184648_((double)particle.f_107215_, (double)particle.f_107216_, (double)particle.f_107217_));
        this.expression.setVariable(ALPHA, particle.f_107230_);
        this.expression.setVariable(SIZE, ((SingleQuadParticle)particle).f_107663_);
        this.expression.setVariable(DX, particle.f_107215_);
        this.expression.setVariable(DY, particle.f_107216_);
        this.expression.setVariable(DZ, particle.f_107217_);
        this.expression.setVariable(X, particle.f_107212_);
        this.expression.setVariable(Y, particle.f_107213_);
        this.expression.setVariable(Z, particle.f_107214_);
        this.expression.setVariable(AGE, particle.f_107224_);
        this.expression.setVariable(ROLL, particle.f_107231_);
        if (this.hasCustom && particle instanceof CustomParticleType.Instance) {
            CustomParticleType.Instance i = (CustomParticleType.Instance)particle;
            this.expression.setVariable(CUSTOM, i.getCustom());
        }
        if (this.hasPos) {
            BlockPos pos = BlockPos.m_274561_((double)particle.f_107212_, (double)particle.f_107213_, (double)particle.f_107214_);
            this.expression.setVariable("POS_X", pos.m_123341_());
            this.expression.setVariable("POS_Y", pos.m_123342_());
            this.expression.setVariable("POS_Z", pos.m_123343_());
        }
        if (this.hasTime) {
            this.expression.setVariable("TIME", ClientFrameTicker.getGameTime());
        }
        if (this.hasDayTime) {
            this.expression.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            this.expression.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            this.expression.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSkyLight) {
            this.expression.setVariable("SKY_LIGHT", ClientFrameTicker.getSkyLight());
        }
        if (this.hasBlockLight) {
            this.expression.setVariable("BLOCK_LIGHT", ClientFrameTicker.getBlockLight());
        }
        if (this.hasTemperature) {
            this.expression.setVariable("TEMPERATURE", ClientFrameTicker.getTemperature());
        }
        if (this.hasDownfall) {
            this.expression.setVariable("DOWNFALL", ClientFrameTicker.getDownfall());
        }
        if (this.hasPlayer) {
            e = Minecraft.m_91087_().m_91288_();
            this.expression.setVariable("PLAYER_X", e.m_20185_());
            this.expression.setVariable("PLAYER_Y", e.m_20186_());
            this.expression.setVariable("PLAYER_Z", e.m_20189_());
        }
        if (this.hasDistance) {
            e = Minecraft.m_91087_().m_91288_();
            double x = particle.f_107212_ - e.m_20185_();
            double y = particle.f_107213_ - e.m_20186_();
            double z = particle.f_107214_ - e.m_20189_();
            this.expression.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            this.expression.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            this.expression.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        ExpressionUtils.randomizeRandom();
        return this.expression.evaluate();
    }
}

