/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.particle.CustomParticleFactory;
import net.mehvahdjukaar.polytone.particle.ParticleContextExpression;
import net.mehvahdjukaar.polytone.particle.ParticleInitializer;
import net.mehvahdjukaar.polytone.particle.ParticleParticleEmitter;
import net.mehvahdjukaar.polytone.particle.ParticleTickable;
import net.mehvahdjukaar.polytone.sound.ParticleSoundEmitter;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class CustomParticleType
implements CustomParticleFactory {
    private static BlockState STATE_HACK = Blocks.f_50016_.m_49966_();
    private final RenderType renderType;
    @Nullable
    private final ResourceLocation model;
    @Nullable
    private final ParticleInitializer initializer;
    @Nullable
    private final Ticker ticker;
    private final List<ParticleSoundEmitter> sounds;
    protected final List<ParticleParticleEmitter> particles = new ArrayList<ParticleParticleEmitter>();
    @Nullable
    protected List<Dynamic<?>> lazyParticles;
    private final int lightLevel;
    private final LiquidAffinity liquidAffinity;
    private final boolean hasPhysics;
    private final boolean killOnContact;
    private final boolean killWhenStill;
    @Nullable
    private final IColorGetter colormap;
    private final Vec3 offset;
    private final Optional<ParticleGroup> group;
    private final boolean forceSpawn;
    private final boolean randomSprite;
    private transient SpriteSet spriteSet;
    private boolean isValid = true;
    public static final Codec<CustomParticleType> CODEC = RecordCodecBuilder.create(i -> i.group((App)RenderType.CODEC.optionalFieldOf("render_type", (Object)RenderType.OPAQUE).forGetter(CustomParticleType::getRenderType), (App)ResourceLocation.f_135803_.optionalFieldOf("model").forGetter(c -> Optional.ofNullable(c.model)), (App)Vec3.f_231074_.optionalFieldOf("offset", (Object)Vec3.f_82478_).forGetter(c -> c.offset), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(c -> c.lightLevel), (App)Codec.BOOL.optionalFieldOf("has_physics", (Object)true).forGetter(c -> c.hasPhysics), (App)Codec.BOOL.optionalFieldOf("kill_on_contact", (Object)false).forGetter(c -> c.killOnContact), (App)Codec.BOOL.optionalFieldOf("kill_when_still", (Object)false).forGetter(c -> c.killWhenStill), (App)LiquidAffinity.CODEC.optionalFieldOf("liquid_affinity", (Object)LiquidAffinity.ANY).forGetter(c -> c.liquidAffinity), (App)Colormap.CODEC.optionalFieldOf("colormap").forGetter(c -> Optional.ofNullable(c.colormap)), (App)Codec.BOOL.optionalFieldOf("random_sprite", (Object)false).forGetter(c -> c.randomSprite), (App)ExtraCodecs.f_144628_.optionalFieldOf("limit", (Object)0).forGetter(c -> c.group.map(ParticleGroup::m_175819_).orElse(0)), (App)Codec.BOOL.optionalFieldOf("force_spawn", (Object)false).forGetter(c -> c.forceSpawn), (App)ParticleInitializer.CODEC.optionalFieldOf("initializer").forGetter(c -> Optional.ofNullable(c.initializer)), (App)Ticker.CODEC.optionalFieldOf("ticker").forGetter(c -> Optional.ofNullable(c.ticker)), (App)ParticleSoundEmitter.CODEC.listOf().optionalFieldOf("sound_emitters", List.of()).forGetter(c -> c.sounds), (App)Codec.PASSTHROUGH.listOf().optionalFieldOf("particle_emitters", List.of()).forGetter(c -> c.lazyParticles)).apply((Applicative)i, CustomParticleType::new));
    public static final Codec<Optional<ResourceLocation>> CUSTOM_MODEL_ONLY_CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.f_135803_.optionalFieldOf("model").forGetter(e -> e)).apply((Applicative)i, r -> r));

    private CustomParticleType(RenderType renderType, @Nullable ResourceLocation model, Vec3 offset, int light, boolean hasPhysics, boolean killOnContact, boolean killWhenStill, LiquidAffinity liquidAffinity, @Nullable IColorGetter colormap, boolean randomSprite, int particleGroupLimit, boolean forceSpawn, @Nullable ParticleInitializer initializer, @Nullable Ticker ticker, @Nullable List<ParticleSoundEmitter> sounds, @Nullable List<Dynamic<?>> particles) {
        this.renderType = renderType;
        this.randomSprite = randomSprite;
        this.model = model;
        this.initializer = initializer;
        this.ticker = ticker;
        this.sounds = sounds;
        this.lazyParticles = particles;
        this.lightLevel = light;
        this.hasPhysics = hasPhysics;
        this.killOnContact = killOnContact;
        this.killWhenStill = killWhenStill;
        this.liquidAffinity = liquidAffinity;
        this.forceSpawn = forceSpawn;
        this.colormap = colormap;
        this.offset = offset;
        this.group = particleGroupLimit > 0 ? Optional.of(new ParticleGroup(particleGroupLimit)) : Optional.empty();
    }

    private CustomParticleType(RenderType renderType, Optional<ResourceLocation> model, Vec3 offset, int light, boolean hasPhysics, boolean killOnContact, boolean killWhenStill, LiquidAffinity liquidAffinity, Optional<IColorGetter> colormap, boolean randomSprite, int limit, boolean forceSpawn, Optional<ParticleInitializer> initializer, Optional<Ticker> ticker, List<ParticleSoundEmitter> sounds, List<Dynamic<?>> particles) {
        this(renderType, (ResourceLocation)model.orElse(null), offset, light, hasPhysics, killOnContact, killWhenStill, liquidAffinity, (IColorGetter)colormap.orElse(null), randomSprite, limit, forceSpawn, (ParticleInitializer)initializer.orElse(null), (Ticker)ticker.orElse(null), sounds, particles);
    }

    @Override
    public boolean forceSpawns() {
        return this.forceSpawn;
    }

    @Override
    @Nullable
    public ResourceLocation getCustomModel() {
        return this.model;
    }

    public static void setStateHack(BlockState state) {
        STATE_HACK = state;
    }

    private RenderType getRenderType() {
        return this.renderType;
    }

    @Override
    public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable BlockState state) {
        if (this.spriteSet != null) {
            Instance newParticle = new Instance(world, x, y, z, xSpeed, ySpeed, zSpeed, state, this, BuiltInRegistries.f_257034_.m_7981_((Object)type));
            if (this.hasPhysics) {
                for (VoxelShape voxelShape : world.m_186434_(null, newParticle.m_107277_())) {
                    if (voxelShape.m_83281_()) continue;
                    return null;
                }
            }
            if (this.ticker != null && this.ticker.removeIf != null && this.ticker.removeIf.getValue((Particle)newParticle, (Level)world) > 0.0) {
                return null;
            }
            return newParticle;
        }
        throw new IllegalStateException("Sprite set not set for custom particle type");
    }

    @Override
    public void setSpriteSet(ParticleEngine.MutableSpriteSet mutableSpriteSet) {
        this.spriteSet = mutableSpriteSet;
    }

    public void setUnregistered() {
        this.isValid = false;
    }

    public static enum RenderType {
        TERRAIN,
        OPAQUE,
        TRANSLUCENT,
        LIT,
        INVISIBLE;

        public static final Codec<RenderType> CODEC;

        public net.minecraft.client.renderer.RenderType getBlock() {
            return switch (this.ordinal()) {
                case 0 -> net.minecraft.client.renderer.RenderType.m_110451_();
                case 2 -> net.minecraft.client.renderer.RenderType.m_110466_();
                case 3 -> net.minecraft.client.renderer.RenderType.m_110463_();
                case 4 -> net.minecraft.client.renderer.RenderType.m_110463_();
                default -> net.minecraft.client.renderer.RenderType.m_110457_();
            };
        }

        public ParticleRenderType getParticle() {
            return switch (this.ordinal()) {
                case 0 -> ParticleRenderType.f_107429_;
                case 2 -> ParticleRenderType.f_107431_;
                case 3 -> ParticleRenderType.f_107432_;
                case 4 -> ParticleRenderType.f_107434_;
                default -> ParticleRenderType.f_107430_;
            };
        }

        static {
            CODEC = Codec.STRING.xmap(a -> RenderType.valueOf(a.toUpperCase()), e -> e.name().toLowerCase(Locale.ROOT));
        }
    }

    protected record Ticker(@Nullable ParticleContextExpression x, @Nullable ParticleContextExpression y, @Nullable ParticleContextExpression z, @Nullable ParticleContextExpression dx, @Nullable ParticleContextExpression dy, @Nullable ParticleContextExpression dz, @Nullable ParticleContextExpression size, @Nullable ParticleContextExpression red, @Nullable ParticleContextExpression green, @Nullable ParticleContextExpression blue, @Nullable ParticleContextExpression alpha, @Nullable ParticleContextExpression roll, @Nullable ParticleContextExpression custom, @Nullable ParticleContextExpression removeIf) {
        private static final Codec<Ticker> CODEC = RecordCodecBuilder.create(i -> i.group((App)ParticleContextExpression.CODEC.optionalFieldOf("x").forGetter(p -> Optional.ofNullable(p.x)), (App)ParticleContextExpression.CODEC.optionalFieldOf("y").forGetter(p -> Optional.ofNullable(p.y)), (App)ParticleContextExpression.CODEC.optionalFieldOf("z").forGetter(p -> Optional.ofNullable(p.z)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dx").forGetter(p -> Optional.ofNullable(p.dx)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dy").forGetter(p -> Optional.ofNullable(p.dy)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dz").forGetter(p -> Optional.ofNullable(p.dz)), (App)ParticleContextExpression.CODEC.optionalFieldOf("size").forGetter(p -> Optional.ofNullable(p.size)), (App)ParticleContextExpression.CODEC.optionalFieldOf("red").forGetter(p -> Optional.ofNullable(p.red)), (App)ParticleContextExpression.CODEC.optionalFieldOf("green").forGetter(p -> Optional.ofNullable(p.green)), (App)ParticleContextExpression.CODEC.optionalFieldOf("blue").forGetter(p -> Optional.ofNullable(p.blue)), (App)ParticleContextExpression.CODEC.optionalFieldOf("alpha").forGetter(p -> Optional.ofNullable(p.alpha)), (App)ParticleContextExpression.CODEC.optionalFieldOf("roll").forGetter(p -> Optional.ofNullable(p.roll)), (App)ParticleContextExpression.CODEC.optionalFieldOf("custom").forGetter(p -> Optional.ofNullable(p.custom)), (App)ParticleContextExpression.CODEC.optionalFieldOf("remove_condition").forGetter(p -> Optional.ofNullable(p.removeIf))).apply((Applicative)i, Ticker::new));

        private Ticker(Optional<ParticleContextExpression> x, Optional<ParticleContextExpression> y, Optional<ParticleContextExpression> z, Optional<ParticleContextExpression> dx, Optional<ParticleContextExpression> dy, Optional<ParticleContextExpression> dz, Optional<ParticleContextExpression> size, Optional<ParticleContextExpression> red, Optional<ParticleContextExpression> green, Optional<ParticleContextExpression> blue, Optional<ParticleContextExpression> alpha, Optional<ParticleContextExpression> roll, Optional<ParticleContextExpression> custom, Optional<ParticleContextExpression> removeIf) {
            this((ParticleContextExpression)x.orElse(null), (ParticleContextExpression)y.orElse(null), (ParticleContextExpression)z.orElse(null), (ParticleContextExpression)dx.orElse(null), (ParticleContextExpression)dy.orElse(null), (ParticleContextExpression)dz.orElse(null), (ParticleContextExpression)size.orElse(null), (ParticleContextExpression)red.orElse(null), (ParticleContextExpression)green.orElse(null), (ParticleContextExpression)blue.orElse(null), (ParticleContextExpression)alpha.orElse(null), (ParticleContextExpression)roll.orElse(null), (ParticleContextExpression)custom.orElse(null), (ParticleContextExpression)removeIf.orElse(null));
        }

        private void tick(Instance particle, ClientLevel level) {
            if (this.roll != null) {
                particle.f_107204_ = particle.f_107231_;
                particle.f_107231_ = (float)particle.ticker.roll.getValue((Particle)particle, (Level)level);
            }
            if (this.size != null) {
                particle.oQuadSize = particle.f_107663_;
                particle.f_107663_ = (float)this.size.getValue((Particle)particle, (Level)level);
            }
            if (this.red != null) {
                particle.f_107227_ = (float)this.red.getValue((Particle)particle, (Level)level);
            }
            if (this.green != null) {
                particle.f_107228_ = (float)this.green.getValue((Particle)particle, (Level)level);
            }
            if (this.blue != null) {
                particle.f_107229_ = (float)this.blue.getValue((Particle)particle, (Level)level);
            }
            if (this.alpha != null) {
                particle.f_107230_ = (float)this.alpha.getValue((Particle)particle, (Level)level);
            }
            if (this.x != null) {
                particle.f_107212_ = this.x.getValue((Particle)particle, (Level)level);
            }
            if (this.y != null) {
                particle.f_107213_ = this.y.getValue((Particle)particle, (Level)level);
            }
            if (this.z != null) {
                particle.f_107214_ = this.z.getValue((Particle)particle, (Level)level);
            }
            if (this.dx != null) {
                particle.f_107215_ = this.dx.getValue((Particle)particle, (Level)level);
            }
            if (this.dy != null) {
                particle.f_107216_ = this.dy.getValue((Particle)particle, (Level)level);
            }
            if (this.dz != null) {
                particle.f_107217_ = this.dz.getValue((Particle)particle, (Level)level);
            }
            if (this.custom != null) {
                particle.custom = this.custom.getValue((Particle)particle, (Level)level);
            }
            if (this.removeIf != null && this.removeIf.getValue((Particle)particle, (Level)level) > 0.0) {
                particle.m_107274_();
            }
        }
    }

    protected static enum LiquidAffinity implements StringRepresentable
    {
        LIQUIDS,
        NON_LIQUIDS,
        ANY;

        private static final Codec<LiquidAffinity> CODEC;

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.m_216439_(LiquidAffinity::values);
        }
    }

    public static class Instance
    extends TextureSheetParticle {
        protected final CustomParticleType type;
        protected final RenderType renderType;
        @Nullable
        protected final BakedModel model;
        @Nullable
        protected final Ticker ticker;
        protected final SpriteSet spriteSet;
        protected final LiquidAffinity liquidAffinity;
        protected final List<ParticleTickable> tickables;
        protected float oQuadSize;
        protected double custom;
        private ResourceLocation name;

        protected Instance(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable BlockState state, CustomParticleType customType, ResourceLocation typeId) {
            super(level, x, y, z, xSpeed, ySpeed, zSpeed);
            this.m_107250_(0.1f, 0.1f);
            this.name = typeId;
            this.type = customType;
            this.tickables = new ArrayList<ParticleTickable>();
            this.tickables.addAll(customType.sounds);
            this.tickables.addAll(customType.particles);
            if (state == null) {
                state = STATE_HACK;
            }
            this.f_107212_ = x;
            this.f_107213_ = y;
            this.f_107214_ = z;
            this.f_107215_ = xSpeed;
            this.f_107216_ = ySpeed;
            this.f_107217_ = zSpeed;
            this.model = customType.model == null ? null : PlatStuff.getModel(customType.model);
            this.renderType = customType.renderType;
            this.ticker = customType.ticker;
            ParticleInitializer initializer = customType.initializer;
            BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            if (initializer != null) {
                initializer.initialize((SingleQuadParticle)this, level, state, pos);
            }
            this.oQuadSize = this.f_107663_;
            this.liquidAffinity = customType.liquidAffinity;
            this.f_107219_ = customType.hasPhysics;
            if (this.type.colormap != null) {
                float[] unpack = ColorUtils.unpack(this.type.colormap.m_92566_(state, (BlockAndTintGetter)level, pos, 0));
                this.m_107253_(unpack[0], unpack[1], unpack[2]);
            }
            if (customType.randomSprite) {
                this.spriteSet = null;
                this.m_108335_(customType.spriteSet);
            } else {
                this.spriteSet = customType.spriteSet;
                this.m_108339_(this.spriteSet);
            }
        }

        public void m_6257_(double x, double y, double z) {
            Vec3 wantedPos;
            Vec3 myPos;
            super.m_6257_(x, y, z);
            if (this.type.killOnContact && this.f_107224_ > 1 && (myPos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_)).m_82557_(wantedPos = new Vec3(this.f_107209_ + x, this.f_107210_ + y, this.f_107211_ + z)) > 1.0E-6) {
                this.m_107274_();
                this.f_107215_ = 0.0;
                this.f_107216_ = 0.0;
                this.f_107217_ = 0.0;
            }
        }

        public Optional<ParticleGroup> m_142654_() {
            return this.type.group;
        }

        public double getCustom() {
            return this.custom;
        }

        protected int m_6355_(float partialTick) {
            int total = super.m_6355_(partialTick);
            if (this.type.lightLevel > 0) {
                int sky = LightTexture.m_109894_((int)total);
                int block = LightTexture.m_109883_((int)total);
                block = Math.max(block, this.type.lightLevel);
                return LightTexture.m_109885_((int)block, (int)sky);
            }
            return total;
        }

        public void m_107274_() {
            super.m_107274_();
            this.f_107224_ = this.f_107225_;
        }

        public void m_5989_() {
            BlockState state;
            if (!this.type.isValid) {
                this.m_107274_();
                return;
            }
            if (this.spriteSet != null) {
                this.m_108339_(this.spriteSet);
            }
            super.m_5989_();
            if (this.ticker != null) {
                this.ticker.tick(this, this.f_107208_);
            }
            if (this.type.colormap != null) {
                BlockPos pos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
                float[] unpack = ColorUtils.unpack(this.type.colormap.m_92566_(null, (BlockAndTintGetter)this.f_107208_, pos, 0));
                this.m_107253_(unpack[0], unpack[1], unpack[2]);
            }
            if (this.f_107224_ > 1 && this.type.killWhenStill && this.f_107212_ == this.f_107209_ && this.f_107213_ == this.f_107210_ && this.f_107214_ == this.f_107211_) {
                this.m_107274_();
            }
            if (this.f_107219_ && this.f_107205_) {
                this.m_107274_();
            }
            if (this.liquidAffinity != LiquidAffinity.ANY && this.liquidAffinity == LiquidAffinity.LIQUIDS ^ !(state = this.f_107208_.m_8055_(BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_))).m_60819_().m_76178_()) {
                this.m_107274_();
            }
            if (!this.f_107220_) {
                for (ParticleTickable tickable : this.tickables) {
                    tickable.tick((Particle)this, (Level)this.f_107208_);
                }
            }
        }

        public void m_5744_(VertexConsumer consumer, Camera renderInfo, float partialTicks) {
            if (this.model == null) {
                super.m_5744_(consumer, renderInfo, partialTicks);
            } else {
                Quaternionf quaternionf;
                PoseStack poseStack = new PoseStack();
                Vec3 cameraPos = renderInfo.m_90583_();
                float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
                float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_());
                float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
                if (this.f_107231_ == 0.0f) {
                    quaternionf = new Quaternionf();
                } else {
                    quaternionf = new Quaternionf();
                    quaternionf.rotateY(Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_));
                }
                float size = this.m_5902_(partialTicks);
                poseStack.m_252880_(x, y, z);
                poseStack.m_85841_(size, size, size);
                poseStack.m_252781_(quaternionf);
                poseStack.m_85837_(-0.5, -0.5, -0.5);
                MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
                consumer = bufferSource.m_6299_(net.minecraft.client.renderer.RenderType.m_110463_());
                Instance.putModelBulkData(this.model, this.m_6355_(partialTicks), OverlayTexture.f_118083_, poseStack, consumer, this.f_107227_, this.f_107228_, this.f_107229_);
                bufferSource.m_109911_();
            }
        }

        public static void putModelBulkData(BakedModel model, int combinedLight, int combinedOverlay, PoseStack poseStack, VertexConsumer buffer, float r, float g, float b) {
            RandomSource randomSource = RandomSource.m_216327_();
            for (Direction direction : Direction.values()) {
                randomSource.m_188584_(42L);
                for (BakedQuad bakedQuad : model.m_213637_(null, direction, randomSource)) {
                    buffer.m_85987_(poseStack.m_85850_(), bakedQuad, 1.0f, g, b, combinedLight, combinedOverlay);
                }
            }
            randomSource.m_188584_(42L);
            for (BakedQuad bakedQuad : model.m_213637_(null, null, randomSource)) {
                buffer.m_85987_(poseStack.m_85850_(), bakedQuad, r, g, b, combinedLight, combinedOverlay);
            }
        }

        public float m_5902_(float scaleFactor) {
            return Mth.m_14179_((float)scaleFactor, (float)this.oQuadSize, (float)this.f_107663_);
        }

        public ParticleRenderType m_7556_() {
            return this.model == null ? this.renderType.getParticle() : ParticleRenderType.f_107433_;
        }
    }
}

