/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IndexCompoundColorGetter;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ColormapsManager
extends JsonImgPartialReloader {
    public static final IColorGetter GRASS_COLOR = new IColorGetter.OfBlock((s, l, p, i) -> l != null && p != null ? BiomeColors.m_108793_((BlockAndTintGetter)l, (BlockPos)p) : GrassColor.m_276205_());
    public static final IColorGetter FOLIAGE_COLOR = new IColorGetter.OfBlock((s, l, p, i) -> l != null && p != null ? BiomeColors.m_108804_((BlockAndTintGetter)l, (BlockPos)p) : FoliageColor.m_46113_());
    public static final IColorGetter WATER_COLOR = new IColorGetter.OfBlock((s, l, p, i) -> l != null && p != null ? BiomeColors.m_108811_((BlockAndTintGetter)l, (BlockPos)p) : -16777216);
    private final MapRegistry<Supplier<IColorGetter>> colormaps = new MapRegistry("Polytone Colormaps");

    public Codec<IColorGetter> byNameCodec() {
        return this.colormaps.xmap(Supplier::get, s -> () -> s);
    }

    public ColormapsManager() {
        super("colormaps");
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, RegistryOps<JsonElement> ops, RegistryAccess access) {
        this.addBuiltinColormaps();
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>(resources.textures());
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            ResourceLocation id = entry.getKey();
            Colormap colormap = (Colormap)((Pair)Colormap.DIRECT_CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Colormap with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            colormap.inlined = false;
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)colormap, usedTextures, true);
            this.add(id, colormap);
        }
        for (Supplier supplier : this.colormaps.getValues()) {
            if (!(supplier instanceof Colormap)) continue;
            Colormap cm = (Colormap)((Object)supplier);
            if (cm.lazyFallback == null) continue;
            try {
                cm.fallback = this.runCodec((DynamicOps)ops, (Dynamic)cm.lazyFallback);
            }
            catch (Exception e) {
                Polytone.LOGGER.error("Failed to initialize colormap fallback", (Throwable)e);
            }
            cm.lazyFallback = null;
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry entry : textures.entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            defaultColormap.inlined = false;
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.add(id, defaultColormap);
        }
    }

    private <T> IColorGetter runCodec(DynamicOps o, Dynamic<T> dynamic) {
        DynamicOps ops = o;
        return (IColorGetter)((Pair)this.byNameCodec().decode(ops, dynamic.getValue()).getOrThrow(false, arg_0 -> ((Logger)Polytone.LOGGER).error(arg_0))).getFirst();
    }

    @Override
    protected void applyWithLevel(RegistryAccess access, boolean isLogIn) {
    }

    private void addBuiltinColormaps() {
        this.colormaps.register(new ResourceLocation("grass_color"), () -> GRASS_COLOR);
        this.colormaps.register(new ResourceLocation("foliage_color"), () -> FOLIAGE_COLOR);
        this.colormaps.register(new ResourceLocation("water_color"), () -> WATER_COLOR);
        this.colormaps.register(new ResourceLocation("biome_sample"), Colormap::createDefSquare);
        this.colormaps.register(new ResourceLocation("triangular_biome_sample"), Colormap::createDefTriangle);
        this.colormaps.register(new ResourceLocation("fixed"), Colormap::createFixed);
        this.colormaps.register(new ResourceLocation("grid"), Colormap::createBiomeId);
        this.colormaps.register(new ResourceLocation("damage"), Colormap::createDamage);
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.colormaps.clear();
    }

    public void add(ResourceLocation id, Colormap colormap) {
        this.colormaps.register(id, () -> colormap);
        if (!colormap.hasTexture()) {
            throw new IllegalStateException("Did not find any texture png for colormap " + String.valueOf(id));
        }
    }

    public static void tryAcceptingTextureGroup(Map<ResourceLocation, ArrayImage.Group> availableTextures, ResourceLocation defaultPath, BlockColor col, Set<ResourceLocation> usedTexture, boolean strict) {
        if (col instanceof IndexCompoundColorGetter) {
            IndexCompoundColorGetter c = (IndexCompoundColorGetter)col;
            ColormapsManager.tryAcceptingTextureGroup(availableTextures, defaultPath, c, usedTexture, strict);
        } else if (col instanceof Colormap) {
            Colormap c = (Colormap)col;
            ColormapsManager.tryAcceptingTextureGroup(availableTextures, defaultPath, c, usedTexture, strict);
        }
    }

    private static void tryAcceptingTextureGroup(Map<ResourceLocation, ArrayImage.Group> availableTextures, ResourceLocation defaultPath, Colormap c, Set<ResourceLocation> usedTexture, boolean strict) {
        ResourceLocation textureLoc = c.getTargetTexture(defaultPath);
        ArrayImage.Group group = availableTextures.get(textureLoc);
        ArrayImage texture = group != null ? group.getDefault() : null;
        ColormapsManager.tryAcceptingTexture(texture, textureLoc, c, usedTexture, strict);
    }

    private static void tryAcceptingTextureGroup(Map<ResourceLocation, ArrayImage.Group> textures, ResourceLocation id, IndexCompoundColorGetter colormap, Set<ResourceLocation> usedTextures, boolean strict) {
        Int2ObjectMap<IColorGetter> blockColorGetters = colormap.getGetters();
        for (Int2ObjectMap.Entry g : blockColorGetters.int2ObjectEntrySet()) {
            Colormap c;
            int index = g.getIntKey();
            BlockColor inner = (BlockColor)g.getValue();
            if (!(inner instanceof Colormap) || (c = (Colormap)inner).hasTexture()) continue;
            ArrayImage.Group textureMap = textures.get(c.getTargetTexture(id));
            if (strict && textureMap == null) {
                throw new IllegalStateException("Could not find a texture for tint index " + index + " for compound colormap " + String.valueOf(id) + ".Expected " + String.valueOf(id) + "_" + index);
            }
            if (blockColorGetters.size() == 1 || index == 0) {
                ColormapsManager.tryAcceptingTexture(textureMap.getDefault(), id, c, usedTextures, false);
            }
            try {
                ColormapsManager.tryAcceptingTexture((ArrayImage)textureMap.get(index), id, c, usedTextures, strict);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to apply a texture for tint index " + index + " for compound colormap " + String.valueOf(id) + ".Expected " + String.valueOf(id) + "_" + index + " : ", e);
            }
        }
    }

    public static void tryAcceptingTexture(Map<ResourceLocation, ArrayImage> availableTextures, ResourceLocation defaultPath, @Nullable Object col, Set<ResourceLocation> usedTexture, boolean strict) {
        if (col instanceof Colormap) {
            Colormap colormap = (Colormap)col;
            ResourceLocation textureLoc = colormap.getTargetTexture(defaultPath);
            ArrayImage texture = availableTextures.get(textureLoc);
            ColormapsManager.tryAcceptingTexture(texture, textureLoc, colormap, usedTexture, strict);
        }
    }

    private static void tryAcceptingTexture(@Nullable ArrayImage selectedTexture, ResourceLocation textureLoc, Colormap colormap, Set<ResourceLocation> usedTexture, boolean strict) {
        String colormapName;
        if (colormap.hasTexture()) {
            return;
        }
        String string = colormapName = colormap.inlined ? "Inlined Colormap from modifier " + textureLoc.toString() : "Colormap at " + textureLoc.toString();
        if (selectedTexture != null) {
            usedTexture.add(textureLoc);
            if (selectedTexture.pixels().length == 0) {
                throw new IllegalStateException("Colormap texture at location " + String.valueOf(textureLoc) + " had invalid 0 dimension");
            }
            colormap.acceptTexture(selectedTexture);
        } else {
            ResourceLocation explTarget = colormap.getExplicitTargetTexture();
            if (explTarget != null) {
                Polytone.LOGGER.error("Could not resolve explicit texture at location {}.png. Skipping", (Object)explTarget);
            }
            if (strict) {
                throw new IllegalStateException("Could not find any colormap texture .png associated with path " + String.valueOf(textureLoc) + " for colormap '" + colormapName + "'");
            }
        }
    }
}

