/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class Colormap
implements IColorGetter,
ColorResolver {
    private final IColormapNumberProvider xGetter;
    private final IColormapNumberProvider yGetter;
    private final BiomeIdMapper biomeMapper;
    private final boolean triangular;
    private final boolean rounds;
    private final boolean hasBiomeBlend;
    private final boolean usesBiome;
    private final boolean usesPos;
    private final boolean usesState;
    public boolean inlined = true;
    private Integer defaultColor;
    private ArrayImage image = null;
    @Nullable
    private ResourceLocation explicitTargetTexture;
    @Nullable
    protected Dynamic<?> lazyFallback;
    @Nullable
    protected IColorGetter fallback;
    private final ThreadLocal<BlockState> stateHack = new ThreadLocal();
    private final ThreadLocal<Integer> yHack = new ThreadLocal();
    public static final Codec<Colormap> DIRECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(ColorUtils.CODEC, "default_color").forGetter(c -> Optional.ofNullable(c.defaultColor)), (App)IColormapNumberProvider.CODEC.fieldOf("x_axis").forGetter(c -> c.xGetter), (App)IColormapNumberProvider.CODEC.fieldOf("y_axis").forGetter(c -> c.yGetter), (App)StrOpt.of(Codec.BOOL, "triangular", false).forGetter(c -> c.triangular), (App)Codec.BOOL.optionalFieldOf("rounds", (Object)true).forGetter(c -> c.rounds), (App)StrOpt.of(Codec.BOOL, "biome_blend").forGetter(c -> Optional.of(c.hasBiomeBlend)), (App)StrOpt.of(BiomeIdMapper.CODEC, "biome_id_mapper").forGetter(c -> Optional.of(c.biomeMapper)), (App)StrOpt.of(ResourceLocation.f_135803_, "texture_path").forGetter(c -> Optional.ofNullable(c.explicitTargetTexture)), (App)Codec.PASSTHROUGH.optionalFieldOf("fallback_colormap").forGetter(c -> Optional.empty())).apply((Applicative)i, Colormap::new));
    protected static final Codec<IColorGetter> SINGLE_COLOR_CODEC = ColorUtils.CODEC.xmap(Colormap::singleColor, c -> {
        Integer n;
        if (c instanceof Colormap) {
            Colormap cm = (Colormap)c;
            n = cm.defaultColor;
        } else {
            n = 0;
        }
        return n;
    });
    public static final Codec<IColorGetter> COLORMAP_CODEC = Codec.either(SINGLE_COLOR_CODEC, new ReferenceOrDirectCodec<Colormap>(Polytone.COLORMAPS.byNameCodec(), DIRECT_CODEC)).xmap(a -> (IColorGetter)a.map(b -> b, c -> c), Either::right);
    public static final Codec<IColorGetter> CODEC = COLORMAP_CODEC;

    private Colormap(Optional<Integer> defaultColor, IColormapNumberProvider xGetter, IColormapNumberProvider yGetter, boolean triangular, boolean rounds, Optional<Boolean> biomeBlend, Optional<BiomeIdMapper> biomeMapper, Optional<ResourceLocation> explicitTargetTexture, Optional<Dynamic<?>> fallback) {
        this.defaultColor = defaultColor.orElse(null);
        this.xGetter = xGetter;
        this.yGetter = yGetter;
        this.triangular = triangular;
        this.rounds = rounds;
        this.usesBiome = xGetter.usesBiome() || yGetter.usesBiome();
        this.usesPos = this.usesBiome || xGetter.usesPos() || yGetter.usesPos();
        this.usesState = xGetter.usesState() || yGetter.usesState();
        this.hasBiomeBlend = biomeBlend.orElse(this.usesBiome);
        this.biomeMapper = biomeMapper.orElse(BiomeIdMapper.BY_INDEX);
        this.explicitTargetTexture = explicitTargetTexture.orElse(null);
        this.lazyFallback = fallback.orElse(null);
    }

    protected Colormap(IColormapNumberProvider xGetter, IColormapNumberProvider yGetter, boolean triangular) {
        this(Optional.empty(), xGetter, yGetter, triangular, true, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public void acceptTexture(ArrayImage image) {
        this.image = image;
        if (this.defaultColor == null) {
            this.defaultColor = this.sample(0.5f, 0.5f, -1);
        }
    }

    public boolean hasTexture() {
        return this.image != null;
    }

    protected ResourceLocation getExplicitTargetTexture() {
        return this.explicitTargetTexture;
    }

    public ResourceLocation getTargetTexture(ResourceLocation def) {
        return this.explicitTargetTexture != null ? this.explicitTargetTexture : def;
    }

    public void setExplicitTargetTexture(ResourceLocation imageTarget) {
        this.explicitTargetTexture = imageTarget.m_247449_(imageTarget.m_135815_().replace(".png", ""));
    }

    public int m_92566_(@Nullable BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int i) {
        if (level == null) {
            return this.defaultColor;
        }
        if (pos == null && (this.usesPos || this.usesBiome)) {
            return this.defaultColor;
        }
        if (state == null && this.usesState) {
            return this.defaultColor;
        }
        if (this.hasBiomeBlend) {
            this.stateHack.set(state);
            this.yHack.set(pos != null ? pos.m_123342_() : 0);
            return level.m_6171_(pos, (ColorResolver)this);
        }
        Biome biome = null;
        if (this.usesBiome && level instanceof LevelReader) {
            LevelReader l = (LevelReader)level;
            biome = (Biome)l.m_204166_(pos).m_203334_();
        }
        return this.sampleColor(state, pos, biome, null);
    }

    public int sampleColor(@Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable ItemStack item) {
        float temperature = Mth.m_14036_((float)this.xGetter.getValue(state, pos, biome, this.biomeMapper, item), (float)0.0f, (float)1.0f);
        float humidity = Mth.m_14036_((float)this.yGetter.getValue(state, pos, biome, this.biomeMapper, item), (float)0.0f, (float)1.0f);
        int sampled = this.sample(humidity, temperature, this.defaultColor);
        if (this.fallback == null || sampled == 0) {
            // empty if block
        }
        return sampled;
    }

    public int m_130045_(Biome biome, double x, double z) {
        Integer y = this.yHack.get();
        if (y == null) {
            y = 0;
        }
        return this.sampleColor(this.stateHack.get(), BlockPos.m_274561_((double)x, (double)y.intValue(), (double)z), biome, null);
    }

    public int calculateBlendedColor(Level level, BlockPos pos) {
        int i = (Integer)Minecraft.m_91087_().f_91066_.m_232121_().m_231551_();
        BlockState state = this.stateHack.get();
        if (i == 0) {
            return this.sampleColor(state, pos, (Biome)level.m_204166_(pos).m_203334_(), null);
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int m = 0;
        Cursor3D cursor3D = new Cursor3D(pos.m_123341_() - i, pos.m_123342_(), pos.m_123343_() - i, pos.m_123341_() + i, pos.m_123342_(), pos.m_123343_() + i);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        while (cursor3D.m_122304_()) {
            mutableBlockPos.m_122178_(cursor3D.m_122305_(), cursor3D.m_122306_(), cursor3D.m_122307_());
            int n = this.sampleColor(state, (BlockPos)mutableBlockPos, (Biome)level.m_204166_((BlockPos)mutableBlockPos).m_203334_(), null);
            k += (n & 0xFF0000) >> 16;
            l += (n & 0xFF00) >> 8;
            m += n & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | m / j & 0xFF;
    }

    private int sample(float textY, float textX, int defValue) {
        if (this.triangular) {
            textY *= textX;
        }
        int width = this.image.width();
        int height = this.image.height();
        int wm = width - 1;
        int hm = height - 1;
        int scaledW = this.rounds ? Math.round(textX * (float)width) : Mth.m_14143_((float)(textX * (float)width));
        int scaledH = this.rounds ? Math.round(textY * (float)height) : Mth.m_14143_((float)(textY * (float)height));
        int w = Math.max(wm - scaledW, 0);
        int h = Math.max(hm - scaledH, 0);
        return this.image.pixels()[h][w];
    }

    public int m_92671_(ItemStack itemStack, int i) {
        BlockPos pos = null;
        Biome biome = null;
        if (this.usesPos) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return this.defaultColor;
            }
            pos = player.m_20183_();
            if (this.usesBiome) {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level == null) {
                    return this.defaultColor;
                }
                biome = (Biome)level.m_204166_(pos).m_203334_();
            }
        }
        return this.sampleColor(null, pos, biome, itemStack);
    }

    public static Colormap simple(IColormapNumberProvider xGetter, IColormapNumberProvider yGetter) {
        return new Colormap(xGetter, yGetter, false);
    }

    public static Colormap createFixed() {
        return new Colormap(Optional.empty(), IColormapNumberProvider.ZERO, IColormapNumberProvider.ZERO, false, true, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static Colormap singleColor(int color) {
        Colormap c = new Colormap(IColormapNumberProvider.ZERO, IColormapNumberProvider.ZERO, false);
        c.acceptTexture(new ArrayImage(new int[][]{{color}}));
        return c;
    }

    public static Colormap createDefSquare() {
        return new Colormap(IColormapNumberProvider.TEMPERATURE, IColormapNumberProvider.DOWNFALL, false);
    }

    public static Colormap createDefTriangle() {
        return new Colormap(IColormapNumberProvider.TEMPERATURE, IColormapNumberProvider.DOWNFALL, true);
    }

    public static Colormap createTimeStrip() {
        return new Colormap(IColormapNumberProvider.DAY_TIME, IColormapNumberProvider.ZERO, false);
    }

    public static Colormap createBiomeId() {
        return new Colormap(Optional.empty(), IColormapNumberProvider.BIOME_ID, IColormapNumberProvider.Y_LEVEL, false, false, Optional.of(Boolean.TRUE), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static Colormap createDamage() {
        return new Colormap(IColormapNumberProvider.DAMAGE, IColormapNumberProvider.ZERO, false);
    }
}

