/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockSetType;

public interface BlockSetTypeProvider {
    public static final Codec<BlockSetTypeProvider> CODEC = new ReferenceOrDirectCodec<Custom>(Polytone.BLOCK_SET.byNameCodec(), Custom.CODEC);

    public BlockSetType getOrCreate(BlockSetType var1, Optional<SoundType> var2);

    public record Custom(Optional<SoundEvent> doorClose, Optional<SoundEvent> doorOpen, Optional<SoundEvent> trapdoorClose, Optional<SoundEvent> trapdoorOpen, Optional<SoundEvent> pressurePlateClickOff, Optional<SoundEvent> pressurePlateClickOn, Optional<SoundEvent> buttonClickOff, Optional<SoundEvent> buttonClickOn) implements BlockSetTypeProvider
    {
        public static final Codec<Custom> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(BuiltInRegistries.f_256894_.m_194605_(), "door_close").forGetter(Custom::doorClose), (App)StrOpt.of(BuiltInRegistries.f_256894_.m_194605_(), "door_open").forGetter(Custom::doorOpen), (App)StrOpt.of(BuiltInRegistries.f_256894_.m_194605_(), "trapdoor_close").forGetter(Custom::trapdoorClose), (App)StrOpt.of(BuiltInRegistries.f_256894_.m_194605_(), "trapdoor_open").forGetter(Custom::trapdoorOpen), (App)StrOpt.of(BuiltInRegistries.f_256894_.m_194605_(), "pressure_plate_click_off").forGetter(Custom::pressurePlateClickOff), (App)StrOpt.of(BuiltInRegistries.f_256894_.m_194605_(), "pressure_plate_click_on").forGetter(Custom::pressurePlateClickOn), (App)StrOpt.of(BuiltInRegistries.f_256894_.m_194605_(), "button_click_off").forGetter(Custom::buttonClickOff), (App)StrOpt.of(BuiltInRegistries.f_256894_.m_194605_(), "button_click_on").forGetter(Custom::buttonClickOn)).apply((Applicative)instance, Custom::new));

        @Override
        public BlockSetType getOrCreate(BlockSetType original, Optional<SoundType> customSound) {
            return new BlockSetType(Polytone.BLOCK_SET.getNextName(), original.f_278463_(), customSound.orElse(original.f_271136_()), this.doorClose.orElse(original.f_271502_()), this.doorOpen.orElse(original.f_271141_()), this.trapdoorClose.orElse(original.f_271425_()), this.trapdoorOpen.orElse(original.f_271258_()), this.pressurePlateClickOff.orElse(original.f_271234_()), this.pressurePlateClickOn.orElse(original.f_271481_()), this.buttonClickOff.orElse(original.f_271194_()), this.buttonClickOn.orElse(original.f_271394_()));
        }
    }

    public record Vanilla(BlockSetType vanilla) implements BlockSetTypeProvider
    {
        @Override
        public BlockSetType getOrCreate(BlockSetType original, Optional<SoundType> customSound) {
            if (customSound.isEmpty() && original.f_278463_() == this.vanilla.f_278463_()) {
                return this.vanilla;
            }
            return new BlockSetType(Polytone.BLOCK_SET.getNextName(), original.f_278463_(), customSound.orElse(this.vanilla.f_271136_()), this.vanilla.f_271502_(), this.vanilla.f_271141_(), this.vanilla.f_271425_(), this.vanilla.f_271258_(), this.vanilla.f_271234_(), this.vanilla.f_271481_(), this.vanilla.f_271194_(), this.vanilla.f_271394_());
        }
    }
}

