/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.BaseExpression;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlockContextExpression
extends BaseExpression {
    public static final Codec<BlockContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new BlockContextExpression((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    private final boolean hasState;
    public static final BlockContextExpression ZERO = new BlockContextExpression("0");
    public static final BlockContextExpression ONE = new BlockContextExpression("1");
    public static final BlockContextExpression PARTICLE_RAND = new BlockContextExpression("(rand() * 2.0 - 1.0) * 0.4");

    public BlockContextExpression(String unparsed) {
        super(unparsed);
        this.hasState = unparsed.contains("state_prop");
    }

    @Override
    protected void buildFunctions(BaseExpression.FunBuilder builder) {
        super.buildFunctions(builder);
        builder.add(STATE_PROP);
        builder.add(STATE_PROP_INT);
    }

    public double getValue(Vec3 pos, float entityTime, Level level) {
        Entity e;
        ExpressionUtils.randomizeRandom();
        if (this.hasPos) {
            this.expression.setVariable("POS_X", pos.f_82479_);
            this.expression.setVariable("POS_Y", pos.f_82480_);
            this.expression.setVariable("POS_Z", pos.f_82481_);
        }
        BlockPos p = BlockPos.m_274446_((Position)pos);
        if (this.hasTime) {
            this.expression.setVariable("TIME", entityTime);
        }
        if (this.hasDayTime) {
            this.expression.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            this.expression.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            this.expression.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSkyLight) {
            this.expression.setVariable("SKY_LIGHT", level.m_45517_(LightLayer.SKY, p));
        }
        if (this.hasBlockLight) {
            this.expression.setVariable("BLOCK_LIGHT", level.m_45517_(LightLayer.BLOCK, p));
        }
        if (this.hasTemperature) {
            this.expression.setVariable("TEMPERATURE", ColorUtils.getClimateSettings((Biome)((Biome)level.m_204166_((BlockPos)p).m_203334_())).f_47681_);
        }
        if (this.hasDownfall) {
            this.expression.setVariable("DOWNFALL", ColorUtils.getClimateSettings((Biome)((Biome)level.m_204166_((BlockPos)p).m_203334_())).f_47683_);
        }
        if (this.hasState) {
            STATE_HACK.set(level.m_8055_(p));
        }
        if (this.hasPlayer) {
            e = Minecraft.m_91087_().m_91288_();
            this.expression.setVariable("PLAYER_X", e.m_20185_());
            this.expression.setVariable("PLAYER_Y", e.m_20186_());
            this.expression.setVariable("PLAYER_Z", e.m_20189_());
        }
        if (this.hasDistance) {
            e = Minecraft.m_91087_().m_91288_();
            double x = pos.f_82479_ - e.m_20185_();
            double y = pos.f_82480_ - e.m_20186_();
            double z = pos.f_82481_ - e.m_20189_();
            this.expression.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            this.expression.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            this.expression.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        return this.expression.evaluate();
    }

    public double getValue(Level level, @NotNull BlockPos pos, BlockState state) {
        Entity e;
        ExpressionUtils.seedRandom((long)pos.hashCode() * pos.m_121878_());
        if (this.hasPos) {
            this.expression.setVariable("POS_X", pos.m_123341_());
            this.expression.setVariable("POS_Y", pos.m_123342_());
            this.expression.setVariable("POS_Z", pos.m_123343_());
        }
        if (this.hasTime) {
            this.expression.setVariable("TIME", ClientFrameTicker.getGameTime());
        }
        if (this.hasDayTime) {
            this.expression.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            this.expression.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            this.expression.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSkyLight) {
            this.expression.setVariable("SKY_LIGHT", level.m_45517_(LightLayer.SKY, pos));
        }
        if (this.hasBlockLight) {
            this.expression.setVariable("BLOCK_LIGHT", level.m_45517_(LightLayer.BLOCK, pos));
        }
        if (this.hasTemperature) {
            this.expression.setVariable("TEMPERATURE", ColorUtils.getClimateSettings((Biome)((Biome)level.m_204166_((BlockPos)pos).m_203334_())).f_47681_);
        }
        if (this.hasDownfall) {
            this.expression.setVariable("DOWNFALL", ColorUtils.getClimateSettings((Biome)((Biome)level.m_204166_((BlockPos)pos).m_203334_())).f_47683_);
        }
        if (this.hasState) {
            STATE_HACK.set(state);
        }
        if (this.hasPlayer) {
            e = Minecraft.m_91087_().m_91288_();
            this.expression.setVariable("PLAYER_X", e.m_20185_());
            this.expression.setVariable("PLAYER_Y", e.m_20186_());
            this.expression.setVariable("PLAYER_Z", e.m_20189_());
        }
        if (this.hasDistance) {
            e = Minecraft.m_91087_().m_91288_();
            double x = (double)pos.m_123341_() - e.m_20185_();
            double y = (double)pos.m_123342_() - e.m_20186_();
            double z = (double)pos.m_123343_() - e.m_20189_();
            this.expression.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            this.expression.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            this.expression.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        return this.expression.evaluate();
    }
}

