/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;

public class BiomeIdMapperManager
extends JsonPartialReloader {
    private final MapRegistry<BiomeIdMapper> biomeIdMappers = new MapRegistry("Biome ID Mappers");

    public BiomeIdMapperManager() {
        super("biome_id_mappers");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.biomeIdMappers.clear();
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, RegistryAccess access) {
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            ResourceLocation id = j.getKey();
            BiomeIdMapper mapper = (BiomeIdMapper)((Pair)BiomeIdMapper.CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Biome ID mapper with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            try {
                this.biomeIdMappers.register(id, mapper);
            }
            catch (Exception e) {
                Polytone.LOGGER.warn("Found duplicate biome in biome id mapper {}", (Object)id);
            }
        }
    }

    @Override
    protected void applyWithLevel(RegistryAccess access, boolean isLogIn) {
    }

    public Codec<BiomeIdMapper> byNameCodec() {
        return this.biomeIdMappers;
    }
}

