/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeEffectModifier;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.fluid.FluidPropertyModifier;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class BiomeEffectsManager
extends JsonPartialReloader {
    private final Map<ResourceLocation, BiomeSpecialEffects> vanillaEffects = new HashMap<ResourceLocation, BiomeSpecialEffects>();
    private final Map<ResourceLocation, BiomeEffectModifier> effectsToApply = new HashMap<ResourceLocation, BiomeEffectModifier>();
    private boolean needsDynamicApplication = true;
    private final Map<Biome, BiomeEffectModifier> fogParametersModifiers = new HashMap<Biome, BiomeEffectModifier>();
    private static float lastFogDistanceMult = 1.0f;
    private static float lastFogEndMult = 1.0f;

    public BiomeEffectsManager() {
        super("biome_modifiers", "biome_effects");
    }

    @Override
    public void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, RegistryAccess access) {
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            ResourceLocation id = j.getKey();
            Optional<BiomeEffectModifier> effect = Parsed.parseOptional(BiomeEffectModifier.CODEC, json, ops, id, "biome modifier");
            effect.ifPresent(e -> this.addEffect(id, (BiomeEffectModifier)e, access));
        }
    }

    private void addEffect(ResourceLocation pathId, BiomeEffectModifier mod, RegistryAccess access) {
        Registry registry = access.m_175515_(Registries.f_256952_);
        for (Holder biome : mod.targets().compute(pathId, registry)) {
            this.effectsToApply.merge(((ResourceKey)biome.m_203543_().get()).m_135782_(), mod, BiomeEffectModifier::merge);
        }
    }

    @Override
    public void applyWithLevel(RegistryAccess registryAccess, boolean isLogIn) {
        if (!isLogIn && !this.needsDynamicApplication) {
            return;
        }
        this.needsDynamicApplication = false;
        if (isLogIn) {
            this.vanillaEffects.clear();
        }
        Registry biomeReg = (Registry)registryAccess.m_6632_(Registries.f_256952_).get();
        this.addAllWaterColors((Registry<Biome>)biomeReg, registryAccess);
        for (Map.Entry<ResourceLocation, BiomeEffectModifier> v : this.effectsToApply.entrySet()) {
            ResourceLocation biomeId = v.getKey();
            BiomeEffectModifier modifier = v.getValue();
            Optional biome = biomeReg.m_6612_(biomeId);
            if (!biome.isPresent()) continue;
            BiomeSpecialEffects old = modifier.apply((Biome)biome.get());
            this.vanillaEffects.put(biomeId, old);
            if (!modifier.modifyFogParameter()) continue;
            this.fogParametersModifiers.put((Biome)biome.get(), modifier);
        }
        if (!this.vanillaEffects.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Biome Effects Properties", (Object)this.vanillaEffects.size());
        }
    }

    @Override
    public void resetWithLevel(boolean isLogOff) {
        this.needsDynamicApplication = true;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            Registry biomeReg = (Registry)level.m_9598_().m_6632_(Registries.f_256952_).get();
            for (Map.Entry<ResourceLocation, BiomeSpecialEffects> v : this.vanillaEffects.entrySet()) {
                Optional biome = biomeReg.m_6612_(v.getKey());
                biome.ifPresent(bio -> BiomeEffectModifier.applyEffects(bio, (BiomeSpecialEffects)v.getValue()));
            }
        }
        this.vanillaEffects.clear();
        this.effectsToApply.clear();
        this.fogParametersModifiers.clear();
    }

    public void addAllWaterColors(Registry<Biome> biomeReg, RegistryAccess registryAccess) {
        FluidPropertyModifier water;
        if (Polytone.sodiumOn && (water = Polytone.FLUID_MODIFIERS.getModifier((Fluid)Fluids.f_76193_)) != null) {
            for (Map.Entry e : biomeReg.m_6579_()) {
                BlockColor blockColor;
                ResourceLocation id = ((ResourceKey)e.getKey()).m_135782_();
                Biome b = (Biome)e.getValue();
                BiomeEffectModifier original = this.effectsToApply.get(id);
                if (original != null && !original.waterColor().isEmpty() || !((blockColor = water.getTint()) instanceof Colormap)) continue;
                Colormap cl = (Colormap)blockColor;
                int col = cl.m_130045_(b, 0.0, 0.0);
                BiomeEffectModifier dummy = BiomeEffectModifier.ofWaterColor(col);
                this.addEffect(id, dummy, registryAccess);
            }
        }
    }

    @Nullable
    public Vec2 modifyFogParameters(float originalNearPlane, float originalFarPlane) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return null;
        }
        if (FogRenderer.m_234165_((Entity)player, (float)0.0f) != null) {
            return null;
        }
        Level level = player.m_9236_();
        Holder biome = level.m_204166_(player.m_20183_());
        BiomeEffectModifier fogMod = this.fogParametersModifiers.get(biome.m_203334_());
        Vec2 fogScalars = null;
        if (fogMod != null) {
            fogScalars = fogMod.modifyFogParameters(level);
        }
        if (fogScalars == null && (Mth.m_14154_((float)(lastFogDistanceMult - 1.0f)) > 0.02f || Mth.m_14154_((float)(lastFogEndMult - 1.0f)) > 0.02f)) {
            fogScalars = new Vec2(1.0f, 1.0f);
        }
        if (fogScalars != null) {
            float deltaTime = ClientFrameTicker.getDeltaTime();
            float interpolationFactor = deltaTime * 0.1f;
            lastFogDistanceMult = Mth.m_14179_((float)interpolationFactor, (float)lastFogDistanceMult, (float)fogScalars.f_82470_);
            lastFogEndMult = Mth.m_14179_((float)interpolationFactor, (float)lastFogEndMult, (float)fogScalars.f_82471_);
            float distance = originalFarPlane - originalNearPlane;
            return new Vec2((originalFarPlane - distance * lastFogDistanceMult) * lastFogEndMult, originalFarPlane * lastFogEndMult);
        }
        return null;
    }
}

