/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;

public class BiomeKeysCache {
    private static final ResourceKey<Biome> PLAINS = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)"minecraft:plains"));
    private static final ThreadLocal<Object2ObjectOpenHashMap<Biome, ResourceKey<Biome>>> CACHE = ThreadLocal.withInitial(Object2ObjectOpenHashMap::new);

    public static ResourceKey<Biome> get(@NotNull Biome biome) {
        ResourceKey k = (ResourceKey)CACHE.get().get((Object)biome);
        if (k == null) {
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return PLAINS;
            }
            return (ResourceKey)CACHE.get().computeIfAbsent((Object)biome, arg_0 -> BiomeKeysCache.lambda$get$0((Level)level, biome, arg_0));
        }
        return k;
    }

    public static void clear() {
        CACHE.get().clear();
    }

    private static /* synthetic */ ResourceKey lambda$get$0(Level level, Biome biome, Object b) {
        Optional biomeKey = level.registryAccess().lookupOrThrow(Registries.BIOME).getResourceKey((Object)biome);
        if (biomeKey.isEmpty()) {
            biomeKey = PlatStuff.getServerRegistryAccess().lookupOrThrow(Registries.BIOME).getResourceKey((Object)biome);
            if (biomeKey.isPresent()) {
                Polytone.LOGGER.error("Polytone detected a Server Biome was passed to a getColor client side function! This is a bug! Must be caused by some other mod!");
                return (ResourceKey)biomeKey.get();
            }
            throw new IllegalStateException("Failed to get biome key for biome: " + String.valueOf(biome) + " This means that biome registry returned an empty key for it. How is this possible? Was it not registered? Seriously HOW? Must be due to some mod doing unsafe stuff!! This is NOT a Polytone issue!");
        }
        return (ResourceKey)biomeKey.get();
    }
}

