/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.texture;

import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.texture.VariantTexture;
import net.mehvahdjukaar.polytone.utils.BakedQuadsTransformer;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class VariantTextureManager
extends JsonPartialReloader {
    private final WeakHashMap<BakedQuad, Map<ResourceLocation, BakedQuad>> variantQuadsCache = new WeakHashMap();
    private final Map<Block, VariantTexture> blocksWithVariants = new Object2ObjectOpenHashMap();
    private final Set<Block> forceTintBlocks = new HashSet<Block>();

    public VariantTextureManager() {
        super("variant_textures");
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            ResourceLocation id;
            JsonElement json = j.getValue();
            VariantTexture variant = Parsed.parseOrNull(VariantTexture.CODEC, json, ops, id = j.getKey(), "variant texture");
            if (variant == null) continue;
            this.addVariant(id, variant);
        }
    }

    @Override
    protected void applyWithLevel(HolderLookup.Provider access, boolean isLogIn) {
    }

    private void addVariant(ResourceLocation pathId, VariantTexture mod) {
        for (Holder b : mod.targets().compute(pathId, BuiltInRegistries.BLOCK)) {
            VariantTexture old = this.blocksWithVariants.put((Block)b.value(), mod);
            if (old == null) continue;
            Polytone.LOGGER.warn("Found 2 Variant Textures jsons with same targets ({}). Overriding", (Object)pathId);
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.blocksWithVariants.clear();
        this.variantQuadsCache.clear();
        this.forceTintBlocks.clear();
    }

    public boolean shouldSetTintTo0(int tintIndex, BlockAndTintGetter blockView, BlockState state, BlockPos blockPos) {
        if (tintIndex == -1 && !this.forceTintBlocks.isEmpty() && state != null) {
            return this.forceTintBlocks.contains(state.getBlock());
        }
        return false;
    }

    public BakedQuad maybeModify(BakedQuad quad, BlockAndTintGetter level, BlockState state, BlockPos pos) {
        Map<ResourceLocation, ResourceLocation> biomeToTexture;
        if (quad.tintIndex == -1 && !this.forceTintBlocks.isEmpty() && this.forceTintBlocks.contains(state.getBlock())) {
            quad.tintIndex = 0;
        }
        if (this.blocksWithVariants.isEmpty()) {
            return null;
        }
        Block block = state.getBlock();
        VariantTexture variant = this.blocksWithVariants.get(block);
        if (variant != null && (biomeToTexture = variant.getBiomeMap(quad.getSprite())) != null && level instanceof RenderChunkRegion) {
            RenderChunkRegion region = (RenderChunkRegion)level;
            Holder biome = region.level.getBiome(pos);
            ResourceLocation biomeLoc = ((ResourceKey)biome.unwrapKey().get()).location();
            ResourceLocation newTexture = biomeToTexture.get(biomeLoc);
            if (newTexture != null) {
                return this.getOrCreateQuad(quad, biomeLoc, newTexture);
            }
        }
        return null;
    }

    @NotNull
    private BakedQuad getOrCreateQuad(BakedQuad quad, ResourceLocation biome, ResourceLocation newTexture) {
        return this.variantQuadsCache.computeIfAbsent(quad, q -> new WeakHashMap()).computeIfAbsent(biome, b -> {
            TextureAtlasSprite s = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(newTexture);
            BakedQuadsTransformer transformer = BakedQuadsTransformer.create().applyingSprite(s);
            return transformer.transform(quad);
        });
    }

    public void addTintOverrideHack(Block block) {
        if (block != Blocks.GRASS_BLOCK) {
            this.forceTintBlocks.add(block);
        }
    }
}

