/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.color;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.color.MapColorHelper;
import net.mehvahdjukaar.polytone.mixins.accessor.DustParticleOptionAccessor;
import net.mehvahdjukaar.polytone.mixins.accessor.SheepAccessor;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.SingleJsonOrPropertiesReloadListener;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.state.ExperienceOrbRenderState;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ColorManager
extends SingleJsonOrPropertiesReloadListener {
    private static final int DEFAULT_COLOR = ARGB.colorFromFloat((float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    private final Object2IntMap<MapColor> vanillaMapColors = new Object2IntOpenHashMap();
    private final Map<DyeColor, Integer> vanillaFireworkColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<DyeColor, Integer> vanillaDiffuseColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<DyeColor, Integer> vanillaTextColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    private final Map<ChatFormatting, Integer> vanillaChatFormatting = new EnumMap<ChatFormatting, Integer>(ChatFormatting.class);
    private final Object2IntMap<MobEffect> vanillaEffectColors = new Object2IntOpenHashMap();
    private final EnumMap<BorderStatus, Integer> vanillaBorderStatus = new EnumMap(BorderStatus.class);
    private final Map<DyeColor, Integer> customSheepColors = new EnumMap<DyeColor, Integer>(DyeColor.class);
    protected final int[] originalRedstoneWireColors = Arrays.copyOf(RedStoneWireBlock.COLORS, RedStoneWireBlock.COLORS.length);
    @Nullable
    private BlockContextExpression xpOrbColor;
    @Nullable
    private BlockContextExpression xpOrbColorR;
    @Nullable
    private BlockContextExpression xpOrbColorG;
    @Nullable
    private BlockContextExpression xpOrbColorB;
    private int xpBar = 8453920;
    private Integer splash = null;

    public ColorManager() {
        super("color.properties", "colors.json", new String[]{"polytone", "colormatic", "vanadium", "optifine"});
    }

    public int getXpBar() {
        return this.xpBar;
    }

    public Integer getSplash() {
        return this.splash;
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, Properties> properties, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        ArrayList<ResourceLocation> keySet = new ArrayList<ResourceLocation>(properties.keySet());
        Lists.reverse(keySet);
        for (ResourceLocation k : keySet) {
            Properties p = properties.get(k);
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                Object object = e.getKey();
                if (!(object instanceof String)) continue;
                String key = (String)object;
                String[] split = key.split("\\.");
                try {
                    this.parseColor(split, e.getValue(), k);
                }
                catch (Exception e1) {
                    Polytone.LOGGER.error("Failed to parse color property {} in file {}", (Object)key, (Object)k);
                }
            }
        }
        this.regenSheepColors();
    }

    private void parseColor(String[] prop, Object obj, ResourceLocation colorPropFileId) {
        if (!(obj instanceof String)) {
            return;
        }
        String str = (String)obj;
        if (this.is(prop, 0, "map")) {
            String name = this.get(prop, 1);
            MapColor color = MapColorHelper.byName(name);
            if (color != null) {
                int col = ColorManager.parseHex(obj);
                if (!this.vanillaMapColors.containsKey((Object)color)) {
                    this.vanillaMapColors.put((Object)color, color.col);
                }
                color.col = col;
            } else {
                Polytone.LOGGER.warn("Unknown MapColor with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "dye")) {
            String name = this.get(prop, 1);
            DyeColor color = DyeColor.byName((String)name, null);
            if (color != null) {
                String param = this.get(prop, 2);
                int col = ColorManager.parseHex(obj);
                if (param == null || param.equals("diffuse")) {
                    if (!this.vanillaDiffuseColors.containsKey(color)) {
                        this.vanillaDiffuseColors.put(color, color.getTextureDiffuseColor());
                    }
                    color.textureDiffuseColor = ARGB.opaque((int)col);
                } else if (param.equals("firework")) {
                    if (!this.vanillaFireworkColors.containsKey(color)) {
                        this.vanillaFireworkColors.put(color, color.fireworkColor);
                    }
                    color.fireworkColor = col;
                } else if (param.equals("text")) {
                    if (!this.vanillaTextColors.containsKey(color)) {
                        this.vanillaTextColors.put(color, color.textColor);
                    }
                    color.textColor = col;
                }
            } else {
                Polytone.LOGGER.warn("Unknown DyeColor with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "particle") && prop.length > 1) {
            String s = prop[1];
            ResourceLocation id = ResourceLocation.parse((String)s.replace("\\", ""));
            try {
                int hex = ColorManager.parseHex(str);
                Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, String.valueOf(hex));
            }
            catch (Exception e) {
                Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, str);
            }
        } else if (this.is(prop, 0, "world_border") && prop.length > 1) {
            String name = this.get(prop, 1);
            try {
                BorderStatus status = BorderStatus.valueOf((String)name.toLowerCase(Locale.ROOT));
                int col = ColorManager.parseHex(obj);
                if (!this.vanillaBorderStatus.containsKey(status)) {
                    this.vanillaBorderStatus.put(status, status.getColor());
                }
                status.color = col;
            }
            catch (Exception ignored) {
                Polytone.LOGGER.warn("Unknown BorderStatus with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "potion") || this.is(prop, 0, "effect")) {
            ResourceLocation id = ResourceLocation.parse((String)prop[1].replace("\\", ""));
            int col = ColorManager.parseHex(obj);
            if (!id.getPath().equals("empty")) {
                if (id.getPath().equals("water")) {
                    PotionContents.BASE_POTION_COLOR = col;
                } else {
                    MobEffect effect = BuiltInRegistries.MOB_EFFECT.getOptional(id).orElse(null);
                    if (effect != null) {
                        if (!this.vanillaEffectColors.containsKey((Object)effect)) {
                            this.vanillaEffectColors.put((Object)effect, effect.getColor());
                        }
                        effect.color = col;
                    } else {
                        Polytone.LOGGER.warn("Unknown Mob Effect with name {}", (Object)id);
                    }
                }
            }
        } else if (this.is(prop, 0, "sheep")) {
            String name = this.get(prop, 1);
            DyeColor color = DyeColor.byName((String)name, null);
            if (color != null) {
                int col = ARGB.opaque((int)ColorManager.parseHex(obj));
                this.customSheepColors.put(color, col);
            } else {
                Polytone.LOGGER.warn("Unknown Dye Color with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "xporb")) {
            if (this.is(prop, 1, "color")) {
                this.xpOrbColor = new BlockContextExpression(str);
            } else if (this.is(prop, 1, "red")) {
                this.xpOrbColorR = new BlockContextExpression(str);
            } else if (this.is(prop, 1, "green")) {
                this.xpOrbColorG = new BlockContextExpression(str);
            } else if (this.is(prop, 1, "blue")) {
                this.xpOrbColorB = new BlockContextExpression(str);
            }
        } else if (this.is(prop, 0, "redstone")) {
            String ind = this.get(prop, 1);
            if (ind != null) {
                int code = Integer.parseInt(ind);
                if (code < RedStoneWireBlock.COLORS.length) {
                    int col = ColorManager.parseHex(obj);
                    float[] rgb = ColorUtils.unpack(col);
                    RedStoneWireBlock.COLORS[code] = ARGB.colorFromFloat((float)1.0f, (float)rgb[0], (float)rgb[1], (float)rgb[2]);
                    if (code == 15) {
                        int maxPower;
                        DustParticleOptions.REDSTONE_PARTICLE_COLOR = maxPower = ARGB.colorFromFloat((float)1.0f, (float)rgb[0], (float)rgb[1], (float)rgb[2]);
                        ((DustParticleOptionAccessor)DustParticleOptions.REDSTONE).setColor(maxPower);
                    }
                } else {
                    Polytone.LOGGER.warn("Redstone color index must be between 0 and 15");
                }
            }
        } else if (this.is(prop, 0, "text")) {
            int col = ColorManager.parseHex(obj);
            ChatFormatting text = null;
            if (this.is(prop, 1, "splash")) {
                this.splash = col;
            } else if (this.is(prop, 1, "xpbar")) {
                this.xpBar = col;
            } else if (this.is(prop, 1, "code")) {
                s = this.get(prop, 2);
                if (s != null) {
                    int code = Integer.parseInt(s);
                    text = ChatFormatting.getById((int)code);
                }
            } else {
                s = this.get(prop, 1);
                text = ChatFormatting.getByName((String)s);
            }
            if (text != null) {
                if (!this.vanillaChatFormatting.containsKey(text)) {
                    this.vanillaChatFormatting.put(text, text.getColor());
                }
                text.color = col;
                TextColor tc = TextColor.fromLegacyFormat(text);
                tc.value = col;
            }
        } else if (this.is(prop, 0, "palette") && this.is(prop, 1, "block") && prop.length > 2 && obj instanceof String) {
            String path = prop[2].replace("~/colormap/", colorPropFileId.getNamespace() + ":");
            Polytone.BLOCK_MODIFIERS.addSimpleColormap(ResourceLocation.parse((String)path), str);
        }
    }

    private boolean is(String[] array, int index, String value) {
        if (array.length <= index) {
            return false;
        }
        return array[index].equals(value);
    }

    @Nullable
    private String get(String[] array, int index) {
        if (array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Nullable
    private <T> T get(String[] array, int index, Function<String, T> fun) {
        if (array.length <= index) {
            return null;
        }
        return fun.apply(array[index]);
    }

    private static int parseHex(Object obj) {
        if (obj instanceof String) {
            String value = (String)obj;
            value = value.replace("#", "").replace("0x", "");
            return Integer.parseInt(value.trim(), 16);
        }
        throw new JsonParseException("Failed to parse object " + String.valueOf(obj) + ". Expected a String");
    }

    @Override
    protected void applyWithLevel(HolderLookup.Provider access, boolean isLogIn) {
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        MapColor color;
        PotionContents.BASE_POTION_COLOR = 3694022;
        this.xpBar = 8453920;
        this.xpOrbColor = null;
        this.xpOrbColorR = null;
        this.xpOrbColorG = null;
        this.xpOrbColorB = null;
        for (Map.Entry entry : this.vanillaMapColors.entrySet()) {
            color = (MapColor)entry.getKey();
            color.col = (Integer)entry.getValue();
        }
        this.vanillaMapColors.clear();
        for (Map.Entry entry : this.vanillaDiffuseColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.textureDiffuseColor = (Integer)entry.getValue();
        }
        this.vanillaDiffuseColors.clear();
        for (Map.Entry entry : this.vanillaFireworkColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.fireworkColor = (Integer)entry.getValue();
        }
        this.vanillaFireworkColors.clear();
        for (Map.Entry entry : this.vanillaTextColors.entrySet()) {
            color = (DyeColor)entry.getKey();
            color.textColor = (Integer)entry.getValue();
        }
        this.vanillaTextColors.clear();
        for (Map.Entry entry : this.vanillaChatFormatting.entrySet()) {
            ChatFormatting text = (ChatFormatting)entry.getKey();
            text.color = (Integer)entry.getValue();
            TextColor tc = TextColor.fromLegacyFormat((ChatFormatting)text);
            tc.value = (Integer)entry.getValue();
        }
        RedStoneWireBlock.COLORS = Arrays.copyOf(this.originalRedstoneWireColors, this.originalRedstoneWireColors.length);
        DustParticleOptions.REDSTONE_PARTICLE_COLOR = DEFAULT_COLOR;
        ((DustParticleOptionAccessor)DustParticleOptions.REDSTONE).setColor(DustParticleOptions.REDSTONE_PARTICLE_COLOR);
    }

    public void regenSheepColors() {
        Sheep.COLOR_BY_DYE = new EnumMap(DyeColor.class);
        for (DyeColor d : DyeColor.values()) {
            Sheep.COLOR_BY_DYE.put(d, SheepAccessor.invokeCreateSheepColor(d));
        }
        Sheep.COLOR_BY_DYE.putAll(this.customSheepColors);
        this.customSheepColors.clear();
    }

    public float @Nullable [] getXpOrbColor(ExperienceOrbRenderState orb, float partialTicks) {
        Vec3 orbPos = new Vec3(orb.x, orb.y, orb.z);
        ClientLevel level = Minecraft.getInstance().level;
        if (this.xpOrbColor != null) {
            int color = (int)this.xpOrbColor.getValue(orbPos, orb.ageInTicks + partialTicks, (Level)level);
            return ColorUtils.unpack(color);
        }
        if (this.xpOrbColorR == null && this.xpOrbColorG == null && this.xpOrbColorB == null) {
            return null;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (this.xpOrbColorR != null) {
            r = (float)this.xpOrbColorR.getValue(orbPos, orb.ageInTicks + partialTicks, (Level)level);
        }
        if (this.xpOrbColorG != null) {
            g = (float)this.xpOrbColorG.getValue(orbPos, orb.ageInTicks + partialTicks, (Level)level);
        }
        if (this.xpOrbColorB != null) {
            b = (float)this.xpOrbColorB.getValue(orbPos, orb.ageInTicks + partialTicks, (Level)level);
        }
        return new float[]{r, g, b};
    }
}

