/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.mehvahdjukaar.polytone.utils.PropertiesUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;

public abstract class SingleJsonOrPropertiesReloadListener
extends PartialReloader<Map<ResourceLocation, Properties>> {
    private static final Gson GSON = new Gson();
    private final String[] locations;
    private final String propertiesName;
    private final String jsonName;

    protected SingleJsonOrPropertiesReloadListener(String propertiesName, String jsonName, String ... possibleLocations) {
        super("color_manager");
        this.locations = possibleLocations;
        this.propertiesName = propertiesName;
        this.jsonName = jsonName;
    }

    @Override
    protected Map<ResourceLocation, Properties> prepare(ResourceManager resourceManager) {
        HashMap<ResourceLocation, Properties> list = new HashMap<ResourceLocation, Properties>();
        for (String paths : this.locations) {
            BufferedReader reader;
            ResourceLocation id2;
            List resourceStack;
            Map resources = resourceManager.listResourceStacks(paths, id -> id.getPath().endsWith(this.propertiesName));
            for (Map.Entry entrySet : resources.entrySet()) {
                resourceStack = (List)entrySet.getValue();
                id2 = (ResourceLocation)entrySet.getKey();
                for (Resource resource : resourceStack) {
                    try {
                        reader = resource.openAsReader();
                        try {
                            Properties properties = new Properties();
                            properties.load(reader);
                            list.merge(id2, properties, (properties1, properties2) -> {
                                properties1.putAll((Map<?, ?>)properties2);
                                return properties1;
                            });
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (JsonParseException | IOException | IllegalArgumentException ex) {
                        Polytone.LOGGER.error("Couldn't parse data file {}:", (Object)resourceStack, (Object)ex);
                    }
                }
            }
            resources = resourceManager.listResourceStacks(paths, id -> id.getPath().endsWith(this.jsonName));
            for (Map.Entry entrySet : resources.entrySet()) {
                resourceStack = (List)entrySet.getValue();
                id2 = (ResourceLocation)entrySet.getKey();
                for (Resource resource : resourceStack) {
                    try {
                        reader = resource.openAsReader();
                        try {
                            JsonElement jsonElement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
                            Properties prop = PropertiesUtils.jsonToProperties(jsonElement);
                            if (list.containsKey(id2)) {
                                Polytone.LOGGER.warn("Found duplicate color.json with path {}. Old one will be overwritten. Be sure to put this file in your own namespace, not minecraft one!", (Object)id2);
                            }
                            list.put(id2, prop);
                        }
                        finally {
                            if (reader == null) continue;
                            ((Reader)reader).close();
                        }
                    }
                    catch (JsonParseException | IOException | IllegalArgumentException ex) {
                        Polytone.LOGGER.error("Couldn't parse data file {}:", (Object)resource, (Object)ex);
                    }
                }
            }
        }
        return ImmutableMap.copyOf(list);
    }
}

