/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.Polytone;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ARGB;

public record ArrayImage(int[][] pixels, int width, int height) {
    public ArrayImage(int[][] matrix) {
        this(matrix, matrix[0].length, matrix.length);
    }

    public static Map<ResourceLocation, ArrayImage> scanDirectory(ResourceManager manager, String path) {
        HashMap<ResourceLocation, ArrayImage> map = new HashMap<ResourceLocation, ArrayImage>();
        ArrayImage.scanDirectory(manager, path, map);
        return map;
    }

    public static void scanDirectory(ResourceManager manager, String path, Map<ResourceLocation, ArrayImage> map) {
        FileToIdConverter helper = new FileToIdConverter(path, ".png");
        for (Map.Entry entry : helper.listMatchingResources(manager).entrySet()) {
            ResourceLocation fileId = (ResourceLocation)entry.getKey();
            ResourceLocation id = helper.fileToId(fileId);
            try {
                InputStream inputStream = ((Resource)entry.getValue()).open();
                try {
                    NativeImage nativeImage = NativeImage.read((InputStream)inputStream);
                    try {
                        int[][] pixels = ArrayImage.makePixelMatrix(nativeImage);
                        ArrayImage image = new ArrayImage(pixels, nativeImage.getWidth(), nativeImage.getHeight());
                        ArrayImage oldImage = map.put(id, image);
                        if (oldImage == null) continue;
                        throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(id));
                    }
                    finally {
                        if (nativeImage == null) continue;
                        nativeImage.close();
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException | IllegalArgumentException | UnsupportedOperationException var14) {
                Polytone.LOGGER.error("Couldn't parse texture file {} from {}", (Object)id, (Object)fileId, (Object)var14);
            }
        }
    }

    private static int[][] makePixelMatrix(NativeImage nativeImage) {
        if (nativeImage.format() != NativeImage.Format.RGBA) {
            throw new UnsupportedOperationException("Can only call makePixelMatrix for RGBA images.");
        }
        int width = nativeImage.getWidth();
        int height = nativeImage.getHeight();
        int[][] pixelMatrix = new int[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int pixel = nativeImage.getPixel(j, i);
                pixelMatrix[i][j] = ARGB.color((int)255, (int)ARGB.red((int)pixel), (int)ARGB.green((int)pixel), (int)ARGB.blue((int)pixel));
            }
        }
        return pixelMatrix;
    }

    public static Map<ResourceLocation, Group> groupTextures(Map<ResourceLocation, ArrayImage> texturesColormap) {
        LinkedHashMap<ResourceLocation, Group> groupedMap = new LinkedHashMap<ResourceLocation, Group>();
        Pattern pattern = Pattern.compile("(\\D+)(_\\d+)?");
        for (Map.Entry<ResourceLocation, ArrayImage> e : texturesColormap.entrySet()) {
            ResourceLocation id = e.getKey();
            String str = id.getPath();
            Matcher matcher = pattern.matcher(str);
            if (matcher.matches()) {
                String key = matcher.group(1);
                String indexMatch = matcher.group(2);
                int index = -1;
                if (indexMatch != null) {
                    index = Integer.parseInt(indexMatch.substring(1));
                }
                groupedMap.computeIfAbsent(id.withPath(key), a -> new Group()).put(index, e.getValue());
                continue;
            }
            Group group = new Group();
            group.put(-1, e.getValue());
            groupedMap.put(id, group);
        }
        return groupedMap;
    }

    public static class Group
    extends Int2ObjectArrayMap<ArrayImage> {
        public ArrayImage getDefault() {
            return (ArrayImage)this.get(-1);
        }
    }
}

