/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;

public record WidgetModifier(int xOffset, int yOffset, int width, Optional<String> message, Optional<Integer> targetX, Optional<Integer> targetY, Optional<Integer> targetW, Optional<Integer> targetH, Optional<String> targetMessage, Optional<String> targetClass) {
    public static final Codec<WidgetModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(WidgetModifier::xOffset), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(WidgetModifier::yOffset), (App)Codec.INT.optionalFieldOf("width_increment", (Object)0).forGetter(WidgetModifier::width), (App)Codec.STRING.optionalFieldOf("message").forGetter(WidgetModifier::message), (App)Codec.INT.optionalFieldOf("target_x").forGetter(WidgetModifier::targetX), (App)Codec.INT.optionalFieldOf("target_y").forGetter(WidgetModifier::targetY), (App)Codec.INT.optionalFieldOf("target_width").forGetter(WidgetModifier::targetY), (App)Codec.INT.optionalFieldOf("target_height").forGetter(WidgetModifier::targetY), (App)Codec.STRING.optionalFieldOf("target_message").forGetter(WidgetModifier::targetMessage), (App)Codec.STRING.xmap(PlatStuff::maybeRemapName, PlatStuff::maybeRemapName).optionalFieldOf("target_class_name").forGetter(WidgetModifier::targetClass)).apply((Applicative)i, WidgetModifier::new)).comapFlatMap(o -> {
        if (o.targetW.isEmpty() && o.targetH.isEmpty() && o.targetX.isEmpty() && o.targetClass.isEmpty() && o.targetY.isEmpty() && o.targetMessage.isEmpty()) {
            return DataResult.error(() -> "Widget modifier must have at least one target");
        }
        return DataResult.success((Object)o);
    }, Function.identity());

    public void maybeModify(AbstractWidget widget) {
        if (this.targetX.isPresent() && widget.getX() != this.targetX.get().intValue()) {
            return;
        }
        if (this.targetY.isPresent() && widget.getY() != this.targetY.get().intValue()) {
            return;
        }
        if (this.targetH.isPresent() && widget.getHeight() != this.targetH.get().intValue()) {
            return;
        }
        if (this.targetW.isPresent() && widget.getWidth() != this.targetW.get().intValue()) {
            return;
        }
        if (this.targetMessage.isPresent() && !widget.getMessage().getString().equals(this.targetMessage.get())) {
            return;
        }
        if (this.targetClass.isPresent()) {
            String name = this.targetClass.get();
            if (!widget.getClass().getSimpleName().equals(name) && !widget.getClass().getName().equals(name)) {
                return;
            }
        }
        widget.setX(widget.getX() + this.xOffset);
        widget.setY(widget.getY() + this.yOffset);
        widget.setWidth(widget.getWidth() + this.width);
        this.message.ifPresent(s -> widget.setMessage((Component)Component.translatable((String)s)));
    }
}

