/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.google.gson.JsonElement;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.slotify.BlitModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class GuiOverlayManager
extends JsonPartialReloader {
    private final Map<Gui.HeartType, HeartSprites> heartSprites = new EnumMap<Gui.HeartType, HeartSprites>(Gui.HeartType.class);
    private final Map<ResourceLocation, BlitModifier> blitModifiers = new HashMap<ResourceLocation, BlitModifier>();
    private int index = 0;
    private boolean active = false;

    public GuiOverlayManager() {
        super("overlay_modifiers");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.blitModifiers.clear();
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            ResourceLocation id;
            JsonElement json = j.getValue();
            BlitModifier effect = Parsed.parseOrNull(BlitModifier.CODEC, json, ops, id = j.getKey(), "overlay modifier");
            if (effect == null) continue;
            ResourceLocation textureId = effect.target();
            if (this.blitModifiers.containsKey(textureId)) {
                Polytone.LOGGER.warn("Overlay Modifier with texture id {} already exists. Overwriting", (Object)textureId);
            }
            this.blitModifiers.put(textureId, effect);
        }
    }

    @Override
    protected void applyWithLevel(HolderLookup.Provider access, boolean isLogIn) {
    }

    @Override
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager) {
        this.reloadHearths(resourceManager);
        return super.prepare(resourceManager);
    }

    public boolean maybeModifyBlit(GuiGraphics gui, Function<ResourceLocation, RenderType> function, MultiBufferSource.BufferSource buffer, TextureAtlasSprite sprite, int x, int y, int width, int height, int color) {
        if (!this.active || this.blitModifiers.isEmpty()) {
            return false;
        }
        BlitModifier mod = this.blitModifiers.get(sprite.contents().name());
        if (mod != null) {
            int ind = mod.index();
            if (ind == -1 || ind == this.index) {
                mod.blitModified(gui, function, buffer, sprite, x, x + width, y, y + height, color);
                return true;
            }
            ++this.index;
        }
        return false;
    }

    public void onStartRenderingOverlay() {
        this.index = 0;
        this.active = true;
    }

    public void onEndRenderingOverlay() {
        this.active = false;
    }

    private void reloadHearths(ResourceManager manager) {
        this.heartSprites.clear();
        for (Gui.HeartType h : Gui.HeartType.values()) {
            if (h == Gui.HeartType.CONTAINER || h == Gui.HeartType.NORMAL) continue;
            String name = h.name().toLowerCase(Locale.ROOT);
            ResourceLocation fullRes = ResourceLocation.parse((String)("textures/gui/sprites/polytone/heart/container_" + name + "_full.png"));
            ResourceLocation halfRes = ResourceLocation.parse((String)("textures/gui/sprites/polytone/heart/container_" + name + "_half.png"));
            if (!manager.getResource(fullRes).isPresent() || !manager.getResource(halfRes).isPresent()) continue;
            ResourceLocation fullBlinkingRes = Polytone.res("textures/gui/sprites/polytone/heart/container_" + name + "_full_blinking.png");
            Optional fullBlinking = manager.getResource(fullBlinkingRes);
            ResourceLocation halfBlinkingRes = Polytone.res("textures/gui/sprites/polytone/heart/container_" + name + "_half_blinking.png");
            Optional halfBlinking = manager.getResource(halfBlinkingRes);
            ResourceLocation hardcoreFullRes = Polytone.res("textures/gui/sprites/polytone/heart/container_" + name + "_hardcore_full.png");
            Optional hardcoreFull = manager.getResource(hardcoreFullRes);
            ResourceLocation hardcoreFullBlinkingRes = Polytone.res("textures/gui/sprites/polytone/heart/container_" + name + "_hardcore_full_blinking.png");
            Optional hardcoreFullBlinking = manager.getResource(hardcoreFullBlinkingRes);
            ResourceLocation hardcoreHalfRes = Polytone.res("textures/gui/sprites/polytone/heart/container_" + name + "_hardcore_half.png");
            Optional hardcoreHalf = manager.getResource(hardcoreHalfRes);
            ResourceLocation hardcoreHalfBlinkingRes = Polytone.res("textures/gui/sprites/polytone/heart/container_" + name + "_hardcore_half_blinking.png");
            Optional hardcoreHalfBlinking = manager.getResource(hardcoreHalfBlinkingRes);
            if (fullBlinking.isEmpty()) {
                fullBlinkingRes = fullRes;
            }
            if (halfBlinking.isEmpty()) {
                halfBlinkingRes = halfRes;
            }
            if (hardcoreFull.isEmpty()) {
                hardcoreFullRes = fullRes;
            }
            if (hardcoreFullBlinking.isEmpty()) {
                hardcoreFullBlinkingRes = hardcoreFullRes;
            }
            if (hardcoreHalf.isEmpty()) {
                hardcoreHalfRes = halfRes;
            }
            if (hardcoreHalfBlinking.isEmpty()) {
                hardcoreHalfBlinkingRes = hardcoreHalfRes;
            }
            fullRes = fullRes.withPath(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            halfRes = halfRes.withPath(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            fullBlinkingRes = fullBlinkingRes.withPath(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            halfBlinkingRes = halfBlinkingRes.withPath(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            hardcoreFullRes = hardcoreFullRes.withPath(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            hardcoreFullBlinkingRes = hardcoreFullBlinkingRes.withPath(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            hardcoreHalfRes = hardcoreHalfRes.withPath(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            hardcoreHalfBlinkingRes = hardcoreHalfBlinkingRes.withPath(p -> p.replace("textures/gui/sprites/", "").replace(".png", ""));
            this.heartSprites.put(h, new HeartSprites(fullRes, halfRes, fullBlinkingRes, halfBlinkingRes, hardcoreFullRes, hardcoreHalfRes, hardcoreFullBlinkingRes, hardcoreHalfBlinkingRes));
        }
    }

    public boolean maybeFancifyHeart(Gui instance, GuiGraphics graphics, Gui.HeartType actualType, int i, int j, boolean bl, boolean bl2, boolean bl3) {
        if (this.heartSprites.isEmpty()) {
            return false;
        }
        HeartSprites sprites = this.heartSprites.get(actualType);
        if (sprites != null) {
            graphics.blitSprite(RenderType::guiTextured, sprites.getSprite(bl, bl3, bl2), i, j, 9, 9);
            return true;
        }
        return false;
    }

    private record HeartSprites(ResourceLocation full, ResourceLocation half, ResourceLocation fullBlinking, ResourceLocation halfBlinking, ResourceLocation hardcoreFull, ResourceLocation hardcoreHalf, ResourceLocation hardcoreFullBlinking, ResourceLocation hardcoreHalfBlinking) {
        public ResourceLocation getSprite(boolean bl, boolean bl2, boolean bl3) {
            if (!bl) {
                if (bl2) {
                    return bl3 ? this.halfBlinking : this.half;
                }
                return bl3 ? this.fullBlinking : this.full;
            }
            if (bl2) {
                return bl3 ? this.hardcoreHalfBlinking : this.hardcoreHalf;
            }
            return bl3 ? this.hardcoreFullBlinking : this.hardcoreFull;
        }
    }
}

