/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.particle.ParticleModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ParticleModifiersManager
extends JsonPartialReloader {
    private final Multimap<ParticleType<?>, ParticleModifier> particleModifiers = HashMultimap.create();

    public ParticleModifiersManager() {
        super("particle_modifiers");
    }

    public void maybeModify(ParticleOptions options, Level level, @NotNull Particle particle) {
        Collection mod = this.particleModifiers.get((Object)options.getType());
        for (ParticleModifier modifier : mod) {
            modifier.modify(particle, level, options);
        }
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        for (Map.Entry<ResourceLocation, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            ResourceLocation id = j.getKey();
            Optional<ParticleModifier> modifier = Parsed.parseOptional(ParticleModifier.CODEC, json, ops, id, "particle modifier");
            modifier.ifPresent(m -> this.addModifier(id, (ParticleModifier)m));
        }
    }

    @Override
    protected void applyWithLevel(HolderLookup.Provider access, boolean isLogIn) {
        if (!this.particleModifiers.isEmpty()) {
            Polytone.LOGGER.info("Registered {} particle modifiers", (Object)this.particleModifiers.size());
        }
    }

    private void addModifier(ResourceLocation pathId, ParticleModifier mod) {
        for (Holder particle : mod.targets().compute(pathId, BuiltInRegistries.PARTICLE_TYPE)) {
            this.particleModifiers.put((Object)((ParticleType)particle.value()), (Object)mod);
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.particleModifiers.clear();
    }

    public void addCustomParticleColor(ResourceLocation id, String color) {
        Optional opt = BuiltInRegistries.PARTICLE_TYPE.getOptional(id);
        opt.ifPresent(t -> this.particleModifiers.put(t, (Object)ParticleModifier.ofColor(color)));
    }
}

