/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.particle.ParticleContextExpression;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleModifier {
    public static final Codec<ParticleModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Filter.CODEC.optionalFieldOf("filter").forGetter(p -> Optional.ofNullable(p.filter)), (App)Colormap.CODEC.optionalFieldOf("colormap").forGetter(p -> Optional.ofNullable(p.colormap)), (App)ParticleContextExpression.CODEC.optionalFieldOf("color").forGetter(p -> Optional.ofNullable(p.colorGetter)), (App)ParticleContextExpression.CODEC.optionalFieldOf("life").forGetter(p -> Optional.ofNullable(p.lifeGetter)), (App)ParticleContextExpression.CODEC.optionalFieldOf("size").forGetter(p -> Optional.ofNullable(p.colorGetter)), (App)ParticleContextExpression.CODEC.optionalFieldOf("red").forGetter(p -> Optional.ofNullable(p.colorGetter)), (App)ParticleContextExpression.CODEC.optionalFieldOf("green").forGetter(p -> Optional.ofNullable(p.colorGetter)), (App)ParticleContextExpression.CODEC.optionalFieldOf("blue").forGetter(p -> Optional.ofNullable(p.colorGetter)), (App)ParticleContextExpression.CODEC.optionalFieldOf("alpha").forGetter(p -> Optional.ofNullable(p.colorGetter)), (App)ParticleContextExpression.CODEC.optionalFieldOf("speed").forGetter(p -> Optional.ofNullable(p.speedGetter)), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(p -> p.targets)).apply((Applicative)instance, ParticleModifier::new));
    @Nullable
    private final Filter filter;
    @Nullable
    public final IColorGetter colormap;
    @Nullable
    public final ParticleContextExpression colorGetter;
    @Nullable
    public final ParticleContextExpression lifeGetter;
    @Nullable
    public final ParticleContextExpression sizeGetter;
    @Nullable
    public final ParticleContextExpression speedGetter;
    @Nullable
    public final ParticleContextExpression redGetter;
    @Nullable
    public final ParticleContextExpression blueGetter;
    @Nullable
    public final ParticleContextExpression greenGetter;
    @Nullable
    public final ParticleContextExpression alphaGetter;
    public final Targets targets;

    private ParticleModifier(Optional<Filter> filter, Optional<IColorGetter> colormap, Optional<ParticleContextExpression> color, Optional<ParticleContextExpression> life, Optional<ParticleContextExpression> size, Optional<ParticleContextExpression> red, Optional<ParticleContextExpression> green, Optional<ParticleContextExpression> blue, Optional<ParticleContextExpression> alpha, Optional<ParticleContextExpression> speed, Targets targets) {
        this((Filter)filter.orElse(null), (IColorGetter)colormap.orElse(null), (ParticleContextExpression)color.orElse(null), (ParticleContextExpression)life.orElse(null), (ParticleContextExpression)size.orElse(null), (ParticleContextExpression)red.orElse(null), (ParticleContextExpression)green.orElse(null), (ParticleContextExpression)blue.orElse(null), (ParticleContextExpression)alpha.orElse(null), (ParticleContextExpression)speed.orElse(null), targets);
    }

    public ParticleModifier(@Nullable Filter filter, @Nullable IColorGetter colormap, @Nullable ParticleContextExpression color, @Nullable ParticleContextExpression life, @Nullable ParticleContextExpression size, @Nullable ParticleContextExpression red, @Nullable ParticleContextExpression green, @Nullable ParticleContextExpression blue, @Nullable ParticleContextExpression alpha, @Nullable ParticleContextExpression speed, Targets explicitTargets) {
        this.colorGetter = color;
        this.lifeGetter = life;
        this.sizeGetter = size;
        this.redGetter = red;
        this.greenGetter = green;
        this.blueGetter = blue;
        this.alphaGetter = alpha;
        this.speedGetter = speed;
        this.targets = explicitTargets;
        this.filter = filter;
        this.colormap = colormap;
    }

    public static ParticleModifier ofColor(String color) {
        ParticleContextExpression expression = new ParticleContextExpression(color);
        return new ParticleModifier(null, null, expression, null, null, null, null, null, null, null, Targets.EMPTY);
    }

    public Targets targets() {
        return this.targets;
    }

    public void modify(@NotNull Particle particle, Level level, ParticleOptions options) {
        if (this.filter != null && !this.filter.test(options)) {
            return;
        }
        if (this.colorGetter != null) {
            float[] unpack = ColorUtils.unpack((int)this.colorGetter.getValue(particle, level));
            particle.setColor(unpack[0], unpack[1], unpack[2]);
        }
        if (this.colormap != null) {
            BlockState state = null;
            if (options instanceof BlockParticleOption) {
                BlockParticleOption bo = (BlockParticleOption)options;
                state = bo.getState();
            }
            float[] unpack = ColorUtils.unpack(this.colormap.getColor(state, (BlockAndTintGetter)level, BlockPos.containing((double)particle.x, (double)particle.y, (double)particle.z), 0));
            particle.setColor(unpack[0], unpack[1], unpack[2]);
        }
        if (this.lifeGetter != null) {
            particle.setLifetime((int)this.lifeGetter.getValue(particle, level));
        }
        if (this.sizeGetter != null) {
            particle.scale((float)this.sizeGetter.getValue(particle, level));
        }
        if (this.redGetter != null) {
            particle.rCol = (float)this.redGetter.getValue(particle, level);
        }
        if (this.greenGetter != null) {
            particle.gCol = (float)this.greenGetter.getValue(particle, level);
        }
        if (this.blueGetter != null) {
            particle.bCol = (float)this.blueGetter.getValue(particle, level);
        }
        if (this.speedGetter != null) {
            double speed = this.speedGetter.getValue(particle, level);
            particle.xd *= speed;
            particle.yd *= speed;
            particle.zd *= speed;
        }
        if (this.alphaGetter != null) {
            particle.alpha = (float)this.alphaGetter.getValue(particle, level);
        }
    }

    private record Filter(@Nullable Block forBlock, @Nullable Item forItem) implements Predicate<ParticleOptions>
    {
        public static final Codec<Filter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().optionalFieldOf("block").forGetter(p -> Optional.ofNullable(p.forBlock)), (App)BuiltInRegistries.ITEM.byNameCodec().optionalFieldOf("item").forGetter(p -> Optional.ofNullable(p.forItem))).apply((Applicative)instance, Filter::new));

        Filter(Optional<Block> state, Optional<Item> item) {
            this((Block)state.orElse(null), (Item)item.orElse(null));
        }

        @Override
        public boolean test(ParticleOptions particleOptions) {
            if (this.forBlock != null && particleOptions instanceof BlockParticleOption) {
                BlockParticleOption bo = (BlockParticleOption)particleOptions;
                return bo.getState().getBlock() == this.forBlock;
            }
            if (this.forItem != null && particleOptions instanceof ItemParticleOption) {
                ItemParticleOption io = (ItemParticleOption)particleOptions;
                return io.getItem().getItem() == this.forItem;
            }
            return true;
        }
    }
}

