/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.BaseExpression;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ParticleContextExpression
extends BaseExpression {
    private static final String COLOR = "COLOR";
    private static final String SPEED = "SPEED";
    private static final String X = "X";
    private static final String Y = "Y";
    private static final String Z = "Z";
    private static final String DX = "DX";
    private static final String DY = "DY";
    private static final String DZ = "DZ";
    private static final String RED = "RED";
    private static final String GREEN = "GREEN";
    private static final String BLUE = "BLUE";
    private static final String ALPHA = "ALPHA";
    private static final String SIZE = "SIZE";
    private static final String LIFE = "LIFETIME";
    private static final String AGE = "AGE";
    private static final String ROLL = "ROLL";
    private static final String CUSTOM = "CUSTOM";
    public static final Codec<ParticleContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new ParticleContextExpression((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    private final boolean hasCustom;
    public static final ParticleContextExpression ZERO = new ParticleContextExpression("0");
    public static final ParticleContextExpression ONE = new ParticleContextExpression("1");
    public static final ParticleContextExpression PARTICLE_RAND = new ParticleContextExpression("(rand() * 2.0 - 1.0) * 0.4");

    public ParticleContextExpression(String expression) {
        super(expression);
        this.hasCustom = expression.contains(CUSTOM);
    }

    @Override
    protected void buildFunctions(BaseExpression.FunBuilder builder) {
        super.buildFunctions(builder);
    }

    @Override
    protected void buildVars(BaseExpression.VarBuilder builder) {
        super.buildVars(builder);
        builder.addAll(COLOR, SPEED, X, Y, Z, DX, DY, DZ, RED, GREEN, BLUE, ALPHA, SIZE, LIFE, AGE, ROLL, CUSTOM);
    }

    public double getValue(Particle particle, Level level) {
        Entity e;
        this.expression.setVariable(LIFE, particle.getLifetime());
        int pack = ColorUtils.pack(particle.rCol, particle.gCol, particle.bCol);
        this.expression.setVariable(COLOR, pack);
        this.expression.setVariable(RED, particle.rCol);
        this.expression.setVariable(GREEN, particle.gCol);
        this.expression.setVariable(BLUE, particle.bCol);
        this.expression.setVariable(SPEED, Mth.length((double)particle.xd, (double)particle.yd, (double)particle.zd));
        this.expression.setVariable(ALPHA, particle.alpha);
        this.expression.setVariable(SIZE, ((SingleQuadParticle)particle).quadSize);
        this.expression.setVariable(DX, particle.xd);
        this.expression.setVariable(DY, particle.yd);
        this.expression.setVariable(DZ, particle.zd);
        this.expression.setVariable(X, particle.x);
        this.expression.setVariable(Y, particle.y);
        this.expression.setVariable(Z, particle.z);
        this.expression.setVariable(AGE, particle.age);
        this.expression.setVariable(ROLL, particle.roll);
        if (this.hasCustom && particle instanceof CustomParticleType.Instance) {
            CustomParticleType.Instance i = (CustomParticleType.Instance)particle;
            this.expression.setVariable(CUSTOM, i.getCustom());
        }
        if (this.hasPos) {
            BlockPos pos = BlockPos.containing((double)particle.x, (double)particle.y, (double)particle.z);
            this.expression.setVariable("POS_X", pos.getX());
            this.expression.setVariable("POS_Y", pos.getY());
            this.expression.setVariable("POS_Z", pos.getZ());
        }
        if (this.hasTime) {
            this.expression.setVariable("TIME", ClientFrameTicker.getGameTime());
        }
        if (this.hasDayTime) {
            this.expression.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            this.expression.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            this.expression.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSkyLight) {
            this.expression.setVariable("SKY_LIGHT", ClientFrameTicker.getSkyLight());
        }
        if (this.hasBlockLight) {
            this.expression.setVariable("BLOCK_LIGHT", ClientFrameTicker.getBlockLight());
        }
        if (this.hasTemperature) {
            this.expression.setVariable("TEMPERATURE", ClientFrameTicker.getTemperature());
        }
        if (this.hasDownfall) {
            this.expression.setVariable("DOWNFALL", ClientFrameTicker.getDownfall());
        }
        if (this.hasPlayer) {
            e = Minecraft.getInstance().getCameraEntity();
            this.expression.setVariable("PLAYER_X", e.getX());
            this.expression.setVariable("PLAYER_Y", e.getY());
            this.expression.setVariable("PLAYER_Z", e.getZ());
        }
        if (this.hasDistance) {
            e = Minecraft.getInstance().getCameraEntity();
            double x = particle.x - e.getX();
            double y = particle.y - e.getY();
            double z = particle.z - e.getZ();
            this.expression.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            this.expression.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            this.expression.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        ExpressionUtils.randomizeRandom();
        return this.expression.evaluate();
    }
}

