/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.noise;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class NoiseManager
extends JsonPartialReloader {
    public static final Decoder<PerlinSimplexNoise> NOISE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("seed").forGetter(p -> 0), (App)Codec.INT.listOf().fieldOf("octaves").forGetter(p -> List.of())).apply((Applicative)instance, (s, l) -> new PerlinSimplexNoise(RandomSource.create((long)s.intValue()), l)));
    private final MapRegistry<PerlinSimplexNoise> noises = new MapRegistry("Polytone Simplex Noises");

    public NoiseManager() {
        super("noises");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.noises.clear();
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        for (Map.Entry<ResourceLocation, JsonElement> e : jsons.entrySet()) {
            ResourceLocation id = e.getKey();
            JsonElement json = e.getValue();
            PerlinSimplexNoise noise = (PerlinSimplexNoise)((Pair)NOISE_CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Noise with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
            this.noises.register(id, noise);
        }
        ExpressionUtils.regenNoiseFunctions(this.noises.getEntries());
    }

    @Override
    protected void applyWithLevel(HolderLookup.Provider access, boolean isLogIn) {
    }
}

