/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.item.IPolytoneItem;
import net.mehvahdjukaar.polytone.item.ItemModelOverride;
import net.mehvahdjukaar.polytone.item.ItemModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;

public class ItemModifiersManager
extends JsonImgPartialReloader {
    private final Map<Item, ItemModifier> modifiers = new HashMap<Item, ItemModifier>();
    private final Map<Item, ItemModifier> vanillaProperties = new HashMap<Item, ItemModifier>();

    public ItemModifiersManager() {
        super("item_modifiers", "item_properties");
    }

    @Override
    public void earlyProcess(ResourceManager resourceManager) {
        Map<ResourceLocation, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        for (Map.Entry<ResourceLocation, JsonElement> e : jsons.entrySet()) {
            JsonElement json = e.getValue();
            ResourceLocation id = e.getKey();
            ItemModifier.Partial partial = (ItemModifier.Partial)((Pair)ItemModifier.CODEC_ONLY_MODELS.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Item Modifier with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
            for (ItemModelOverride.Partial m : partial.customModels()) {
                Polytone.addCustomModel(m.model());
            }
        }
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        Object modifier;
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>(resources.textures());
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        Map parsedModifiers = Utils.sortedMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            ResourceLocation location = entry.getKey();
            modifier = Parsed.parseFull(ItemModifier.CODEC, json, ops, location, "item modifier");
            parsedModifiers.put(location, modifier);
        }
        for (Map.Entry<ResourceLocation, Object> entry : parsedModifiers.entrySet()) {
            ResourceLocation tintId = entry.getKey();
            Parsed result = (Parsed)entry.getValue();
            modifier = (ItemModifier)result.getResultOrPartial();
            ResourceLocation barId = tintId.withSuffix("_bar");
            if (!((ItemModifier)modifier).hasBarColor() && textures.containsKey(barId)) {
                modifier = ((ItemModifier)modifier).merge(ItemModifier.ofBarColor(Colormap.createDamage()));
            }
            ColormapsManager.tryAcceptingTexture(textures, barId, ((ItemModifier)modifier).getBarColor(), usedTextures, true);
            if (!result.isEnabled()) continue;
            this.addModifier(tintId, (ItemModifier)modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<ResourceLocation, Object> entry : textures.entrySet()) {
            ResourceLocation id = entry.getKey();
            Colormap defaultColormap = Colormap.createDamage();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, ItemModifier.ofBarColor(defaultColormap));
        }
    }

    private void addModifier(ResourceLocation id, ItemModifier mod) {
        for (Holder item : mod.targets().compute(id, BuiltInRegistries.ITEM)) {
            Item i = (Item)item.value();
            this.modifiers.merge(i, mod, ItemModifier::merge);
            Polytone.ITEM_MODELS.addModelFromModifier(i, mod.customModels());
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        for (Map.Entry<Item, ItemModifier> e : this.vanillaProperties.entrySet()) {
            e.getValue().apply(e.getKey());
            ((IPolytoneItem)e.getKey()).polytone$setModifier(null);
        }
        this.modifiers.clear();
    }

    @Override
    protected void applyWithLevel(HolderLookup.Provider access, boolean isLogIn) {
        for (Map.Entry<Item, ItemModifier> e : this.modifiers.entrySet()) {
            Item target = e.getKey();
            ItemModifier modifier = e.getValue();
            this.vanillaProperties.put(target, modifier.apply(target));
            if (!modifier.shouldAttachToItem()) continue;
            ((IPolytoneItem)e.getKey()).polytone$setModifier(modifier);
        }
        if (!this.vanillaProperties.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Item Properties", (Object)this.vanillaProperties.size());
        }
        this.modifiers.clear();
    }
}

