/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.dimension;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.dimension.DimensionEffectsModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DimensionEffectsManager
extends JsonImgPartialReloader {
    private final Map<ResourceLocation, DimensionEffectsModifier> effectsToApply = new HashMap<ResourceLocation, DimensionEffectsModifier>();
    private final Map<ResourceLocation, DimensionEffectsModifier> vanillaEffects = new HashMap<ResourceLocation, DimensionEffectsModifier>();
    private final Object2ObjectMap<DimensionType, Colormap> fogColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<DimensionType, Colormap> skyColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<DimensionType, Colormap> sunsetColormaps = new Object2ObjectArrayMap();
    private final Object2ObjectMap<DimensionType, BlockContextExpression> cloudFunctions = new Object2ObjectArrayMap();
    private final Object2BooleanArrayMap<DimensionType> cancelFogWeatherDarken = new Object2BooleanArrayMap();
    private final Object2BooleanArrayMap<DimensionType> cancelSkyWeatherDarken = new Object2BooleanArrayMap();
    private boolean needsDynamicApplication = true;
    private final Map<ResourceLocation, DimensionEffectsModifier> extraMods = new HashMap<ResourceLocation, DimensionEffectsModifier>();
    private static float[] lastSunset = null;

    public DimensionEffectsManager() {
        super("dimension_modifiers", "dimension_effects");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.needsDynamicApplication = true;
        this.effectsToApply.clear();
        this.fogColormaps.clear();
        this.skyColormaps.clear();
        this.sunsetColormaps.clear();
        this.cancelFogWeatherDarken.clear();
        this.cancelSkyWeatherDarken.clear();
        this.cloudFunctions.clear();
        this.extraMods.clear();
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        ResourceLocation id;
        Map<ResourceLocation, JsonElement> jsons = resources.jsons();
        HashMap<ResourceLocation, ArrayImage> textures = new HashMap<ResourceLocation, ArrayImage>(resources.textures());
        HashSet<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
        Map parsedModifiers = Utils.sortedMap();
        for (Map.Entry<ResourceLocation, DimensionEffectsModifier> entry : this.extraMods.entrySet()) {
            parsedModifiers.put(entry.getKey(), Parsed.success(entry.getValue(), entry.getKey()));
        }
        for (Map.Entry<ResourceLocation, DimensionEffectsModifier> entry : jsons.entrySet()) {
            JsonElement jsonElement = (JsonElement)entry.getValue();
            id = entry.getKey();
            Parsed<DimensionEffectsModifier> modifier = Parsed.parseFull(DimensionEffectsModifier.CODEC, jsonElement, ops, id, "dimension modifier");
            if (parsedModifiers.containsKey(id)) {
                Polytone.LOGGER.warn("Found duplicate Dimension Effects file with id {}.Overriding previous one", (Object)id);
            }
            parsedModifiers.put(id, modifier);
        }
        HolderLookup.RegistryLookup reg = access.lookupOrThrow(Registries.DIMENSION_TYPE);
        for (Map.Entry entry : parsedModifiers.entrySet()) {
            ResourceLocation sunsetId;
            ResourceLocation fogId;
            ResourceLocation skyId;
            id = entry.getKey();
            Parsed parsed = (Parsed)entry.getValue();
            DimensionEffectsModifier modifier = (DimensionEffectsModifier)parsed.getResultOrPartial();
            BlockColor fog = modifier.getFogColormap();
            BlockColor sky = modifier.getSkyColormap();
            BlockColor sunset = modifier.getSunsetColormap();
            if (textures.containsKey(id) && fog == null && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofFogColor(Colormap.createDefTriangle()));
                fog = modifier.getFogColormap();
            }
            if (textures.containsKey(skyId = id.withSuffix("_sky")) && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofSkyColor(Colormap.createDefTriangle()));
                sky = modifier.getSkyColormap();
            }
            if (textures.containsKey(fogId = id.withSuffix("_fog")) && sky == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofFogColor(Colormap.createDefTriangle()));
                fog = modifier.getFogColormap();
            }
            if (textures.containsKey(sunsetId = id.withSuffix("_sunset")) && sunset == null) {
                modifier = modifier.merge(DimensionEffectsModifier.ofSunsetColor(Colormap.createTimeStrip()));
                sunset = modifier.getSunsetColormap();
            }
            if (fog != null ^ sky != null ^ sunset != null) {
                ColormapsManager.tryAcceptingTexture(textures, id, fog, usedTextures, false);
                ColormapsManager.tryAcceptingTexture(textures, id, sky, usedTextures, false);
                ColormapsManager.tryAcceptingTexture(textures, id, sunset, usedTextures, false);
            }
            ColormapsManager.tryAcceptingTexture(textures, fogId, fog, usedTextures, true);
            ColormapsManager.tryAcceptingTexture(textures, skyId, sky, usedTextures, true);
            ColormapsManager.tryAcceptingTexture(textures, sunsetId, sunset, usedTextures, true);
            if (!parsed.isEnabled()) continue;
            this.addModifier(id, modifier, (HolderLookup.RegistryLookup<DimensionType>)reg);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<ResourceLocation, ArrayImage> entry : textures.entrySet()) {
            id = entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, DimensionEffectsModifier.ofFogColor(defaultColormap), (HolderLookup.RegistryLookup<DimensionType>)reg);
        }
    }

    private void addModifier(ResourceLocation fileId, DimensionEffectsModifier mod, HolderLookup.RegistryLookup<DimensionType> reg) {
        for (Holder<DimensionType> h : mod.targets().compute(fileId, reg)) {
            this.effectsToApply.merge(((ResourceKey)h.unwrapKey().get()).location(), mod, DimensionEffectsModifier::merge);
        }
    }

    @Override
    protected void applyWithLevel(HolderLookup.Provider registryAccess, boolean isLogIn) {
        if (!isLogIn && !this.needsDynamicApplication) {
            return;
        }
        this.needsDynamicApplication = false;
        for (Map.Entry<ResourceLocation, DimensionEffectsModifier> v : this.vanillaEffects.entrySet()) {
            v.getValue().applyInplace(v.getKey());
        }
        HolderLookup.RegistryLookup dimReg = registryAccess.lookupOrThrow(Registries.DIMENSION_TYPE);
        for (Map.Entry<ResourceLocation, DimensionEffectsModifier> v : this.effectsToApply.entrySet()) {
            Colormap c;
            ResourceLocation dimensionId = v.getKey();
            ResourceKey dimensionKey = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)dimensionId);
            DimensionEffectsModifier modifier = v.getValue();
            DimensionEffectsModifier old = modifier.applyInplace(dimensionId);
            this.vanillaEffects.put(dimensionId, old);
            DimensionType dim = (DimensionType)((Holder.Reference)dimReg.get(dimensionKey).get()).value();
            BlockColor blockColor = modifier.getFogColormap();
            if (blockColor instanceof Colormap) {
                c = (Colormap)blockColor;
                this.fogColormaps.put((Object)dim, (Object)c);
            }
            if ((blockColor = modifier.getSkyColormap()) instanceof Colormap) {
                c = (Colormap)blockColor;
                this.skyColormaps.put((Object)dim, (Object)c);
            }
            if ((blockColor = modifier.getSunsetColormap()) instanceof Colormap) {
                c = (Colormap)blockColor;
                this.sunsetColormaps.put((Object)dim, (Object)c);
            }
            if (modifier.noWeatherFogDarken()) {
                this.cancelFogWeatherDarken.put((Object)dim, true);
            }
            if (modifier.noWeatherSkyDarken()) {
                this.cancelSkyWeatherDarken.put((Object)dim, true);
            }
            if (!modifier.cloudLevel().isPresent() || !modifier.cloudLevel().get().right().isPresent()) continue;
            this.cloudFunctions.put((Object)dim, (Object)((BlockContextExpression)modifier.cloudLevel().get().right().get()));
        }
        if (!this.vanillaEffects.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Dimension Modifiers", (Object)this.vanillaEffects.size());
        }
    }

    @Nullable
    public Vec3 modifyFogColor(Vec3 center, ClientLevel level, float brightness) {
        Colormap colormap = (Colormap)this.fogColormaps.get((Object)level.dimensionType());
        if (colormap == null) {
            return null;
        }
        BiomeManager biomeManager = level.getBiomeManager();
        return level.effects().getBrightnessDependentFogColor(CubicSampler.gaussianSampleVec3((Vec3)center, (qx, qy, qz) -> {
            Biome biome = (Biome)biomeManager.getNoiseBiomeAtQuart(qx, qy, qz).value();
            int fogColor1 = colormap.sampleColor(null, BlockPos.containing((double)(qx * 4), (double)(qy * 4), (double)(qz * 4)), biome, null);
            return Vec3.fromRGB24((int)fogColor1);
        }), brightness);
    }

    public void modifyFogMagicNumber(float renderDistanceChunks, LocalFloatRef distance) {
        float c = 0.25f;
        float b = c + (1.0f - c) * renderDistanceChunks / 32.0f;
        b = 1.0f - (float)Math.pow(b, 0.25);
        float a = 1.0f * renderDistanceChunks / 32.0f;
        a = 1.0f - (float)Math.pow(a, 0.25);
        distance.set(b);
    }

    @Nullable
    public Vec3 modifySkyColor(Vec3 center, ClientLevel level) {
        Colormap colormap = (Colormap)this.skyColormaps.get((Object)level.dimensionType());
        if (colormap == null) {
            return null;
        }
        BiomeManager biomeManager = level.getBiomeManager();
        return CubicSampler.gaussianSampleVec3((Vec3)center, (qx, qy, qz) -> {
            Biome biome = (Biome)biomeManager.getNoiseBiomeAtQuart(qx, qy, qz).value();
            int skyColor1 = colormap.sampleColor(null, BlockPos.containing((double)(qx * 4), (double)(qy * 4), (double)(qz * 4)), biome, null);
            return Vec3.fromRGB24((int)skyColor1);
        });
    }

    @Nullable
    public Float modifyCloudHeight(ClientLevel level) {
        BlockContextExpression height = (BlockContextExpression)this.cloudFunctions.get((Object)level.dimensionType());
        if (height == null) {
            return null;
        }
        BlockPos pos = ClientFrameTicker.getCameraPos();
        double v = height.getValue((Level)level, pos, Blocks.AIR.defaultBlockState());
        if (v >= 10000.0) {
            return Float.valueOf(Float.NaN);
        }
        return Float.valueOf((float)v);
    }

    public boolean shouldCancelFogWeatherDarken(Level level) {
        return this.cancelFogWeatherDarken.getOrDefault((Object)level.dimensionType(), false);
    }

    public boolean shouldCancelSkyWeatherDarken(Level level) {
        return this.cancelSkyWeatherDarken.getOrDefault((Object)level.dimensionType(), false);
    }

    public void addConvertedBlockProperties(Map<ResourceLocation, DimensionEffectsModifier> converted) {
        this.extraMods.clear();
        this.extraMods.putAll(converted);
    }

    @Nullable
    public Integer modifySunsetColor(int old) {
        Colormap colormap = (Colormap)this.sunsetColormaps.get((Object)Minecraft.getInstance().level.dimensionType());
        if (colormap == null) {
            return null;
        }
        float oldAlpha = (float)ARGB.alpha((int)old) / 255.0f;
        int color = colormap.sampleColor(null, ClientFrameTicker.getCameraPos(), (Biome)ClientFrameTicker.getCameraBiome().value(), null);
        float deltaTime = ClientFrameTicker.getDeltaTime();
        float interpolationFactor = deltaTime * 0.1f;
        float[] c = ColorUtils.unpack(color);
        if (lastSunset == null) {
            lastSunset = new float[]{c[0], c[1], c[2], oldAlpha};
            return ARGB.colorFromFloat((float)lastSunset[3], (float)lastSunset[0], (float)lastSunset[1], (float)lastSunset[2]);
        }
        DimensionEffectsManager.lastSunset[0] = Mth.lerp((float)interpolationFactor, (float)lastSunset[0], (float)c[0]);
        DimensionEffectsManager.lastSunset[1] = Mth.lerp((float)interpolationFactor, (float)lastSunset[1], (float)c[1]);
        DimensionEffectsManager.lastSunset[2] = Mth.lerp((float)interpolationFactor, (float)lastSunset[2], (float)c[2]);
        DimensionEffectsManager.lastSunset[3] = oldAlpha;
        return ARGB.colorFromFloat((float)lastSunset[3], (float)lastSunset[0], (float)lastSunset[1], (float)lastSunset[2]);
    }
}

