/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.utils.AlternativeMapCodec;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.Targets;
import net.mehvahdjukaar.polytone.utils.Weather;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec2;

public record BiomeEffectModifier(Optional<Integer> fogColor, Optional<Integer> waterColor, Optional<Integer> waterFogColor, Optional<Integer> skyColor, Optional<Integer> foliageColorOverride, Optional<Integer> grassColorOverride, Optional<BiomeSpecialEffects.GrassColorModifier> grassColorModifier, Optional<AmbientParticleSettings> ambientParticleSettings, Optional<Holder<SoundEvent>> ambientLoopSoundEvent, Optional<AmbientMoodSettings> ambientMoodSettings, Optional<AmbientAdditionsSettings> ambientAdditionsSettings, Optional<SimpleWeightedRandomList<Music>> backgroundMusic, Optional<FogParam> fogStart, Optional<FogParam> fogEnd, Targets targets) {
    public static final Codec<BiomeEffectModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("fog_color").forGetter(BiomeEffectModifier::fogColor), (App)Codec.INT.optionalFieldOf("water_color").forGetter(BiomeEffectModifier::waterColor), (App)Codec.INT.optionalFieldOf("water_fog_color").forGetter(BiomeEffectModifier::waterFogColor), (App)Codec.INT.optionalFieldOf("sky_color").forGetter(BiomeEffectModifier::skyColor), (App)Codec.INT.optionalFieldOf("foliage_color").forGetter(BiomeEffectModifier::foliageColorOverride), (App)Codec.INT.optionalFieldOf("grass_color").forGetter(BiomeEffectModifier::grassColorOverride), (App)BiomeSpecialEffects.GrassColorModifier.CODEC.optionalFieldOf("grass_color_modifier").forGetter(BiomeEffectModifier::grassColorModifier), (App)AmbientParticleSettings.CODEC.optionalFieldOf("particle").forGetter(BiomeEffectModifier::ambientParticleSettings), (App)SoundEvent.CODEC.optionalFieldOf("ambient_sound").forGetter(BiomeEffectModifier::ambientLoopSoundEvent), (App)AmbientMoodSettings.CODEC.optionalFieldOf("mood_sound").forGetter(BiomeEffectModifier::ambientMoodSettings), (App)AmbientAdditionsSettings.CODEC.optionalFieldOf("additions_sound").forGetter(BiomeEffectModifier::ambientAdditionsSettings), (App)SimpleWeightedRandomList.wrappedCodecAllowingEmpty((Codec)Music.CODEC).optionalFieldOf("music").forGetter(BiomeEffectModifier::backgroundMusic), (App)AlternativeMapCodec.optionalAlias(FogParam.CODEC, "fog_fade", "fog_start").forGetter(BiomeEffectModifier::fogStart), (App)AlternativeMapCodec.optionalAlias(FogParam.CODEC, "fog_radius", "fog_end").forGetter(BiomeEffectModifier::fogEnd), (App)Targets.CODEC.optionalFieldOf("targets", (Object)Targets.EMPTY).forGetter(BiomeEffectModifier::targets)).apply((Applicative)instance, BiomeEffectModifier::new));

    public static BiomeEffectModifier ofWaterColor(int waterColor) {
        return new BiomeEffectModifier(Optional.empty(), Optional.of(waterColor), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Targets.EMPTY);
    }

    public BiomeEffectModifier merge(BiomeEffectModifier newMod) {
        return new BiomeEffectModifier(newMod.fogColor.isPresent() ? newMod.fogColor() : this.fogColor(), newMod.waterColor().isPresent() ? newMod.waterColor() : this.waterColor(), newMod.waterFogColor().isPresent() ? newMod.waterFogColor() : this.waterFogColor(), newMod.skyColor().isPresent() ? newMod.skyColor() : this.skyColor(), newMod.foliageColorOverride().isPresent() ? newMod.waterColor() : this.foliageColorOverride(), newMod.grassColorOverride().isPresent() ? newMod.grassColorOverride() : this.grassColorOverride(), newMod.grassColorModifier().isPresent() ? newMod.grassColorModifier() : this.grassColorModifier(), newMod.ambientParticleSettings().isPresent() ? newMod.ambientParticleSettings() : this.ambientParticleSettings(), newMod.ambientLoopSoundEvent().isPresent() ? newMod.ambientLoopSoundEvent() : this.ambientLoopSoundEvent(), newMod.ambientMoodSettings().isPresent() ? newMod.ambientMoodSettings() : this.ambientMoodSettings(), newMod.ambientAdditionsSettings().isPresent() ? newMod.ambientAdditionsSettings() : this.ambientAdditionsSettings(), newMod.backgroundMusic().isPresent() ? newMod.backgroundMusic() : this.backgroundMusic(), newMod.fogStart().isPresent() ? newMod.fogStart() : this.fogStart(), newMod.fogEnd().isPresent() ? newMod.fogEnd() : this.fogEnd(), this.targets.merge(newMod.targets));
    }

    public BiomeSpecialEffects apply(Biome biome) {
        BiomeSpecialEffects effects = biome.getSpecialEffects();
        BiomeSpecialEffects.Builder builder = this.getBuilder(effects);
        Optional<Integer> newFoliageColorOverride = effects.getFoliageColorOverride();
        if (this.foliageColorOverride.isPresent()) {
            newFoliageColorOverride = this.foliageColorOverride;
        }
        newFoliageColorOverride.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).foliageColorOverride(arg_0));
        Optional<Integer> newGrassColorOverride = effects.getGrassColorOverride();
        if (this.grassColorOverride.isPresent()) {
            newGrassColorOverride = this.grassColorOverride;
        }
        newGrassColorOverride.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).grassColorOverride(arg_0));
        BiomeSpecialEffects.GrassColorModifier newGrassColorModifier = effects.getGrassColorModifier();
        if (this.grassColorModifier.isPresent()) {
            newGrassColorModifier = this.grassColorModifier.get();
        }
        builder.grassColorModifier(newGrassColorModifier);
        Optional<AmbientParticleSettings> newParticle = effects.getAmbientParticleSettings();
        if (this.ambientParticleSettings.isPresent()) {
            newParticle = this.ambientParticleSettings;
        }
        newParticle.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).ambientParticle(arg_0));
        Optional<Holder<SoundEvent>> newAmbientSound = effects.getAmbientLoopSoundEvent();
        if (this.ambientLoopSoundEvent.isPresent()) {
            newAmbientSound = this.ambientLoopSoundEvent;
        }
        newAmbientSound.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).ambientLoopSound(arg_0));
        Optional<AmbientMoodSettings> newMood = effects.getAmbientMoodSettings();
        if (this.ambientMoodSettings.isPresent()) {
            newMood = this.ambientMoodSettings;
        }
        newMood.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).ambientMoodSound(arg_0));
        Optional<AmbientAdditionsSettings> newAdditions = effects.getAmbientAdditionsSettings();
        if (this.ambientAdditionsSettings.isPresent()) {
            newAdditions = this.ambientAdditionsSettings;
        }
        newAdditions.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).ambientAdditionsSound(arg_0));
        Optional<SimpleWeightedRandomList<Music>> newMusic = effects.getBackgroundMusic();
        if (this.backgroundMusic.isPresent()) {
            newMusic = this.backgroundMusic;
        }
        newMusic.ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).backgroundMusic(arg_0));
        BiomeSpecialEffects copy = this.copy(effects);
        BiomeEffectModifier.applyEffects(biome, builder.build());
        return copy;
    }

    private BiomeSpecialEffects.Builder getBuilder(BiomeSpecialEffects effects) {
        BiomeSpecialEffects.Builder builder = new BiomeSpecialEffects.Builder();
        int newFog = effects.getFogColor();
        if (this.fogColor.isPresent()) {
            newFog = this.fogColor.get();
        }
        builder.fogColor(newFog);
        int newWaterColor = effects.getWaterColor();
        if (this.waterColor.isPresent()) {
            newWaterColor = this.waterColor.get();
        }
        builder.waterColor(newWaterColor);
        int newWaterFogColor = effects.getWaterFogColor();
        if (this.waterFogColor.isPresent()) {
            newWaterFogColor = this.waterFogColor.get();
        }
        builder.waterFogColor(newWaterFogColor);
        int newSkyColor = effects.getSkyColor();
        if (this.skyColor.isPresent()) {
            newSkyColor = this.skyColor.get();
        }
        builder.skyColor(newSkyColor);
        return builder;
    }

    private BiomeSpecialEffects copy(BiomeSpecialEffects effects) {
        BiomeSpecialEffects.Builder builder = new BiomeSpecialEffects.Builder();
        builder.fogColor(effects.getFogColor());
        builder.waterColor(effects.getWaterColor());
        builder.waterFogColor(effects.getWaterFogColor());
        builder.skyColor(effects.getSkyColor());
        effects.getFoliageColorOverride().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).foliageColorOverride(arg_0));
        effects.getGrassColorOverride().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).grassColorOverride(arg_0));
        builder.grassColorModifier(effects.getGrassColorModifier());
        effects.getAmbientParticleSettings().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).ambientParticle(arg_0));
        effects.getAmbientLoopSoundEvent().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).ambientLoopSound(arg_0));
        effects.getAmbientMoodSettings().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).ambientMoodSound(arg_0));
        effects.getAmbientAdditionsSettings().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).ambientAdditionsSound(arg_0));
        effects.getBackgroundMusic().ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)builder).backgroundMusic(arg_0));
        return builder.build();
    }

    public static void applyEffects(Biome biome, BiomeSpecialEffects newEffects) {
        PlatStuff.applyBiomeSurgery(biome, newEffects);
    }

    private static void applyInplace(Biome biome, BiomeSpecialEffects newEffects) {
        BiomeSpecialEffects oldEffects = biome.getSpecialEffects();
        oldEffects.fogColor = -1;
        oldEffects.waterColor = newEffects.getWaterColor();
        oldEffects.waterFogColor = newEffects.getWaterFogColor();
        oldEffects.skyColor = -1;
        oldEffects.foliageColorOverride = newEffects.getFoliageColorOverride();
        oldEffects.grassColorOverride = Optional.of(-1);
        oldEffects.grassColorModifier = newEffects.getGrassColorModifier();
        oldEffects.ambientParticleSettings = newEffects.getAmbientParticleSettings();
        oldEffects.ambientLoopSoundEvent = newEffects.getAmbientLoopSoundEvent();
        oldEffects.ambientMoodSettings = newEffects.getAmbientMoodSettings();
        oldEffects.ambientAdditionsSettings = newEffects.getAmbientAdditionsSettings();
        oldEffects.backgroundMusic = newEffects.getBackgroundMusic();
    }

    public boolean modifyFogParameter() {
        return this.fogStart.isPresent() || this.fogEnd.isPresent();
    }

    public Vec2 modifyFogParameters(Level level) {
        return new Vec2(this.fogStart.map(f -> Float.valueOf(f.get(level))).orElse(Float.valueOf(1.0f)).floatValue(), this.fogEnd.map(f -> Float.valueOf(f.get(level))).orElse(Float.valueOf(1.0f)).floatValue());
    }

    public static interface FogParam {
        public static final Codec<FogParam> SIMPLE_CODEC = Codec.FLOAT.xmap(f -> l -> f.floatValue(), fogParam -> Float.valueOf(fogParam.get(null)));
        public static final Codec<FogParam> CODEC = Codec.withAlternative((Codec)Codec.withAlternative(SIMPLE_CODEC, (Codec)Codec.simpleMap(Weather.CODEC, SIMPLE_CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])Weather.values())).xmap(FogMap::new, FogMap::map).codec()), (Codec)BlockContextExpression.CODEC.xmap(FogExpression::new, fogMap -> fogMap.map));

        public float get(Level var1);
    }

    public record FogMap(Map<Weather, FogParam> map) implements FogParam
    {
        @Override
        public float get(Level level) {
            Weather w = Weather.get(level);
            return this.map.getOrDefault((Object)w, l -> 1.0f).get(level);
        }
    }

    public record FogExpression(BlockContextExpression map) implements FogParam
    {
        @Override
        public float get(Level level) {
            BlockPos pos = ClientFrameTicker.getCameraPos();
            return (float)this.map.getValue(level, pos, Blocks.AIR.defaultBlockState());
        }
    }
}

