/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.noise;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_3543;
import net.minecraft.class_5819;
import net.minecraft.class_6903;
import net.minecraft.class_7225;

public class NoiseManager
extends JsonPartialReloader {
    public static final Decoder<class_3543> NOISE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("seed").forGetter(p -> 0), (App)Codec.INT.listOf().fieldOf("octaves").forGetter(p -> List.of())).apply((Applicative)instance, (s, l) -> new class_3543(class_5819.method_43049((long)s.intValue()), l)));
    private final MapRegistry<class_3543> noises = new MapRegistry("Polytone Simplex Noises");

    public NoiseManager() {
        super("noises");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.noises.clear();
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        for (Map.Entry<class_2960, JsonElement> e : jsons.entrySet()) {
            class_2960 id = e.getKey();
            JsonElement json = e.getValue();
            class_3543 noise = (class_3543)((Pair)NOISE_CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Noise with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
            this.noises.register(id, noise);
        }
        ExpressionUtils.regenNoiseFunctions(this.noises.getEntries());
    }

    @Override
    protected void applyWithLevel(class_7225.class_7874 access, boolean isLogIn) {
    }
}

