/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.lightmap;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.ref.Cleaner;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.lightmap.ILightmapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.minecraft.class_1011;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_6367;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryUtil;

public class Lightmap {
    protected static final double DEFAULT_SKY_LERP = 0.1;
    protected static final double DEFAULT_TORCH_LERP = 0.0;
    protected static final float DEFAULT_BASE_LIGHT = 0.04f;
    public static final Codec<Lightmap> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ILightmapNumberProvider.CODEC.optionalFieldOf("sky_getter", (Object)ILightmapNumberProvider.DEFAULT).forGetter(l -> l.skyGetter), (App)ILightmapNumberProvider.CODEC.optionalFieldOf("torch_getter", (Object)ILightmapNumberProvider.DEFAULT).forGetter(l -> l.torchGetter), (App)Codec.BOOL.optionalFieldOf("lightning_strike_columns", (Object)true).forGetter(l -> l.hasLightningColumn), (App)Codec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("sky_lerp_factor", (Object)0.1).forGetter(l -> l.skyLerp), (App)Codec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("torch_lerp_factor", (Object)0.0).forGetter(l -> l.torchLerp), (App)Codec.FLOAT.optionalFieldOf("base_light", (Object)Float.valueOf(0.04f)).forGetter(l -> Float.valueOf(l.baseLight))).apply((Applicative)instance, Lightmap::new));
    public static final Codec<Lightmap> CODEC = new ReferenceOrDirectCodec<Lightmap>(Polytone.LIGHTMAPS.byNameCodec(), DIRECT_CODEC);
    private final ILightmapNumberProvider skyGetter;
    private final ILightmapNumberProvider torchGetter;
    private final boolean hasLightningColumn;
    private final float baseLight;
    private final double skyLerp;
    private final double torchLerp;
    private final ArrayImage[] textures = new ArrayImage[3];
    private final float[][] lastSkyLine = new float[16][3];
    private final float[][] lastTorchLine = new float[16][3];
    private final long lightmapPixels;
    private long lastTime = 0L;
    private boolean forceUpload = false;

    public Lightmap(ILightmapNumberProvider skyGetter, ILightmapNumberProvider torchGetter, boolean lightningColumn, double skyLerp, double torchLerp, float baseLight) {
        this.skyGetter = skyGetter;
        this.torchGetter = torchGetter;
        this.hasLightningColumn = lightningColumn;
        this.skyLerp = skyLerp;
        this.torchLerp = torchLerp;
        this.baseLight = baseLight;
        long pixels = MemoryUtil.nmemAlloc((long)1024L);
        Cleaner.create().register(this, () -> MemoryUtil.nmemFree((long)pixels));
        this.lightmapPixels = pixels;
    }

    public Lightmap() {
        this(ILightmapNumberProvider.DEFAULT, ILightmapNumberProvider.RANDOM, true, 0.1, 0.0, 0.04f);
    }

    public void acceptImages(ArrayImage normal, ArrayImage rain, ArrayImage thunder) {
        this.textures[0] = normal;
        this.textures[1] = rain;
        this.textures[2] = thunder;
        for (ArrayImage v : this.textures) {
            if (v == null || v.width() > 2) continue;
            throw new IllegalStateException("Lightmap cannot have more with is too small! Was " + v.width());
        }
    }

    public void forceRefresh() {
        this.forceUpload = true;
    }

    public void applyToLightTexture(class_765 instance, class_6367 lightmap, class_310 minecraft, class_638 level, float flicker, float partialTicks) {
        float lerpDelta;
        boolean needsUpload = false;
        if (this.forceUpload) {
            this.forceUpload = false;
            needsUpload = true;
        }
        float skyDarken = level.method_23783(partialTicks);
        float rainLevel = level.method_8430(partialTicks);
        float thunderLevel = level.method_8478(partialTicks);
        float time = level.method_30274(partialTicks);
        long currentTime = System.currentTimeMillis();
        long deltaMillis = currentTime - this.lastTime;
        float deltaTime = (float)deltaMillis / 1000.0f;
        this.lastTime = currentTime;
        class_746 player = minecraft.field_1724;
        class_315 options = minecraft.field_1690;
        boolean skyFlashTime = level.method_23789() > 0;
        float skyLightIntensity = skyFlashTime ? 1.0f : skyDarken * 0.95f + 0.05f;
        float darknessEffect = ((Double)options.method_42472().method_41753()).floatValue();
        float darknessGamma = instance.method_42597(partialTicks) * darknessEffect;
        float darknessSubtract = instance.method_42596((class_1309)player, darknessGamma, partialTicks) * darknessEffect;
        float gamma = ((Double)options.method_42473().method_41753()).floatValue();
        gamma = PlatStuff.compatACModifyGamma(partialTicks, gamma);
        float gammaAmount = Math.max(0.0f, gamma - darknessGamma);
        float waterVision = player.method_3140();
        float nightVisionScale = player.method_6059(class_1294.field_5925) ? class_757.method_3174((class_1309)player, (float)partialTicks) : (waterVision > 0.0f && player.method_6059(class_1294.field_5927) ? waterVision : 0.0f);
        Vector3f skyColor = new Vector3f(skyDarken, skyDarken, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
        float blockLightFlicker = flicker + 1.5f;
        class_2874 dimensionType = level.method_8597();
        float darkenWorldAmount = minecraft.field_1773.method_3195(partialTicks);
        Vector3f lightGray = new Vector3f(0.75f, 0.75f, 0.75f);
        float lightGrayAmount = this.baseLight;
        ArrayImage image = this.selectImage(rainLevel, thunderLevel);
        float[][] torchLine = this.selectTorch(image, nightVisionScale, time, rainLevel, thunderLevel);
        float[][] skyLine = this.selectSky(image, nightVisionScale, time, rainLevel, thunderLevel, skyFlashTime);
        if (torchLine.length != 0 && this.lastTorchLine.length != 0 && this.torchLerp != 0.0) {
            lerpDelta = 1.0f - (float)Math.pow(this.torchLerp, deltaTime);
            Lightmap.lerpInplace(this.lastTorchLine, torchLine, lerpDelta);
        }
        if (skyLine.length != 0 && this.lastSkyLine.length != 0 && this.skyLerp != 0.0) {
            lerpDelta = 1.0f - (float)Math.pow(this.skyLerp, deltaTime);
            Lightmap.lerpInplace(this.lastSkyLine, skyLine, lerpDelta);
        }
        for (int skyY = 0; skyY < 16; ++skyY) {
            Vector3f skyBuffer = new Vector3f();
            if (skyLine.length != 0) {
                skyBuffer.add((Vector3fc)new Vector3f(skyLine[skyY]));
            } else {
                float skyBrightness = class_765.method_23284((class_2874)dimensionType, (int)skyY) * skyLightIntensity;
                skyBuffer.add((Vector3fc)skyColor).mul(skyBrightness);
                skyBuffer.mul(1.0f - lightGrayAmount);
            }
            for (int torchX = 0; torchX < 16; ++torchX) {
                float maxVal;
                Vector3f addition = new Vector3f();
                Vector3f torchBuffer = new Vector3f();
                if (torchLine.length != 0) {
                    torchBuffer.add((Vector3fc)new Vector3f(torchLine[torchX]));
                } else {
                    float torchR = class_765.method_23284((class_2874)dimensionType, (int)torchX) * blockLightFlicker;
                    float torchG = torchR * ((torchR * 0.6f + 0.4f) * 0.6f + 0.4f);
                    float torchB = torchR * (torchR * torchR * 0.6f + 0.4f);
                    torchBuffer.set(torchR, torchG, torchB);
                    addition.add((Vector3fc)new Vector3f((Vector3fc)lightGray).mul(lightGrayAmount));
                    torchBuffer.mul(1.0f - lightGrayAmount);
                }
                Vector3f combined = new Vector3f();
                combined.add((Vector3fc)torchBuffer).add((Vector3fc)skyBuffer).add((Vector3fc)addition);
                if (darkenWorldAmount > 0.0f) {
                    Vector3f discolored = new Vector3f((Vector3fc)combined).mul(0.7f, 0.6f, 0.6f);
                    combined.lerp((Vector3fc)discolored, darkenWorldAmount);
                }
                PlatStuff.adjustLightmapColors(level, partialTicks, skyDarken, skyLightIntensity, flicker, torchX, skyY, combined);
                if (nightVisionScale > 0.0f && (image == null || image.height() <= 32) && (maxVal = Math.max(combined.x(), Math.max(combined.y(), combined.z()))) < 1.0f) {
                    float percentage = 1.0f / maxVal;
                    Vector3f discolored = new Vector3f((Vector3fc)combined).mul(percentage);
                    combined.lerp((Vector3fc)discolored, nightVisionScale);
                }
                if (darknessSubtract > 0.0f) {
                    combined.add(-darknessSubtract, -darknessSubtract, -darknessSubtract);
                }
                Lightmap.clampColor(combined);
                Vector3f notGamma = new Vector3f(this.notGamma(combined.x), this.notGamma(combined.y), this.notGamma(combined.z));
                combined.lerp((Vector3fc)notGamma, gammaAmount);
                combined.lerp((Vector3fc)lightGray, lightGrayAmount);
                Lightmap.clampColor(combined);
                combined.mul(255.0f);
                long pixel = ((long)torchX + (long)skyY * 16L) * 4L;
                int x = (int)combined.x();
                int y = (int)combined.y();
                int z = (int)combined.z();
                int newColor = 0xFF000000 | z << 16 | y << 8 | x;
                int oldTexture = MemoryUtil.memGetInt((long)(this.lightmapPixels + pixel));
                if (newColor == oldTexture) continue;
                needsUpload = true;
                MemoryUtil.memPutInt((long)(this.lightmapPixels + pixel), (int)newColor);
            }
        }
        if (needsUpload) {
            Lightmap.resetTextureUploadState();
            RenderSystem.bindTextureForSetup((int)lightmap.method_30277());
            GlStateManager._texSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)16, (int)16, (int)class_1011.class_1012.field_4997.method_4333(), (int)5121, (long)this.lightmapPixels);
        }
    }

    public static void resetTextureUploadState() {
        GlStateManager._pixelStore((int)3314, (int)0);
        GlStateManager._pixelStore((int)3315, (int)0);
        GlStateManager._pixelStore((int)3316, (int)0);
        GlStateManager._pixelStore((int)3317, (int)4);
    }

    private float notGamma(float f) {
        float g = 1.0f - f;
        return 1.0f - g * g * g * g;
    }

    private float[][] selectSky(ArrayImage image, float nightVision, float time, float rain, float thunder, boolean isThunderFlash) {
        if (image == null) {
            return new float[0][];
        }
        double xVal = this.skyGetter.getValue(time, rain, thunder);
        float[][] skyLine = new float[16][];
        int usableSkyWidth = image.width() - 1 - (this.hasLightningColumn ? 1 : 0);
        int w = !isThunderFlash || !this.hasLightningColumn ? (isThunderFlash ? usableSkyWidth : Math.round((float)xVal * (float)usableSkyWidth)) : usableSkyWidth + 1;
        int h = nightVision != 0.0f && image.height() == 64 ? 32 : 0;
        for (int i = 0; i < 16; ++i) {
            skyLine[i] = ColorUtils.unpack(image.pixels()[h + i][w]);
        }
        return skyLine;
    }

    private float[][] selectTorch(ArrayImage image, float nightVision, float time, float rain, float thunder) {
        if (image == null || image.height() < 32) {
            return new float[0][];
        }
        double xVal = this.torchGetter.getValue(time, rain, thunder);
        float[][] torchLine = new float[16][];
        int h = 16 + (nightVision != 0.0f && image.height() == 64 ? 32 : 0);
        for (int i = 0; i < 16; ++i) {
            torchLine[i] = ColorUtils.unpack(image.pixels()[h + i][(int)(xVal * (double)(image.width() - 1))]);
        }
        return torchLine;
    }

    @Nullable
    private ArrayImage selectImage(float rain, float thunder) {
        ArrayImage image;
        if (thunder != 0.0f) {
            image = this.textures[2];
            if (image == null) {
                image = this.textures[0];
            }
        } else if (rain != 0.0f) {
            image = this.textures[1];
            if (image == null) {
                image = this.textures[0];
            }
        } else {
            image = this.textures[0];
        }
        return image;
    }

    private static void clampColor(Vector3f color) {
        color.set(class_3532.method_15363((float)color.x, (float)0.0f, (float)1.0f), class_3532.method_15363((float)color.y, (float)0.0f, (float)1.0f), class_3532.method_15363((float)color.z, (float)0.0f, (float)1.0f));
    }

    public static void lerpInplace(float[][] oldColors, float[][] newColors, float delta) {
        int i;
        if (oldColors.length != newColors.length || oldColors[0].length != newColors[0].length) {
            throw new IllegalArgumentException("Input arrays must have the same dimensions.");
        }
        int numRows = oldColors.length;
        int numCols = oldColors[0].length;
        for (i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                newColors[i][j] = class_3532.method_16439((float)delta, (float)oldColors[i][j], (float)newColors[i][j]);
            }
        }
        for (i = 0; i < numRows; ++i) {
            System.arraycopy(newColors[i], 0, oldColors[i], 0, numCols);
        }
    }
}

