/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6903;
import net.minecraft.class_7225;

public class CompoundReloader
extends class_4080<List<Object>> {
    private final List<PartialReloader<?>> children;
    private final List<Object> childrenResources = new ArrayList<Object>();

    public CompoundReloader(PartialReloader<?> ... reloaders) {
        this.children = List.of(reloaders);
    }

    protected List<Object> prepare(class_3300 resourceManager, class_3695 profiler) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (PartialReloader<?> c : this.children) {
            list.add(c.prepare(resourceManager));
        }
        return list;
    }

    protected void apply(List<Object> object, class_3300 resourceManager, class_3695 profiler) {
        class_638 level = class_310.method_1551().field_1687;
        this.childrenResources.clear();
        this.childrenResources.addAll(object);
        if (level != null) {
            this.applyWithLevel(level.method_30349(), false);
        }
    }

    public void applyWithLevel(class_5455 registryAccess, boolean firstLogin) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (!firstLogin) {
            this.resetWithLevel(false);
        }
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        for (int i = 0; i < this.childrenResources.size(); ++i) {
            PartialReloader<?> c = this.children.get(i);
            try {
                this.processTyped(c, this.childrenResources.get(i), (class_6903<JsonElement>)ops, registryAccess);
                continue;
            }
            catch (Exception e) {
                String message = String.valueOf(c) + " failed to parse some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        for (PartialReloader<?> c : this.children) {
            try {
                c.applyWithLevel(registryAccess, firstLogin);
            }
            catch (Exception e) {
                String message = String.valueOf(c) + " failed to apply some resources";
                Polytone.logException(e, message);
                Polytone.iMessedUp = true;
                Polytone.LOGGER.error(message);
                throw e;
            }
        }
        Polytone.LOGGER.info("Reloaded Polytone Resources in {} ms", (Object)stopwatch.elapsed().toMillis());
    }

    private <T> void processTyped(PartialReloader<T> reloader, Object object, class_6903<JsonElement> ops, class_5455 access) {
        reloader.parseWithLevel(object, ops, access);
    }

    public void resetWithLevel(boolean isLogOff) {
        for (PartialReloader<?> c : this.children) {
            c.resetWithLevel(isLogOff);
        }
    }

    public void earlyProcess(class_3300 resourceManager) {
        for (PartialReloader<?> c : this.children) {
            c.earlyProcess(resourceManager);
        }
    }
}

