/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.tabs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.utils.CodecUtil;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public interface ItemPredicate
extends Predicate<class_1799> {
    public static final MapRegistry.CodecMap<ItemPredicate> TYPES = MapRegistry.ofCodec("Polytone Item Predicates");
    public static final Codec<ItemPredicate> CODEC = TYPES.dispatch("type", ItemPredicate::getCodec, Function.identity());
    public static final True TRUE_PRED = new True();
    public static final Codec<True> TRUE = TYPES.register("true", Codec.unit((Object)TRUE_PRED));
    public static final Codec<And> AND = TYPES.register("and", CODEC.listOf().fieldOf("predicates").xmap(And::new, And::predicates).codec());
    public static final Codec<Or> OR = TYPES.register("or", CODEC.listOf().fieldOf("predicates").xmap(Or::new, Or::predicates).codec());
    public static final Codec<Not> NOT = TYPES.register("not", CODEC.fieldOf("predicate").xmap(Not::new, Not::predicate).codec());
    public static final Codec<TagMatch> TAG_MATCH = TYPES.register("tag_match", class_6862.method_40090((class_5321)class_7924.field_41197).fieldOf("tag").xmap(TagMatch::new, TagMatch::tag).codec());
    public static final Codec<ItemMatch> ITEM_MATCH = TYPES.register("items_match", class_7923.field_41178.method_39673().listOf().fieldOf("items").xmap(ItemMatch::new, ItemMatch::items).codec());
    public static final Codec<ItemStackMatch> ITEMSTACK_MATCH = TYPES.register("itemstack_match", CodecUtil.ITEMSTACK.fieldOf("itemstack").xmap(ItemStackMatch::new, ItemStackMatch::items).codec());
    public static final Pattern TRUE_PATTERN = Pattern.compile(".*");
    public static final Codec<IDMatch> ID_MATCH = TYPES.register("id_match", RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(class_5699.field_37408, "namespace", TRUE_PATTERN).forGetter(IDMatch::namespace), (App)StrOpt.of(class_5699.field_37408, "path", TRUE_PATTERN).forGetter(IDMatch::path)).apply((Applicative)i, IDMatch::new)));

    public Codec<? extends ItemPredicate> getCodec();

    public static class True
    implements ItemPredicate {
        @Override
        public boolean test(class_1799 stack) {
            return true;
        }

        public Codec<True> getCodec() {
            return TRUE;
        }
    }

    public record IDMatch(Pattern namespace, Pattern path) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            class_1792 item = stack.method_7909();
            class_2960 id = item.method_40131().method_40237().method_29177();
            return this.namespace.matcher(id.method_12836()).find() && this.path.matcher(id.method_12832()).find();
        }

        public Codec<IDMatch> getCodec() {
            return ID_MATCH;
        }
    }

    public record ItemStackMatch(class_1799 items) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            return class_1799.method_7973((class_1799)this.items, (class_1799)stack);
        }

        public Codec<ItemStackMatch> getCodec() {
            return ITEMSTACK_MATCH;
        }
    }

    public record ItemMatch(List<class_1792> items) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            return this.items.contains(stack.method_7909());
        }

        public Codec<ItemMatch> getCodec() {
            return ITEM_MATCH;
        }
    }

    public record TagMatch(class_6862<class_1792> tag) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            return stack.method_31573(this.tag);
        }

        public Codec<TagMatch> getCodec() {
            return TAG_MATCH;
        }
    }

    public record Not(ItemPredicate predicate) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            return !this.predicate.test(stack);
        }

        public Codec<Not> getCodec() {
            return NOT;
        }
    }

    public record Or(List<ItemPredicate> predicates) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            return this.predicates.stream().anyMatch(p -> p.test(stack));
        }

        public Codec<Or> getCodec() {
            return OR;
        }
    }

    public record And(List<ItemPredicate> predicates) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            return this.predicates.stream().allMatch(p -> p.test(stack));
        }

        @Override
        public Codec<? extends ItemPredicate> getCodec() {
            return AND;
        }
    }
}

