/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.sound;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.sound.PolytoneSoundType;
import net.mehvahdjukaar.polytone.utils.CsvUtils;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SoundTypesManager
extends PartialReloader<Resources> {
    private final MapRegistry<class_3414> customSoundEvents = new MapRegistry("Custom Sound Events");
    private final MapRegistry<class_2498> customSoundTypes = new MapRegistry("Custom Sound Types");

    public SoundTypesManager() {
        super("custom_sound_types", "sound_types");
    }

    @Nullable
    public class_2498 getCustomSoundType(class_2960 resourceLocation) {
        return this.customSoundTypes.getValue(resourceLocation);
    }

    @Override
    protected Resources prepare(class_3300 resourceManager) {
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        Map<class_2960, List<String>> types = CsvUtils.parseCsv(resourceManager, "sound_events");
        return new Resources((Map<class_2960, JsonElement>)ImmutableMap.copyOf(jsons), (Map<class_2960, List<String>>)ImmutableMap.copyOf(types));
    }

    @Override
    protected void parseWithLevel(Resources resources, class_6903<JsonElement> ops, class_5455 access) {
        Map<class_2960, JsonElement> soundJsons = resources.soundTypes;
        Map<class_2960, List<String>> soundEvents = resources.soundEvents;
        for (Map.Entry<class_2960, List<String>> entry : soundEvents.entrySet()) {
            for (String s : entry.getValue()) {
                class_2960 id = entry.getKey().method_45136(s);
                if (!this.customSoundEvents.containsKey(id) && !class_7923.field_41172.method_10250(id)) {
                    class_3414 newSound = class_3414.method_47908((class_2960)id);
                    this.customSoundEvents.register(id, newSound);
                    continue;
                }
                Polytone.LOGGER.error("Sound Event with id {} already exists! Ignoring.", (Object)id);
            }
        }
        for (Map.Entry<class_2960, List<String>> entry : this.customSoundEvents.getEntries()) {
            class_2960 id = entry.getKey();
            class_3414 sound = (class_3414)entry.getValue();
            PlatStuff.registerDynamic(class_7923.field_41172, id, sound);
        }
        for (Map.Entry<class_2960, List<String>> entry : soundJsons.entrySet()) {
            class_2960 id;
            JsonElement json = (JsonElement)entry.getValue();
            class_2498 soundType = Parsed.parseOrNull(PolytoneSoundType.DIRECT_CODEC, json, ops, id = entry.getKey(), "sound type");
            if (soundType == null) continue;
            this.customSoundTypes.register(id, soundType);
        }
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
        if (!this.customSoundEvents.isEmpty()) {
            Polytone.LOGGER.info("Registered {} custom Sound Events from Resource Packs: {}", (Object)this.customSoundEvents.size(), (Object)(String.valueOf(this.customSoundEvents) + ". Remember to add them to sounds.json!"));
            class_310.method_1551().method_1483().method_38566();
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        for (Map.Entry<class_2960, class_3414> e : this.customSoundEvents.getEntries()) {
            class_2960 id = e.getKey();
            PlatStuff.unregisterDynamic(class_7923.field_41172, id);
        }
        this.customSoundTypes.clear();
        this.customSoundEvents.clear();
    }

    public boolean isDynamicSound(class_2960 entryId) {
        return this.customSoundEvents.containsKey(entryId);
    }

    public record Resources(Map<class_2960, JsonElement> soundTypes, Map<class_2960, List<String>> soundEvents) {
    }
}

