/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.particle.ParticleModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_703;
import net.minecraft.class_7923;

public class ParticleModifiersManager
extends JsonImgPartialReloader {
    private final Multimap<class_2396<?>, ParticleModifier> particleModifiers = HashMultimap.create();

    public ParticleModifiersManager() {
        super("particle_modifiers");
    }

    public void maybeModify(class_2394 options, class_1937 level, class_703 particle) {
        Collection mod = this.particleModifiers.get((Object)options.method_10295());
        for (ParticleModifier modifier : mod) {
            modifier.modify(particle, level, options);
        }
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, class_6903<JsonElement> ops, class_5455 access) {
        class_2960 id;
        Object modifier;
        Map<class_2960, JsonElement> jsons = resources.jsons();
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>(resources.textures());
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        Map parsedModifiers = Utils.sortedMap();
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            class_2960 id2 = entry.getKey();
            modifier = Parsed.parseOptionalOrPartial(ParticleModifier.CODEC, ParticleModifier.PARTIAL_CODEC, json, ops, id2, "particle modifier");
            parsedModifiers.put(id2, modifier);
        }
        for (Map.Entry<class_2960, Object> entry : parsedModifiers.entrySet()) {
            id = entry.getKey();
            Parsed parsed = (Parsed)entry.getValue();
            modifier = (ParticleModifier)parsed.getResultOrPartial();
            if (!((ParticleModifier)modifier).hasColormap() && textures.containsKey(id)) {
                ((ParticleModifier)modifier).setColormap(Colormap.createDefTriangle());
            }
            class_322 tint = ((ParticleModifier)modifier).getColormap();
            ColormapsManager.tryAcceptingTexture(textures, id, tint, usedTextures, true);
            if (!parsed.isEnabled()) continue;
            this.addModifier(id, (ParticleModifier)modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<class_2960, Object> entry : textures.entrySet()) {
            id = entry.getKey();
            Colormap defaultColormap = Colormap.createDefTriangle();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, ParticleModifier.ofColormap(defaultColormap));
        }
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
        if (!this.particleModifiers.isEmpty()) {
            Polytone.LOGGER.info("Registered {} particle modifiers", (Object)this.particleModifiers.size());
        }
    }

    private void addModifier(class_2960 pathId, ParticleModifier mod) {
        for (class_6880 p : mod.targets().compute(pathId, class_7923.field_41180)) {
            this.particleModifiers.put((Object)((class_2396)p.comp_349()), (Object)mod);
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.particleModifiers.clear();
    }

    public void addCustomParticleColor(class_2960 id, String color) {
        Optional opt = class_7923.field_41180.method_17966(id);
        opt.ifPresent(t -> this.particleModifiers.put(t, (Object)ParticleModifier.ofColor(color)));
    }
}

