/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockClientTickable;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3818;
import net.minecraft.class_3825;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record BlockParticleEmitter(class_2396<?> particleType, BlockContextExpression chance, BlockContextExpression count, BlockContextExpression x, BlockContextExpression y, BlockContextExpression z, BlockContextExpression dx, BlockContextExpression dy, BlockContextExpression dz, class_3825 predicate, Optional<class_6885<class_1959>> biomes, SpawnLocation spawnLocation) implements BlockClientTickable
{
    public static final Codec<BlockParticleEmitter> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_7923.field_41180.method_39673().fieldOf("particle").forGetter(BlockParticleEmitter::particleType), (App)StrOpt.of(BlockContextExpression.CODEC, "chance", BlockContextExpression.ONE).forGetter(BlockParticleEmitter::chance), (App)StrOpt.of(BlockContextExpression.CODEC, "count", BlockContextExpression.ONE).forGetter(BlockParticleEmitter::count), (App)StrOpt.of(BlockContextExpression.CODEC, "x", BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::x), (App)StrOpt.of(BlockContextExpression.CODEC, "y", BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::y), (App)StrOpt.of(BlockContextExpression.CODEC, "z", BlockContextExpression.PARTICLE_RAND).forGetter(BlockParticleEmitter::z), (App)StrOpt.of(BlockContextExpression.CODEC, "dx", BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dx), (App)StrOpt.of(BlockContextExpression.CODEC, "dy", BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dy), (App)StrOpt.of(BlockContextExpression.CODEC, "dz", BlockContextExpression.ZERO).forGetter(BlockParticleEmitter::dz), (App)class_3825.field_25012.optionalFieldOf("state_predicate", (Object)class_3818.field_16868).forGetter(BlockParticleEmitter::predicate), (App)class_6895.method_40340((class_5321)class_7924.field_41236).optionalFieldOf("biomes").forGetter(BlockParticleEmitter::biomes), (App)StrOpt.of(SpawnLocation.CODEC, "spawn_location", SpawnLocation.CENTER).forGetter(BlockParticleEmitter::spawnLocation)).apply((Applicative)i, BlockParticleEmitter::new));

    @Override
    public void tick(class_1937 level, class_2338 pos, class_2680 state) {
        double spawnChance = this.chance.getValue(level, pos, state);
        if ((double)level.field_9229.method_43057() < spawnChance && this.predicate().method_16768(state, level.field_9229)) {
            if (this.biomes.isPresent()) {
                class_6880 biome = level.method_23753(pos);
                if (!this.biomes.get().method_40241(biome)) {
                    return;
                }
            }
            int i = 0;
            while ((double)i < this.count.getValue(level, pos, state)) {
                CustomParticleType.setStateHack(state);
                class_2394 po = this.getParticleOptions(state);
                if (po == null) {
                    return;
                }
                level.method_8406(po, (double)pos.method_10263() + this.x.getValue(level, pos, state), (double)pos.method_10264() + this.y.getValue(level, pos, state), (double)pos.method_10260() + this.z.getValue(level, pos, state), this.dx.getValue(level, pos, state), this.dy.getValue(level, pos, state), this.dz.getValue(level, pos, state));
                ++i;
            }
        }
    }

    @Nullable
    private class_2394 getParticleOptions(class_2680 state) {
        class_2400 po;
        class_2396<?> class_23962 = this.particleType;
        if (class_23962 instanceof class_2400) {
            class_2400 st;
            po = st = (class_2400)class_23962;
        } else if (this.particleType == class_2398.field_11217 || this.particleType == class_2398.field_11206 || this.particleType == class_2398.field_35434) {
            po = new class_2388(this.particleType, state);
        } else if (this.particleType == class_2398.field_11218) {
            po = new class_2392(this.particleType, state.method_26204().method_8389().method_7854());
        } else {
            Polytone.LOGGER.error("Unsupported particle type: {}", this.particleType);
            return null;
        }
        return po;
    }

    public static class_243 getParticleSpawnPosOnFace(class_5819 random, class_2338 pos, class_2350 direction) {
        class_243 vec3 = class_243.method_24953((class_2382)pos);
        int i = direction.method_10148();
        int j = direction.method_10164();
        int k = direction.method_10165();
        double d0 = vec3.field_1352 + (i == 0 ? class_3532.method_15366((class_5819)random, (double)-0.5, (double)0.5) : (double)i * 0.6);
        double d1 = vec3.field_1351 + (j == 0 ? class_3532.method_15366((class_5819)random, (double)-0.5, (double)0.5) : (double)j * 0.6);
        double d2 = vec3.field_1350 + (k == 0 ? class_3532.method_15366((class_5819)random, (double)-0.5, (double)0.5) : (double)k * 0.6);
        return new class_243(d0, d1, d2);
    }

    public static enum SpawnLocation {
        CENTER,
        LOWER_CORNER,
        BLOCK_FACES;

        public static final Codec<SpawnLocation> CODEC;

        class_243 getLocation(class_2338 pos, class_2680 state, class_5819 rand) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> class_243.method_24954((class_2382)pos);
                case 0 -> class_243.method_24953((class_2382)pos);
                case 2 -> {
                    class_2350 dir = class_2350.values()[rand.method_43048(class_2350.values().length)];
                    yield BlockParticleEmitter.getParticleSpawnPosOnFace(rand, pos, dir);
                }
            };
        }

        static {
            CODEC = Codec.STRING.xmap(s -> SpawnLocation.valueOf(s.toUpperCase(Locale.ROOT)), e -> e.name().toLowerCase(Locale.ROOT));
        }
    }
}

