/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3980;
import net.minecraft.class_4538;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class Colormap
implements IColorGetter,
class_6539 {
    private final IColormapNumberProvider xGetter;
    private final IColormapNumberProvider yGetter;
    private final BiomeIdMapper biomeMapper;
    private final boolean triangular;
    private final boolean rounds;
    private final boolean hasBiomeBlend;
    private final boolean usesBiome;
    private final boolean usesPos;
    private final boolean usesState;
    public boolean inlined = true;
    private Integer defaultColor;
    private ArrayImage image = null;
    @Nullable
    private class_2960 explicitTargetTexture;
    @Nullable
    protected Dynamic<?> lazyFallback;
    @Nullable
    protected IColorGetter fallback;
    private final ThreadLocal<class_2680> stateHack = new ThreadLocal();
    private final ThreadLocal<Integer> yHack = new ThreadLocal();
    public static final Codec<Colormap> DIRECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(ColorUtils.CODEC, "default_color").forGetter(c -> Optional.ofNullable(c.defaultColor)), (App)IColormapNumberProvider.CODEC.fieldOf("x_axis").forGetter(c -> c.xGetter), (App)IColormapNumberProvider.CODEC.fieldOf("y_axis").forGetter(c -> c.yGetter), (App)StrOpt.of(Codec.BOOL, "triangular", false).forGetter(c -> c.triangular), (App)Codec.BOOL.optionalFieldOf("rounds", (Object)true).forGetter(c -> c.rounds), (App)StrOpt.of(Codec.BOOL, "biome_blend").forGetter(c -> Optional.of(c.hasBiomeBlend)), (App)StrOpt.of(BiomeIdMapper.CODEC, "biome_id_mapper").forGetter(c -> Optional.of(c.biomeMapper)), (App)StrOpt.of(class_2960.field_25139, "texture_path").forGetter(c -> Optional.ofNullable(c.explicitTargetTexture)), (App)Codec.PASSTHROUGH.optionalFieldOf("fallback_colormap").forGetter(c -> Optional.empty())).apply((Applicative)i, Colormap::new));
    protected static final Codec<IColorGetter> SINGLE_COLOR_CODEC = ColorUtils.CODEC.xmap(Colormap::singleColor, c -> {
        Integer n;
        if (c instanceof Colormap) {
            Colormap cm = (Colormap)c;
            n = cm.defaultColor;
        } else {
            n = 0;
        }
        return n;
    });
    public static final Codec<IColorGetter> COLORMAP_CODEC = Codec.either(SINGLE_COLOR_CODEC, new ReferenceOrDirectCodec<Colormap>(Polytone.COLORMAPS.byNameCodec(), DIRECT_CODEC)).xmap(a -> (IColorGetter)a.map(b -> b, c -> c), Either::right);
    public static final Codec<IColorGetter> CODEC = COLORMAP_CODEC;

    private Colormap(Optional<Integer> defaultColor, IColormapNumberProvider xGetter, IColormapNumberProvider yGetter, boolean triangular, boolean rounds, Optional<Boolean> biomeBlend, Optional<BiomeIdMapper> biomeMapper, Optional<class_2960> explicitTargetTexture, Optional<Dynamic<?>> fallback) {
        this.defaultColor = defaultColor.orElse(null);
        this.xGetter = xGetter;
        this.yGetter = yGetter;
        this.triangular = triangular;
        this.rounds = rounds;
        this.usesBiome = xGetter.usesBiome() || yGetter.usesBiome();
        this.usesPos = this.usesBiome || xGetter.usesPos() || yGetter.usesPos();
        this.usesState = xGetter.usesState() || yGetter.usesState();
        this.hasBiomeBlend = biomeBlend.orElse(this.usesBiome);
        this.biomeMapper = biomeMapper.orElse(BiomeIdMapper.BY_INDEX);
        this.explicitTargetTexture = explicitTargetTexture.orElse(null);
        this.lazyFallback = fallback.orElse(null);
    }

    protected Colormap(IColormapNumberProvider xGetter, IColormapNumberProvider yGetter, boolean triangular) {
        this(Optional.empty(), xGetter, yGetter, triangular, true, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public void acceptTexture(ArrayImage image) {
        this.image = image;
        if (this.defaultColor == null) {
            this.defaultColor = this.sample(0.5f, 0.5f, -1);
        }
    }

    public boolean hasTexture() {
        return this.image != null;
    }

    protected class_2960 getExplicitTargetTexture() {
        return this.explicitTargetTexture;
    }

    public class_2960 getTargetTexture(class_2960 def) {
        return this.explicitTargetTexture != null ? this.explicitTargetTexture : def;
    }

    public void setExplicitTargetTexture(class_2960 imageTarget) {
        this.explicitTargetTexture = imageTarget.method_45136(imageTarget.method_12832().replace(".png", ""));
    }

    public int getColor(@Nullable class_2680 state, @Nullable class_1920 level, @Nullable class_2338 pos, int i) {
        if (level == null) {
            return this.defaultColor;
        }
        if (pos == null && (this.usesPos || this.usesBiome)) {
            return this.defaultColor;
        }
        if (state == null && this.usesState) {
            return this.defaultColor;
        }
        if (this.hasBiomeBlend) {
            this.stateHack.set(state);
            this.yHack.set(pos != null ? pos.method_10264() : 0);
            return level.method_23752(pos, (class_6539)this);
        }
        class_1959 biome = null;
        if (this.usesBiome && level instanceof class_4538) {
            class_4538 l = (class_4538)level;
            biome = (class_1959)l.method_23753(pos).comp_349();
        }
        return this.sampleColor(state, pos, biome, null);
    }

    public int sampleColor(@Nullable class_2680 state, @Nullable class_2338 pos, @Nullable class_1959 biome, @Nullable class_1799 item) {
        float temperature = class_3532.method_15363((float)this.xGetter.getValue(state, pos, biome, this.biomeMapper, item), (float)0.0f, (float)1.0f);
        float humidity = class_3532.method_15363((float)this.yGetter.getValue(state, pos, biome, this.biomeMapper, item), (float)0.0f, (float)1.0f);
        int sampled = this.sample(humidity, temperature, this.defaultColor);
        if (this.fallback == null || sampled == 0) {
            // empty if block
        }
        return sampled;
    }

    public int getColor(class_1959 biome, double x, double z) {
        Integer y = this.yHack.get();
        if (y == null) {
            y = 0;
        }
        return this.sampleColor(this.stateHack.get(), class_2338.method_49637((double)x, (double)y.intValue(), (double)z), biome, null);
    }

    public int calculateBlendedColor(class_1937 level, class_2338 pos) {
        int i = (Integer)class_310.method_1551().field_1690.method_41805().method_41753();
        class_2680 state = this.stateHack.get();
        if (i == 0) {
            return this.sampleColor(state, pos, (class_1959)level.method_23753(pos).comp_349(), null);
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int m = 0;
        class_3980 cursor3D = new class_3980(pos.method_10263() - i, pos.method_10264(), pos.method_10260() - i, pos.method_10263() + i, pos.method_10264(), pos.method_10260() + i);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        while (cursor3D.method_17963()) {
            mutableBlockPos.method_10103(cursor3D.method_18671(), cursor3D.method_18672(), cursor3D.method_18673());
            int n = this.sampleColor(state, (class_2338)mutableBlockPos, (class_1959)level.method_23753((class_2338)mutableBlockPos).comp_349(), null);
            k += (n & 0xFF0000) >> 16;
            l += (n & 0xFF00) >> 8;
            m += n & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | m / j & 0xFF;
    }

    private int sample(float textY, float textX, int defValue) {
        if (this.triangular) {
            textY *= textX;
        }
        int width = this.image.width();
        int height = this.image.height();
        int wm = width - 1;
        int hm = height - 1;
        int scaledW = this.rounds ? Math.round(textX * (float)width) : class_3532.method_15375((float)(textX * (float)width));
        int scaledH = this.rounds ? Math.round(textY * (float)height) : class_3532.method_15375((float)(textY * (float)height));
        int w = Math.max(wm - scaledW, 0);
        int h = Math.max(hm - scaledH, 0);
        return this.image.pixels()[h][w];
    }

    public int getColor(class_1799 itemStack, int i) {
        class_2338 pos = null;
        class_1959 biome = null;
        if (this.usesPos) {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return this.defaultColor;
            }
            pos = player.method_24515();
            if (this.usesBiome) {
                class_638 level = class_310.method_1551().field_1687;
                if (level == null) {
                    return this.defaultColor;
                }
                biome = (class_1959)level.method_23753(pos).comp_349();
            }
        }
        return this.sampleColor(null, pos, biome, itemStack);
    }

    public static Colormap simple(IColormapNumberProvider xGetter, IColormapNumberProvider yGetter) {
        return new Colormap(xGetter, yGetter, false);
    }

    public static Colormap createFixed() {
        return new Colormap(Optional.empty(), IColormapNumberProvider.ZERO, IColormapNumberProvider.ZERO, false, true, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static Colormap singleColor(int color) {
        Colormap c = new Colormap(IColormapNumberProvider.ZERO, IColormapNumberProvider.ZERO, false);
        c.acceptTexture(new ArrayImage(new int[][]{{color}}));
        return c;
    }

    public static Colormap createDefSquare() {
        return new Colormap(IColormapNumberProvider.TEMPERATURE, IColormapNumberProvider.DOWNFALL, false);
    }

    public static Colormap createDefTriangle() {
        return new Colormap(IColormapNumberProvider.TEMPERATURE, IColormapNumberProvider.DOWNFALL, true);
    }

    public static Colormap createTimeStrip() {
        return new Colormap(IColormapNumberProvider.DAY_TIME, IColormapNumberProvider.ZERO, false);
    }

    public static Colormap createBiomeId() {
        return new Colormap(Optional.empty(), IColormapNumberProvider.BIOME_ID, IColormapNumberProvider.Y_LEVEL, false, false, Optional.of(Boolean.TRUE), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static Colormap createDamage() {
        return new Colormap(IColormapNumberProvider.DAMAGE, IColormapNumberProvider.ZERO, false);
    }
}

