/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.biome;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6903;

public class BiomeIdMapperManager
extends JsonPartialReloader {
    private final MapRegistry<BiomeIdMapper> biomeIdMappers = new MapRegistry("Biome ID Mappers");

    public BiomeIdMapperManager() {
        super("biome_id_mappers");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.biomeIdMappers.clear();
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_5455 access) {
        for (Map.Entry<class_2960, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            class_2960 id = j.getKey();
            BiomeIdMapper mapper = (BiomeIdMapper)((Pair)BiomeIdMapper.CODEC.decode(ops, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode Biome ID mapper with json id {} - error: {}", (Object)id, errorMsg))).getFirst();
            try {
                this.biomeIdMappers.register(id, mapper);
            }
            catch (Exception e) {
                Polytone.LOGGER.warn("Found duplicate biome in biome id mapper {}", (Object)id);
            }
        }
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
    }

    public Codec<BiomeIdMapper> byNameCodec() {
        return this.biomeIdMappers;
    }
}

