/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public record Targets(List<Entry> entries) {
    public static final Targets EMPTY = new Targets(List.of());
    private static final Codec<Entry> SIMPLE_TAG_OR_REGEX_ENTRY_CODEC = Codec.withAlternative(SimpleLocation.SIMPLE_CODEC, (Codec)Codec.withAlternative(TagLocation.TAG_CODEC, RegexLocation.REGEX_CODEC));
    private static final Codec<Entry> ENTRY_CODEC = Codec.withAlternative(SIMPLE_TAG_OR_REGEX_ENTRY_CODEC, OptionalEntry.OPTIONAL_CODEC);
    public static final Codec<Targets> CODEC = Codec.withAlternative((Codec)ENTRY_CODEC.xmap(List::of, List::getFirst), (Codec)ENTRY_CODEC.listOf()).xmap(Targets::new, t -> t.entries);

    public static Targets ofIds(Set<class_2960> blocks) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (class_2960 id : blocks) {
            entries.add(new SimpleLocation(id));
        }
        return new Targets(entries);
    }

    public static Targets ofOptionalIds(Set<class_2960> blocks) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (class_2960 id : blocks) {
            entries.add(new OptionalEntry(new SimpleLocation(id), false));
        }
        return new Targets(entries);
    }

    public <T> Collection<class_6880<T>> compute(class_2960 fileId, class_2378<T> registry) {
        HashSet<class_6880<T>> set = new HashSet<class_6880<T>>();
        Optional implicitTarget = registry.method_55841(fileId);
        if (!this.entries.isEmpty()) {
            if (implicitTarget.isPresent()) {
                Polytone.LOGGER.warn("Found Polytone file with explicit Targets ({}) also having a valid IMPLICIT (file path) Target ({}).Consider moving it under your OWN namespace to avoid overriding other packs modifiers with the same path", this.entries, (Object)fileId);
            }
            for (Entry entry : this.entries) {
                for (class_6880<T> holder : entry.get(registry)) {
                    set.add(holder);
                }
            }
        } else if (implicitTarget.isPresent()) {
            set.add((class_6880)implicitTarget.get());
        } else {
            Polytone.LOGGER.error("Found Polytone file {} with no valid implicit targets and no explicit targets from registry {}", (Object)fileId, registry);
        }
        return set;
    }

    public Targets merge(Targets other) {
        return new Targets(Utils.mergeList(this.entries, other.entries));
    }

    public void addSimple(class_2960 id) {
        SimpleLocation simpleLocation = new SimpleLocation(id);
        this.entries.add(simpleLocation);
    }

    public void addTag(class_2960 id) {
        TagLocation tagLocation = new TagLocation(id);
        this.entries.add(tagLocation);
    }

    private record SimpleLocation(class_2960 id) implements Entry
    {
        public static final Codec<SimpleLocation> SIMPLE_CODEC = class_2960.field_25139.xmap(SimpleLocation::new, s -> s.id);

        @Override
        public <T> Iterable<? extends class_6880<T>> get(class_2378<T> reg) {
            class_5321 key = class_5321.method_29179((class_5321)reg.method_30517(), (class_2960)this.id);
            Optional holder = reg.method_40264(key);
            if (holder.isEmpty() && this.id.method_12836().equals("minecraft")) {
                Polytone.LOGGER.warn("Found missing ID in minecraft namespace: {}", (Object)(String.valueOf(this.id) + ". Skipping."));
                return List.of();
            }
            return List.of((class_6880.class_6883)holder.orElseThrow(() -> new IllegalStateException("Entry not found: " + String.valueOf(this.id))));
        }
    }

    private record OptionalEntry(Entry entry, boolean required) implements Entry
    {
        public static final Codec<OptionalEntry> OPTIONAL_CODEC = RecordCodecBuilder.create(i -> i.group((App)SIMPLE_TAG_OR_REGEX_ENTRY_CODEC.fieldOf("id").forGetter(OptionalEntry::entry), (App)Codec.BOOL.optionalFieldOf("required", (Object)true).forGetter(OptionalEntry::required)).apply((Applicative)i, OptionalEntry::new));

        @Override
        public <T> Iterable<? extends class_6880<T>> get(class_2378<T> reg) {
            try {
                return this.entry.get(reg);
            }
            catch (IllegalStateException e) {
                if (this.required) {
                    throw e;
                }
                return List.of();
            }
        }

        @Override
        public String toString() {
            return "OPT{entry=" + String.valueOf(this.entry) + ", required=" + this.required + "}";
        }
    }

    private static interface Entry {
        public <T> Iterable<? extends class_6880<T>> get(class_2378<T> var1);
    }

    private record TagLocation(class_2960 id) implements Entry
    {
        public static final Codec<TagLocation> TAG_CODEC = Codec.STRING.flatXmap(s -> {
            if (s.startsWith("#")) {
                return class_2960.method_29186((String)s.substring(1)).map(TagLocation::new);
            }
            return DataResult.error(() -> "Tag location must start with #");
        }, id -> DataResult.success((Object)id.toString()));

        public <T> Iterable<class_6880<T>> get(class_2378<T> reg) {
            class_6862 key = class_6862.method_40092((class_5321)reg.method_30517(), (class_2960)this.id);
            return (Iterable)reg.method_40266(key).orElseThrow(() -> new IllegalStateException("Tag not found: " + String.valueOf(this.id)));
        }

        @Override
        public String toString() {
            return "#" + String.valueOf(this.id);
        }
    }

    private record RegexLocation(Pattern regex) implements Entry
    {
        public static final Codec<RegexLocation> REGEX_CODEC = Codec.STRING.xmap(s -> new RegexLocation(Pattern.compile(s)), r -> r.regex.pattern());

        @Override
        public <T> Iterable<? extends class_6880<T>> get(class_2378<T> reg) {
            return reg.method_40270().filter(e -> this.regex.matcher(e.method_40237().method_29177().toString()).matches()).toList();
        }

        @Override
        public String toString() {
            return "RE: " + this.regex.pattern();
        }
    }
}

