/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.slotify.GuiModifier;
import net.mehvahdjukaar.polytone.slotify.ScreenModifier;
import net.mehvahdjukaar.polytone.slotify.SlotModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiModifierManager
extends JsonPartialReloader {
    private final Map<class_3917<?>, Int2ObjectArrayMap<SlotModifier>> slotsByMenuId = new IdentityHashMap();
    private final Map<Class<?>, Int2ObjectArrayMap<SlotModifier>> slotsByClass = new IdentityHashMap();
    private final Map<String, Int2ObjectArrayMap<SlotModifier>> slotsByTitle = new HashMap<String, Int2ObjectArrayMap<SlotModifier>>();
    public final Map<class_3917<?>, ScreenModifier> byMenuId = new IdentityHashMap();
    public final Map<Class<?>, ScreenModifier> byClass = new IdentityHashMap();
    public final Map<String, ScreenModifier> byTitle = new HashMap<String, ScreenModifier>();
    private static final class_2960 INVENTORY = class_2960.method_60654((String)"inventory");

    public GuiModifierManager() {
        super("gui_modifiers");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.slotsByMenuId.clear();
        this.slotsByClass.clear();
        this.slotsByTitle.clear();
        this.byMenuId.clear();
        this.byClass.clear();
        this.byTitle.clear();
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_5455 access) {
        ArrayList<GuiModifier> allModifiers = new ArrayList<GuiModifier>();
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            class_2960 id;
            JsonElement json = entry.getValue();
            GuiModifier modifier = Parsed.parseOrNull(GuiModifier.CODEC, json, ops, id = entry.getKey(), "gui modifier");
            if (modifier == null) continue;
            allModifiers.add(modifier);
        }
        for (GuiModifier mod : allModifiers) {
            if (mod.targetsClass()) {
                String target = mod.target();
                try {
                    Class cl = target.equals("InventoryMenu") ? class_1723.class : (target.equals("ItemPickerMenu") ? class_481.class_483.class : Class.forName(target));
                    this.byClass.merge(cl, ScreenModifier.fromGuiMod(mod), ScreenModifier::merge);
                    if (mod.slotModifiers().isEmpty()) continue;
                    Int2ObjectArrayMap map = this.slotsByClass.computeIfAbsent(cl, i -> new Int2ObjectArrayMap());
                    GuiModifierManager.unwrapSlots(mod, (Int2ObjectArrayMap<SlotModifier>)map);
                }
                catch (ClassNotFoundException ignored) {
                    Polytone.LOGGER.error("Could not find class target with name {}", (Object)target);
                }
                continue;
            }
            if (mod.targetsMenuId()) {
                class_2960 menuId = class_2960.method_60654((String)mod.target());
                boolean isInventory = menuId.equals((Object)INVENTORY);
                Optional menu = class_7923.field_41187.method_17966(menuId);
                if (!menu.isPresent() && !isInventory) continue;
                this.byMenuId.merge(menu.orElse(null), ScreenModifier.fromGuiMod(mod), ScreenModifier::merge);
                if (mod.slotModifiers().isEmpty()) continue;
                Int2ObjectArrayMap map = this.slotsByMenuId.computeIfAbsent(menu.orElse(null), i -> new Int2ObjectArrayMap());
                GuiModifierManager.unwrapSlots(mod, (Int2ObjectArrayMap<SlotModifier>)map);
                continue;
            }
            String title = mod.target();
            this.byTitle.merge(title, ScreenModifier.fromGuiMod(mod), ScreenModifier::merge);
            if (mod.slotModifiers().isEmpty()) continue;
            Int2ObjectArrayMap map = this.slotsByTitle.computeIfAbsent(title, i -> new Int2ObjectArrayMap());
            GuiModifierManager.unwrapSlots(mod, (Int2ObjectArrayMap<SlotModifier>)map);
        }
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
        if (!(this.slotsByMenuId.isEmpty() && this.slotsByClass.isEmpty() && this.slotsByTitle.isEmpty())) {
            Polytone.LOGGER.info("Loaded GUI modifiers for: {} {} {} {}", this.slotsByMenuId.keySet(), this.slotsByClass.keySet(), this.byMenuId.keySet(), this.byClass.keySet());
        }
    }

    private static void unwrapSlots(GuiModifier mod, Int2ObjectArrayMap<SlotModifier> map) {
        for (SlotModifier s : mod.slotModifiers()) {
            for (int i : s.targets().getSlots()) {
                map.merge(i, (Object)s, SlotModifier::merge);
            }
        }
    }

    private ScreenModifier getScreenModifier(class_465<?> screen) {
        ScreenModifier m = null;
        class_1703 menu = screen.method_17577();
        if (screen.getClass() == class_490.class) {
            m = this.byClass.get(class_1723.class);
        } else if (screen.getClass() == class_481.class) {
            m = this.byClass.get(class_481.class_483.class);
        }
        if (menu != null) {
            m = this.byClass.get(menu.getClass());
        }
        if (m == null) {
            class_3917 type;
            try {
                type = menu.method_17358();
            }
            catch (Exception e) {
                type = null;
            }
            m = this.byMenuId.get(type);
        }
        return m;
    }

    @Nullable
    public ScreenModifier getGuiModifier(class_437 screen) {
        class_5250 mc;
        class_7417 class_74172;
        class_2561 c;
        ScreenModifier m = this.byClass.get(screen.getClass());
        if (m == null && screen instanceof class_465) {
            class_465 as = (class_465)screen;
            m = this.getScreenModifier(as);
        }
        try {
            c = screen.method_25440();
        }
        catch (Exception e) {
            return null;
        }
        if (m == null) {
            m = this.byTitle.get(c.getString());
        }
        if (m == null && c instanceof class_5250 && (class_74172 = (mc = (class_5250)c).method_10851()) instanceof class_2588) {
            class_2588 tc = (class_2588)class_74172;
            m = this.byTitle.get(tc.method_11022());
        }
        return m;
    }

    @Nullable
    public SlotModifier getSlotModifier(class_465<?> screen, class_1735 slot) {
        class_5250 mc;
        class_7417 class_74172;
        Int2ObjectArrayMap<SlotModifier> m = null;
        class_2561 c = screen.method_25440();
        m = this.slotsByTitle.get(c.getString());
        if (m == null && c instanceof class_5250 && (class_74172 = (mc = (class_5250)c).method_10851()) instanceof class_2588) {
            class_2588 tc = (class_2588)class_74172;
            m = this.slotsByTitle.get(tc.method_11022());
        }
        if (m == null) {
            m = this.slotsByClass.get(screen.getClass());
        }
        if (m == null) {
            this.slotsByClass.get(screen.method_17577().getClass());
        }
        if (m == null) {
            class_3917 type;
            try {
                type = screen.method_17577().method_17358();
            }
            catch (Exception e) {
                type = null;
            }
            m = this.slotsByMenuId.get(type);
        }
        if (m != null) {
            return (SlotModifier)m.get(slot.field_7874);
        }
        return null;
    }

    @Nullable
    public SlotModifier getSlotModifier(class_1703 menu, class_1735 slot) {
        Int2ObjectArrayMap<SlotModifier> m = this.slotsByClass.get(menu.getClass());
        if (m == null) {
            class_3917 type;
            try {
                type = menu.method_17358();
            }
            catch (Exception e) {
                type = null;
            }
            m = this.slotsByMenuId.get(type);
        }
        if (m != null) {
            return (SlotModifier)m.get(slot.field_7874);
        }
        return null;
    }

    public void maybeModifySlot(class_1703 menu, class_1735 slot) {
        SlotModifier mod = this.getSlotModifier(menu, slot);
        if (mod != null) {
            mod.modify(slot);
        }
    }

    public boolean maybeChangeColor(class_465<?> screen, @NotNull class_1735 slot, class_332 graphics, int x, int y, int offset) {
        SlotModifier mod = this.getSlotModifier(screen, slot);
        if (mod != null && mod.hasCustomColor()) {
            mod.renderCustomHighlight(graphics, x, y, offset);
            return false;
        }
        return true;
    }
}

