/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.google.gson.JsonElement;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.item.AutoGeneratedModel;
import net.mehvahdjukaar.polytone.item.ItemModelOverride;
import net.mehvahdjukaar.polytone.item.ItemModelOverrideList;
import net.mehvahdjukaar.polytone.item.StandaloneItemModelOverride;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.ModelResHelper;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;

public class CustomItemModelsManager
extends JsonPartialReloader {
    private final Map<class_1792, ItemModelOverrideList> itemModels = new Object2ObjectOpenHashMap();
    private final Set<AutoGeneratedModel> autoGeneratedModels = new HashSet<AutoGeneratedModel>();
    private final Map<class_1792, List<ItemModelOverride>> itemModifiersModels = new HashMap<class_1792, List<ItemModelOverride>>();

    public CustomItemModelsManager() {
        super("custom_item_models");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.itemModels.clear();
        this.autoGeneratedModels.clear();
    }

    @Override
    protected void earlyProcess(class_3300 resourceManager) {
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        for (Map.Entry<class_2960, JsonElement> e : jsons.entrySet()) {
            class_2960 id;
            JsonElement json = e.getValue();
            StandaloneItemModelOverride.Partial partial = Parsed.parseOrNull(StandaloneItemModelOverride.CODEC_MODEL_ONLY, json, JsonOps.INSTANCE, id = e.getKey(), "custom item model");
            if (partial == null || partial.autoModel()) continue;
            Polytone.addCustomModel(partial.model());
        }
    }

    @Override
    protected void parseWithLevel(Map<class_2960, JsonElement> jsons, class_6903<JsonElement> ops, class_5455 access) {
        this.itemModels.clear();
        this.autoGeneratedModels.clear();
        for (Map.Entry<class_1792, List<ItemModelOverride>> entry : this.itemModifiersModels.entrySet()) {
            class_1792 target = entry.getKey();
            List<ItemModelOverride> overrides = entry.getValue();
            this.itemModels.computeIfAbsent(target, a -> new ItemModelOverrideList()).addAll(overrides);
        }
        this.itemModifiersModels.clear();
        for (Map.Entry<class_1792, List<ItemModelOverride>> entry : jsons.entrySet()) {
            class_2960 location;
            JsonElement json = (JsonElement)entry.getValue();
            StandaloneItemModelOverride modelOverride = Parsed.parseOrNull(StandaloneItemModelOverride.CODEC, json, ops, location = (class_2960)entry.getKey(), "custom item model");
            if (modelOverride == null) continue;
            if (modelOverride.isAutoModel()) {
                AutoGeneratedModel generated = AutoGeneratedModel.ofCIM(location);
                this.autoGeneratedModels.add(generated);
                modelOverride.setModel(ModelResHelper.of(generated.modelLocation()));
            }
            this.itemModels.computeIfAbsent(modelOverride.getTarget(), a -> new ItemModelOverrideList()).add(modelOverride);
        }
    }

    @Override
    protected void applyWithLevel(class_5455 access, boolean isLogIn) {
        for (ItemModelOverrideList list : this.itemModels.values()) {
            list.populateModels(access);
        }
        int allModels = 0;
        for (ItemModelOverrideList list : this.itemModels.values()) {
            allModels += list.size();
        }
        Polytone.LOGGER.info("Loaded {} Custom Item Models for {} items", (Object)allModels, (Object)this.itemModels.size());
    }

    @Nullable
    public class_1087 getOverride(class_1799 itemStack, @Nullable class_1937 level, @Nullable class_1309 entity, int seed) {
        if (level == null) {
            return null;
        }
        ItemModelOverrideList list = this.itemModels.get(itemStack.method_7909());
        if (list == null) {
            return null;
        }
        return list.getModel(itemStack, level, entity, seed);
    }

    public Map<class_2960, class_793> createAutoGeneratedModels() {
        HashMap<class_2960, class_793> models = new HashMap<class_2960, class_793>();
        for (AutoGeneratedModel model : this.autoGeneratedModels) {
            String texturePath = model.texturePath().toString();
            class_793 unbakedModel = class_793.method_3430((String)String.format("{\n  \"parent\": \"item/generated\",\n  \"textures\": {\n    \"layer0\": \"%s\"\n  }\n}\n", texturePath));
            models.put(model.modelLocation(), unbakedModel);
        }
        return models;
    }

    public void addModelFromModifier(class_1792 item, List<ItemModelOverride> itemModelOverrides) {
        this.itemModifiersModels.computeIfAbsent(item, a -> new ArrayList()).addAll(itemModelOverrides);
    }
}

