/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.Polytone;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7654;
import net.minecraft.class_9848;

public record ArrayImage(int[][] pixels, int width, int height) {
    public ArrayImage(int[][] matrix) {
        this(matrix, matrix[0].length, matrix.length);
    }

    public static Map<class_2960, ArrayImage> scanDirectory(class_3300 manager, String path) {
        HashMap<class_2960, ArrayImage> map = new HashMap<class_2960, ArrayImage>();
        ArrayImage.scanDirectory(manager, path, map);
        return map;
    }

    public static void scanDirectory(class_3300 manager, String path, Map<class_2960, ArrayImage> map) {
        class_7654 helper = new class_7654(path, ".png");
        for (Map.Entry entry : helper.method_45113(manager).entrySet()) {
            class_2960 fileId = (class_2960)entry.getKey();
            class_2960 id = helper.method_45115(fileId);
            try {
                InputStream inputStream = ((class_3298)entry.getValue()).method_14482();
                try {
                    class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
                    try {
                        int[][] pixels = ArrayImage.makePixelMatrix(nativeImage);
                        ArrayImage image = new ArrayImage(pixels, nativeImage.method_4307(), nativeImage.method_4323());
                        ArrayImage oldImage = map.put(id, image);
                        if (oldImage == null) continue;
                        throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(id));
                    }
                    finally {
                        if (nativeImage == null) continue;
                        nativeImage.close();
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException | IllegalArgumentException | UnsupportedOperationException var14) {
                Polytone.LOGGER.error("Couldn't parse texture file {} from {}", (Object)id, (Object)fileId, (Object)var14);
            }
        }
    }

    private static int[][] makePixelMatrix(class_1011 nativeImage) {
        if (nativeImage.method_4318() != class_1011.class_1012.field_4997) {
            throw new UnsupportedOperationException("Can only call makePixelMatrix for RGBA images.");
        }
        int width = nativeImage.method_4307();
        int height = nativeImage.method_4323();
        int[][] pixelMatrix = new int[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int pixel = nativeImage.method_61940(j, i);
                pixelMatrix[i][j] = class_9848.method_61324((int)255, (int)class_9848.method_61327((int)pixel), (int)class_9848.method_61329((int)pixel), (int)class_9848.method_61331((int)pixel));
            }
        }
        return pixelMatrix;
    }

    public static Map<class_2960, Group> groupTextures(Map<class_2960, ArrayImage> texturesColormap) {
        LinkedHashMap<class_2960, Group> groupedMap = new LinkedHashMap<class_2960, Group>();
        Pattern pattern = Pattern.compile("(\\D+)(_\\d+)?");
        for (Map.Entry<class_2960, ArrayImage> e : texturesColormap.entrySet()) {
            class_2960 id = e.getKey();
            String str = id.method_12832();
            Matcher matcher = pattern.matcher(str);
            if (matcher.matches()) {
                String key = matcher.group(1);
                String indexMatch = matcher.group(2);
                int index = -1;
                if (indexMatch != null) {
                    index = Integer.parseInt(indexMatch.substring(1));
                }
                groupedMap.computeIfAbsent(id.method_45136(key), a -> new Group()).put(index, e.getValue());
                continue;
            }
            Group group = new Group();
            group.put(-1, e.getValue());
            groupedMap.put(id, group);
        }
        return groupedMap;
    }

    public static class Group
    extends Int2ObjectArrayMap<ArrayImage> {
        public ArrayImage getDefault() {
            return (ArrayImage)this.get(-1);
        }
    }
}

