/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.particle.CustomParticleFactory;
import net.mehvahdjukaar.polytone.particle.ParticleContextExpression;
import net.mehvahdjukaar.polytone.particle.ParticleInitializer;
import net.mehvahdjukaar.polytone.particle.ParticleParticleEmitter;
import net.mehvahdjukaar.polytone.particle.ParticleTickable;
import net.mehvahdjukaar.polytone.sound.ParticleSoundEmitter;
import net.mehvahdjukaar.polytone.utils.BiggerCodecs;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ModelResHelper;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3940;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5878;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_765;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CustomParticleType
implements CustomParticleFactory {
    private static class_2680 STATE_HACK = class_2246.field_10124.method_9564();
    private final RenderType renderType;
    @Nullable
    private final class_1091 model;
    @Nullable
    private final ParticleInitializer initializer;
    @Nullable
    private final Ticker ticker;
    private final List<ParticleSoundEmitter> sounds;
    protected final List<ParticleParticleEmitter> particles = new ArrayList<ParticleParticleEmitter>();
    @Nullable
    protected List<Dynamic<?>> lazyParticles;
    private final int lightLevel;
    private final LiquidAffinity liquidAffinity;
    private final boolean hasPhysics;
    private final boolean killOnContact;
    private final boolean killWhenStill;
    @Nullable
    private final IColorGetter colormap;
    private final RotationMode rotationMode;
    private final class_243 offset;
    private final Optional<class_5878> group;
    private final boolean forceSpawn;
    private final boolean randomSprite;
    private transient class_4002 spriteSet;
    private boolean isValid = true;
    public static final Codec<CustomParticleType> CODEC = RecordCodecBuilder.create(i -> BiggerCodecs.group(i, RenderType.CODEC.optionalFieldOf("render_type", (Object)RenderType.OPAQUE).forGetter(CustomParticleType::getRenderType), RotationMode.CODEC.optionalFieldOf("rotation_mode", (Object)RotationMode.LOOK_AT_XYZ).forGetter(c -> c.rotationMode), class_2960.field_25139.optionalFieldOf("model").forGetter(c -> Optional.ofNullable(c.model.comp_2875())), class_243.field_38277.optionalFieldOf("offset", (Object)class_243.field_1353).forGetter(c -> c.offset), Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(c -> c.lightLevel), Codec.BOOL.optionalFieldOf("has_physics", (Object)true).forGetter(c -> c.hasPhysics), Codec.BOOL.optionalFieldOf("kill_on_contact", (Object)false).forGetter(c -> c.killOnContact), Codec.BOOL.optionalFieldOf("kill_when_still", (Object)false).forGetter(c -> c.killWhenStill), LiquidAffinity.CODEC.optionalFieldOf("liquid_affinity", (Object)LiquidAffinity.ANY).forGetter(c -> c.liquidAffinity), Colormap.CODEC.optionalFieldOf("colormap").forGetter(c -> Optional.ofNullable(c.colormap)), Codec.BOOL.optionalFieldOf("random_sprite", (Object)false).forGetter(c -> c.randomSprite), class_5699.field_33441.optionalFieldOf("limit", (Object)0).forGetter(c -> c.group.map(class_5878::method_34045).orElse(0)), Codec.BOOL.optionalFieldOf("force_spawn", (Object)false).forGetter(c -> c.forceSpawn), ParticleInitializer.CODEC.optionalFieldOf("initializer").forGetter(c -> Optional.ofNullable(c.initializer)), Ticker.CODEC.optionalFieldOf("ticker").forGetter(c -> Optional.ofNullable(c.ticker)), ParticleSoundEmitter.CODEC.listOf().optionalFieldOf("sound_emitters", List.of()).forGetter(c -> c.sounds), Codec.PASSTHROUGH.listOf().optionalFieldOf("particle_emitters", List.of()).forGetter(c -> c.lazyParticles)).apply(i, CustomParticleType::new));
    public static final Codec<Optional<class_1091>> CUSTOM_MODEL_ONLY_CODEC = RecordCodecBuilder.create(i -> i.group((App)ModelResHelper.MODEL_RES_CODEC.optionalFieldOf("model").forGetter(e -> e)).apply((Applicative)i, r -> r));

    private CustomParticleType(RenderType renderType, RotationMode rotationMode, @Nullable class_2960 model, class_243 offset, int light, boolean hasPhysics, boolean killOnContact, boolean killWhenStill, LiquidAffinity liquidAffinity, @Nullable IColorGetter colormap, boolean randomSprite, int particleGroupLimit, boolean forceSpawn, @Nullable ParticleInitializer initializer, @Nullable Ticker ticker, @Nullable List<ParticleSoundEmitter> sounds, @Nullable List<Dynamic<?>> particles) {
        this.renderType = renderType;
        this.randomSprite = randomSprite;
        this.model = model == null ? null : new class_1091(model, "standalone");
        this.initializer = initializer;
        this.ticker = ticker;
        this.sounds = sounds;
        this.lazyParticles = particles;
        this.lightLevel = light;
        this.hasPhysics = hasPhysics;
        this.killOnContact = killOnContact;
        this.killWhenStill = killWhenStill;
        this.liquidAffinity = liquidAffinity;
        this.forceSpawn = forceSpawn;
        this.colormap = colormap;
        this.offset = offset;
        this.rotationMode = rotationMode;
        this.group = particleGroupLimit > 0 ? Optional.of(new class_5878(particleGroupLimit)) : Optional.empty();
    }

    private CustomParticleType(RenderType renderType, RotationMode rotationMode, Optional<class_2960> model, class_243 offset, int light, boolean hasPhysics, boolean killOnContact, boolean killWhenStill, LiquidAffinity liquidAffinity, Optional<IColorGetter> colormap, boolean randomSprite, int limit, boolean forceSpawn, Optional<ParticleInitializer> initializer, Optional<Ticker> ticker, List<ParticleSoundEmitter> sounds, List<Dynamic<?>> particles) {
        this(renderType, rotationMode, (class_2960)model.orElse(null), offset, light, hasPhysics, killOnContact, killWhenStill, liquidAffinity, (IColorGetter)colormap.orElse(null), randomSprite, limit, forceSpawn, (ParticleInitializer)initializer.orElse(null), (Ticker)ticker.orElse(null), sounds, particles);
    }

    @Override
    public boolean forceSpawns() {
        return this.forceSpawn;
    }

    @Override
    @Nullable
    public class_1091 getCustomModel() {
        return this.model;
    }

    public static void setStateHack(class_2680 state) {
        STATE_HACK = state;
    }

    private RenderType getRenderType() {
        return this.renderType;
    }

    @Override
    public class_703 createParticle(class_2400 type, class_638 world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable class_2680 state) {
        if (this.spriteSet != null) {
            Instance newParticle = new Instance(world, x, y, z, xSpeed, ySpeed, zSpeed, state, this, class_7923.field_41180.method_10221((Object)type));
            if (this.hasPhysics) {
                for (class_265 voxelShape : world.method_20812(null, newParticle.method_3064())) {
                    if (voxelShape.method_1110()) continue;
                    return null;
                }
            }
            if (this.ticker != null && this.ticker.removeIf != null && this.ticker.removeIf.getValue((class_703)newParticle, (class_1937)world) > 0.0) {
                return null;
            }
            return newParticle;
        }
        throw new IllegalStateException("Sprite set not set for custom particle type");
    }

    @Override
    public void setSpriteSet(class_702.class_4090 mutableSpriteSet) {
        this.spriteSet = mutableSpriteSet;
    }

    public void setUnregistered() {
        this.isValid = false;
    }

    public static double getPitch(class_243 vec3) {
        return -Math.toDegrees(Math.asin(vec3.field_1351));
    }

    public static double getYaw(class_243 vec3) {
        return Math.toDegrees(Math.atan2(-vec3.field_1352, vec3.field_1350));
    }

    public static enum RenderType implements class_3542
    {
        TERRAIN,
        OPAQUE,
        TRANSLUCENT,
        LIT,
        INVISIBLE;

        public static final Codec<RenderType> CODEC;

        public class_1921 getBlock() {
            return switch (this.ordinal()) {
                case 0 -> class_1921.method_23577();
                case 2 -> class_1921.method_23583();
                case 3 -> class_1921.method_23581();
                case 4 -> class_1921.method_23581();
                default -> class_1921.method_23579();
            };
        }

        public class_3999 getParticle() {
            return switch (this.ordinal()) {
                case 0 -> class_3999.field_17827;
                case 2 -> class_3999.field_17829;
                case 3 -> class_3999.field_17827;
                case 4 -> class_3999.field_17832;
                default -> class_3999.field_17828;
            };
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(RenderType::values);
        }
    }

    protected record Ticker(@Nullable ParticleContextExpression x, @Nullable ParticleContextExpression y, @Nullable ParticleContextExpression z, @Nullable ParticleContextExpression dx, @Nullable ParticleContextExpression dy, @Nullable ParticleContextExpression dz, @Nullable ParticleContextExpression size, @Nullable ParticleContextExpression red, @Nullable ParticleContextExpression green, @Nullable ParticleContextExpression blue, @Nullable ParticleContextExpression alpha, @Nullable ParticleContextExpression roll, @Nullable ParticleContextExpression custom, @Nullable ParticleContextExpression removeIf) {
        private static final Codec<Ticker> CODEC = RecordCodecBuilder.create(i -> i.group((App)ParticleContextExpression.CODEC.optionalFieldOf("x").forGetter(p -> Optional.ofNullable(p.x)), (App)ParticleContextExpression.CODEC.optionalFieldOf("y").forGetter(p -> Optional.ofNullable(p.y)), (App)ParticleContextExpression.CODEC.optionalFieldOf("z").forGetter(p -> Optional.ofNullable(p.z)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dx").forGetter(p -> Optional.ofNullable(p.dx)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dy").forGetter(p -> Optional.ofNullable(p.dy)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dz").forGetter(p -> Optional.ofNullable(p.dz)), (App)ParticleContextExpression.CODEC.optionalFieldOf("size").forGetter(p -> Optional.ofNullable(p.size)), (App)ParticleContextExpression.CODEC.optionalFieldOf("red").forGetter(p -> Optional.ofNullable(p.red)), (App)ParticleContextExpression.CODEC.optionalFieldOf("green").forGetter(p -> Optional.ofNullable(p.green)), (App)ParticleContextExpression.CODEC.optionalFieldOf("blue").forGetter(p -> Optional.ofNullable(p.blue)), (App)ParticleContextExpression.CODEC.optionalFieldOf("alpha").forGetter(p -> Optional.ofNullable(p.alpha)), (App)ParticleContextExpression.CODEC.optionalFieldOf("roll").forGetter(p -> Optional.ofNullable(p.roll)), (App)ParticleContextExpression.CODEC.optionalFieldOf("custom").forGetter(p -> Optional.ofNullable(p.custom)), (App)ParticleContextExpression.CODEC.optionalFieldOf("remove_condition").forGetter(p -> Optional.ofNullable(p.removeIf))).apply((Applicative)i, Ticker::new));

        private Ticker(Optional<ParticleContextExpression> x, Optional<ParticleContextExpression> y, Optional<ParticleContextExpression> z, Optional<ParticleContextExpression> dx, Optional<ParticleContextExpression> dy, Optional<ParticleContextExpression> dz, Optional<ParticleContextExpression> size, Optional<ParticleContextExpression> red, Optional<ParticleContextExpression> green, Optional<ParticleContextExpression> blue, Optional<ParticleContextExpression> alpha, Optional<ParticleContextExpression> roll, Optional<ParticleContextExpression> custom, Optional<ParticleContextExpression> removeIf) {
            this((ParticleContextExpression)x.orElse(null), (ParticleContextExpression)y.orElse(null), (ParticleContextExpression)z.orElse(null), (ParticleContextExpression)dx.orElse(null), (ParticleContextExpression)dy.orElse(null), (ParticleContextExpression)dz.orElse(null), (ParticleContextExpression)size.orElse(null), (ParticleContextExpression)red.orElse(null), (ParticleContextExpression)green.orElse(null), (ParticleContextExpression)blue.orElse(null), (ParticleContextExpression)alpha.orElse(null), (ParticleContextExpression)roll.orElse(null), (ParticleContextExpression)custom.orElse(null), (ParticleContextExpression)removeIf.orElse(null));
        }

        private void tick(Instance particle, class_638 level) {
            if (this.roll != null) {
                particle.field_3857 = particle.field_3839;
                particle.field_3839 = (float)this.roll.getValue((class_703)particle, (class_1937)level);
            }
            if (this.size != null) {
                particle.oQuadSize = particle.field_17867;
                particle.field_17867 = (float)this.size.getValue((class_703)particle, (class_1937)level);
            }
            if (this.red != null) {
                particle.field_3861 = (float)this.red.getValue((class_703)particle, (class_1937)level);
            }
            if (this.green != null) {
                particle.field_3842 = (float)this.green.getValue((class_703)particle, (class_1937)level);
            }
            if (this.blue != null) {
                particle.field_3859 = (float)this.blue.getValue((class_703)particle, (class_1937)level);
            }
            if (this.alpha != null) {
                particle.field_3841 = (float)this.alpha.getValue((class_703)particle, (class_1937)level);
            }
            if (this.x != null) {
                particle.field_3874 = this.x.getValue((class_703)particle, (class_1937)level);
            }
            if (this.y != null) {
                particle.field_3854 = this.y.getValue((class_703)particle, (class_1937)level);
            }
            if (this.z != null) {
                particle.field_3871 = this.z.getValue((class_703)particle, (class_1937)level);
            }
            if (this.dx != null) {
                particle.field_3852 = this.dx.getValue((class_703)particle, (class_1937)level);
            }
            if (this.dy != null) {
                particle.field_3869 = this.dy.getValue((class_703)particle, (class_1937)level);
            }
            if (this.dz != null) {
                particle.field_3850 = this.dz.getValue((class_703)particle, (class_1937)level);
            }
            if (this.custom != null) {
                particle.custom = this.custom.getValue((class_703)particle, (class_1937)level);
            }
            if (this.removeIf != null && this.removeIf.getValue((class_703)particle, (class_1937)level) > 0.0) {
                particle.method_3085();
            }
        }
    }

    protected static enum LiquidAffinity implements class_3542
    {
        LIQUIDS,
        NON_LIQUIDS,
        ANY;

        private static final Codec<LiquidAffinity> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(LiquidAffinity::values);
        }
    }

    protected static enum RotationMode implements class_3542
    {
        LOOK_AT_XYZ,
        LOOK_AT_Y,
        LOOK_AT_X,
        LOOK_AT_Z,
        LOOK_AT_XZ,
        MOVEMENT_ALIGNED,
        LOOK_UP,
        LOOK_WEST,
        NONE;

        private static final Codec<RotationMode> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public void setRotation(class_3940 particle, Quaternionf quaternionf, class_4184 camera, float partialTicks) {
            switch (this.ordinal()) {
                case 8: {
                    break;
                }
                case 6: {
                    quaternionf.identity();
                    quaternionf.rotateX(1.5707964f);
                    break;
                }
                case 7: {
                    quaternionf.identity();
                    quaternionf.rotateY(1.5707964f);
                    break;
                }
                case 0: {
                    class_3940.class_8981.field_47457.setRotation(quaternionf, camera, partialTicks);
                    break;
                }
                case 1: {
                    class_3940.class_8981.field_47458.setRotation(quaternionf, camera, partialTicks);
                    break;
                }
                case 2: {
                    quaternionf.set(camera.method_23767().x, 0.0f, 0.0f, camera.method_23767().w);
                    break;
                }
                case 3: {
                    quaternionf.set(0.0f, 0.0f, camera.method_23767().z, camera.method_23767().w);
                    break;
                }
                case 4: {
                    quaternionf.set(camera.method_23767().x, 0.0f, camera.method_23767().z, camera.method_23767().w);
                    break;
                }
                case 5: {
                    class_243 dir = new class_243(particle.field_3852, particle.field_3869, particle.field_3850).method_1029();
                    class_243 cameraLook = new class_243(camera.method_19335());
                    class_243 cross = dir.method_1036(cameraLook);
                    double pitch = CustomParticleType.getPitch(dir);
                    double yaw = CustomParticleType.getYaw(dir);
                    Vector3f dirUp = new Vector3f(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)quaternionf);
                    float roll = dirUp.angleSigned((Vector3fc)cross.method_46409(), (Vector3fc)dir.method_46409());
                    quaternionf.rotateY((float)(-0.01745329238474369 * yaw));
                    quaternionf.rotateX((float)(0.01745329238474369 * (pitch - 90.0)));
                    quaternionf.rotateY(-roll - 1.5707964f);
                }
            }
        }

        public boolean hasBackFace() {
            return this != LOOK_AT_XYZ && this != LOOK_AT_Y && this != MOVEMENT_ALIGNED;
        }

        static {
            CODEC = class_3542.method_28140(RotationMode::values);
        }
    }

    public static class Instance
    extends class_4003 {
        protected final CustomParticleType type;
        @Nullable
        protected final class_1087 model;
        protected final class_4002 spriteSet;
        protected final LiquidAffinity liquidAffinity;
        protected final List<ParticleTickable> tickables;
        protected float oQuadSize;
        protected double custom;
        private class_2960 name;

        protected Instance(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable class_2680 state, CustomParticleType customType, class_2960 typeId) {
            super(level, x, y, z, xSpeed, ySpeed, zSpeed);
            this.method_3080(0.1f, 0.1f);
            this.name = typeId;
            this.type = customType;
            this.tickables = new ArrayList<ParticleTickable>();
            this.tickables.addAll(customType.sounds);
            this.tickables.addAll(customType.particles);
            if (state == null) {
                state = STATE_HACK;
            }
            this.field_3874 = x;
            this.field_3854 = y;
            this.field_3871 = z;
            this.field_3852 = xSpeed;
            this.field_3869 = ySpeed;
            this.field_3850 = zSpeed;
            this.model = customType.model == null ? null : PlatStuff.getBakedModel(customType.model);
            ParticleInitializer initializer = customType.initializer;
            class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
            if (initializer != null) {
                initializer.initialize((class_3940)this, level, state, pos);
            }
            this.oQuadSize = this.field_17867;
            this.liquidAffinity = customType.liquidAffinity;
            this.field_3862 = customType.hasPhysics;
            if (this.type.colormap != null) {
                float[] unpack = ColorUtils.unpack(this.type.colormap.getColor(state, (class_1920)level, pos, 0));
                this.method_3084(unpack[0], unpack[1], unpack[2]);
            }
            if (customType.randomSprite) {
                this.spriteSet = null;
                this.method_18140(customType.spriteSet);
            } else {
                this.spriteSet = customType.spriteSet;
                this.method_18142(this.spriteSet);
            }
        }

        public double getCustom() {
            return this.custom;
        }

        public Optional<class_5878> method_34019() {
            return this.type.group;
        }

        public void method_3074(class_4588 buffer, class_4184 camera, float partialTicks) {
            Quaternionf quaternionf = new Quaternionf();
            this.type.rotationMode.setRotation((class_3940)this, quaternionf, camera, partialTicks);
            if (this.field_3839 != 0.0f) {
                quaternionf.rotateZ(class_3532.method_16439((float)partialTicks, (float)this.field_3857, (float)this.field_3839));
            }
            this.method_60373(buffer, camera, quaternionf, partialTicks);
            if (this.type.rotationMode.hasBackFace() && this.model == null) {
                quaternionf.rotateX((float)Math.PI);
                this.method_60373(buffer, camera, quaternionf, partialTicks);
            }
        }

        protected void method_60374(class_4588 consumer, Quaternionf quaternion, float x, float y, float z, float partialTicks) {
            class_243 offset = this.type.offset;
            if (this.model == null) {
                super.method_60374(consumer, quaternion, (float)((double)x + offset.field_1352), (float)((double)y + offset.field_1351), (float)((double)z + offset.field_1350), partialTicks);
            } else {
                float size = this.method_18132(partialTicks);
                class_4587 poseStack = new class_4587();
                poseStack.method_22904((double)x + offset.field_1352, (double)y + offset.field_1351, (double)z + offset.field_1350);
                poseStack.method_22905(size, size, size);
                poseStack.method_22907(quaternion);
                poseStack.method_22904(-0.5, -0.5, -0.5);
                class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
                consumer = bufferSource.getBuffer(this.type.renderType.getBlock());
                Instance.putModelBulkData(this.model, this.method_3068(partialTicks), class_4608.field_21444, poseStack, consumer, this.field_3861, this.field_3842, this.field_3859, this.field_3841);
                bufferSource.method_22993();
            }
        }

        protected int method_3068(float partialTick) {
            int total = super.method_3068(partialTick);
            if (this.type.lightLevel > 0) {
                int sky = class_765.method_24187((int)total);
                int block = class_765.method_24186((int)total);
                block = Math.max(block, this.type.lightLevel);
                return class_765.method_23687((int)block, (int)sky);
            }
            return total;
        }

        public void method_3085() {
            super.method_3085();
            this.field_3866 = this.field_3847;
        }

        public void method_3070() {
            class_2680 state;
            if (!this.type.isValid) {
                this.method_3085();
                return;
            }
            if (this.spriteSet != null) {
                this.method_18142(this.spriteSet);
            }
            super.method_3070();
            if (this.type.ticker != null) {
                this.type.ticker.tick(this, this.field_3851);
            }
            if (this.type.colormap != null) {
                class_2338 pos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
                float[] unpack = ColorUtils.unpack(this.type.colormap.getColor(null, (class_1920)this.field_3851, pos, 0));
                this.method_3084(unpack[0], unpack[1], unpack[2]);
            }
            if (this.field_3866 > 1 && this.type.killWhenStill && this.field_3874 == this.field_3858 && this.field_3854 == this.field_3838 && this.field_3871 == this.field_3856) {
                this.method_3085();
            }
            if (this.field_3862 && this.field_21507) {
                this.method_3085();
            }
            if (this.liquidAffinity != LiquidAffinity.ANY && this.liquidAffinity == LiquidAffinity.LIQUIDS ^ !(state = this.field_3851.method_8320(class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871))).method_26227().method_15769()) {
                this.method_3085();
            }
            if (!this.field_3843) {
                for (ParticleTickable tickable : this.tickables) {
                    tickable.tick((class_703)this, (class_1937)this.field_3851);
                }
            }
        }

        public void method_3069(double x, double y, double z) {
            class_243 wantedPos;
            class_243 myPos;
            super.method_3069(x, y, z);
            if (this.type.killOnContact && this.field_3866 > 1 && (myPos = new class_243(this.field_3874, this.field_3854, this.field_3871)).method_1025(wantedPos = new class_243(this.field_3858 + x, this.field_3838 + y, this.field_3856 + z)) > 1.0E-6) {
                this.method_3085();
                this.field_3852 = 0.0;
                this.field_3869 = 0.0;
                this.field_3850 = 0.0;
            }
        }

        public static void putModelBulkData(class_1087 model, int combinedLight, int combinedOverlay, class_4587 poseStack, class_4588 buffer, float r, float g, float b, float a) {
            class_5819 randomSource = class_5819.method_43047();
            for (class_2350 direction : class_2350.values()) {
                randomSource.method_43052(42L);
                for (class_777 bakedQuad : model.method_4707(null, direction, randomSource)) {
                    buffer.method_22919(poseStack.method_23760(), bakedQuad, r, g, b, a, combinedLight, combinedOverlay);
                }
            }
            randomSource.method_43052(42L);
            for (class_777 bakedQuad : model.method_4707(null, null, randomSource)) {
                buffer.method_22919(poseStack.method_23760(), bakedQuad, r, g, b, a, combinedLight, combinedOverlay);
            }
        }

        public float method_18132(float scaleFactor) {
            return class_3532.method_16439((float)scaleFactor, (float)this.oQuadSize, (float)this.field_17867);
        }

        public class_3999 method_18122() {
            return this.model == null ? this.type.renderType.getParticle() : class_3999.field_17831;
        }
    }
}

