/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.ColormapsManager;
import net.mehvahdjukaar.polytone.item.IPolytoneItem;
import net.mehvahdjukaar.polytone.item.ItemModelOverride;
import net.mehvahdjukaar.polytone.item.ItemModifier;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.JsonImgPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class ItemModifiersManager
extends JsonImgPartialReloader {
    private final Map<class_1792, ItemModifier> modifiers = new HashMap<class_1792, ItemModifier>();
    private final Map<class_1792, ItemModifier> vanillaProperties = new HashMap<class_1792, ItemModifier>();

    public ItemModifiersManager() {
        super("item_modifiers", "item_properties");
    }

    @Override
    public void earlyProcess(class_3300 resourceManager) {
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        for (Map.Entry<class_2960, JsonElement> e : jsons.entrySet()) {
            JsonElement json = e.getValue();
            class_2960 id = e.getKey();
            ItemModifier.Partial partial = (ItemModifier.Partial)((Pair)ItemModifier.CODEC_ONLY_MODELS.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Item Modifier with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
            for (ItemModelOverride.Partial m : partial.customModels()) {
                Polytone.addCustomModel(m.model());
            }
        }
    }

    @Override
    protected void parseWithLevel(JsonImgPartialReloader.Resources resources, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        Object modifier;
        Map<class_2960, JsonElement> jsons = resources.jsons();
        HashMap<class_2960, ArrayImage> textures = new HashMap<class_2960, ArrayImage>(resources.textures());
        HashSet<class_2960> usedTextures = new HashSet<class_2960>();
        Map parsedModifiers = Utils.sortedMap();
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            JsonElement json = entry.getValue();
            class_2960 location = entry.getKey();
            modifier = Parsed.parseAlways(ItemModifier.CODEC, json, ops, location, "item modifier");
            parsedModifiers.put(location, modifier);
        }
        for (Map.Entry<class_2960, Object> entry : parsedModifiers.entrySet()) {
            class_2960 tintId = entry.getKey();
            Parsed result = (Parsed)entry.getValue();
            modifier = (ItemModifier)result.getResultOrPartial();
            class_2960 barId = tintId.method_48331("_bar");
            if (!((ItemModifier)modifier).hasBarColor() && textures.containsKey(barId)) {
                modifier = ((ItemModifier)modifier).merge(ItemModifier.ofBarColor(Colormap.createDamage()));
            }
            ColormapsManager.tryAcceptingTexture(textures, barId, ((ItemModifier)modifier).getBarColor(), usedTextures, true);
            if (!result.isEnabled()) continue;
            this.addModifier(tintId, (ItemModifier)modifier);
        }
        textures.keySet().removeAll(usedTextures);
        for (Map.Entry<class_2960, Object> entry : textures.entrySet()) {
            class_2960 id = entry.getKey();
            Colormap defaultColormap = Colormap.createDamage();
            ColormapsManager.tryAcceptingTexture(textures, id, (Object)defaultColormap, usedTextures, true);
            this.addModifier(id, ItemModifier.ofBarColor(defaultColormap));
        }
    }

    private void addModifier(class_2960 id, ItemModifier mod) {
        for (class_6880 item : mod.targets().compute(id, class_7923.field_41178)) {
            class_1792 i = (class_1792)item.comp_349();
            this.modifiers.merge(i, mod, ItemModifier::merge);
            Polytone.ITEM_MODELS.addModelFromModifier(i, mod.customModels());
        }
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        for (Map.Entry<class_1792, ItemModifier> e : this.vanillaProperties.entrySet()) {
            e.getValue().apply(e.getKey());
            ((IPolytoneItem)e.getKey()).polytone$setModifier(null);
        }
        this.modifiers.clear();
    }

    @Override
    protected void applyWithLevel(class_7225.class_7874 access, boolean isLogIn) {
        for (Map.Entry<class_1792, ItemModifier> e : this.modifiers.entrySet()) {
            class_1792 target = e.getKey();
            ItemModifier modifier = e.getValue();
            this.vanillaProperties.put(target, modifier.apply(target));
            if (!modifier.shouldAttachToItem()) continue;
            ((IPolytoneItem)e.getKey()).polytone$setModifier(modifier);
        }
        if (!this.vanillaProperties.isEmpty()) {
            Polytone.LOGGER.info("Applied {} Custom Item Properties", (Object)this.vanillaProperties.size());
        }
        this.modifiers.clear();
    }
}

