/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_322;
import org.jetbrains.annotations.Nullable;

public class IndexCompoundColorGetter
implements IColorGetter {
    final Int2ObjectMap<IColorGetter> getters = new Int2ObjectArrayMap();
    protected static final Codec<IndexCompoundColorGetter> DIRECT_CODEC = Codec.unboundedMap((Codec)Codec.STRING.flatXmap(s -> {
        try {
            int i = Integer.parseInt(s);
            return DataResult.success((Object)i);
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Not a valid integer: " + s);
        }
    }, i -> DataResult.success((Object)String.valueOf(i))), Colormap.CODEC).xmap(IndexCompoundColorGetter::new, comp -> comp.getters).validate(c -> {
        if (c.getters.isEmpty()) {
            return DataResult.error(() -> "Must have at least 1 tint getter");
        }
        return DataResult.success((Object)c);
    });
    public static final Codec<IColorGetter> SINGLE_OR_MULTIPLE = Codec.withAlternative(Colormap.CODEC, DIRECT_CODEC, iColorGetter -> iColorGetter);

    private IndexCompoundColorGetter(Map<Integer, IColorGetter> map) {
        this.getters.putAll(map);
    }

    private IndexCompoundColorGetter() {
    }

    public static IndexCompoundColorGetter createDefault(Set<Integer> tintIndexes, boolean triangular) {
        IndexCompoundColorGetter c = new IndexCompoundColorGetter();
        for (Integer i : tintIndexes) {
            c.getters.put(i.intValue(), (Object)(triangular ? Colormap.createDefTriangle() : Colormap.createDefSquare()));
        }
        return c;
    }

    public Int2ObjectMap<IColorGetter> getGetters() {
        return this.getters;
    }

    public int getColor(@Nullable class_2680 blockState, @Nullable class_1920 level, @Nullable class_2338 blockPos, int tintIndex) {
        class_322 getter = (class_322)this.getters.get(tintIndex);
        if (getter == null) {
            getter = (class_322)this.getters.get(-1);
        }
        if (getter != null) {
            return getter.getColor(blockState, level, blockPos, tintIndex);
        }
        return -1;
    }

    @Override
    public int getItemColor(class_1799 itemStack, int i) {
        return -1;
    }
}

