/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.color;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockContextExpression;
import net.mehvahdjukaar.polytone.color.MapColorHelper;
import net.mehvahdjukaar.polytone.mixins.accessor.DustParticleOptionAccessor;
import net.mehvahdjukaar.polytone.mixins.accessor.SheepAccessor;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.SingleJsonOrPropertiesReloadListener;
import net.minecraft.class_10022;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2390;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2789;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3620;
import net.minecraft.class_5251;
import net.minecraft.class_638;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class ColorManager
extends SingleJsonOrPropertiesReloadListener {
    private static final int DEFAULT_COLOR = class_9848.method_61318((float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f);
    private final Object2IntMap<class_3620> vanillaMapColors = new Object2IntOpenHashMap();
    private final Map<class_1767, Integer> vanillaFireworkColors = new EnumMap<class_1767, Integer>(class_1767.class);
    private final Map<class_1767, Integer> vanillaDiffuseColors = new EnumMap<class_1767, Integer>(class_1767.class);
    private final Map<class_1767, Integer> vanillaTextColors = new EnumMap<class_1767, Integer>(class_1767.class);
    private final Map<class_124, Integer> vanillaChatFormatting = new EnumMap<class_124, Integer>(class_124.class);
    private final Object2IntMap<class_1291> vanillaEffectColors = new Object2IntOpenHashMap();
    private final EnumMap<class_2789, Integer> vanillaBorderStatus = new EnumMap(class_2789.class);
    private final Map<class_1767, Integer> customSheepColors = new EnumMap<class_1767, Integer>(class_1767.class);
    protected final int[] originalRedstoneWireColors = Arrays.copyOf(class_2457.field_24466, class_2457.field_24466.length);
    @Nullable
    private BlockContextExpression xpOrbColor;
    @Nullable
    private BlockContextExpression xpOrbColorR;
    @Nullable
    private BlockContextExpression xpOrbColorG;
    @Nullable
    private BlockContextExpression xpOrbColorB;
    private int xpBar = 8453920;
    private Integer splash = null;

    public ColorManager() {
        super("color.properties", "colors.json", new String[]{"polytone", "colormatic", "vanadium", "optifine"});
    }

    public int getXpBar() {
        return this.xpBar;
    }

    public Integer getSplash() {
        return this.splash;
    }

    @Override
    protected void parseWithLevel(Map<class_2960, Properties> properties, class_6903<JsonElement> ops, class_7225.class_7874 access) {
        ArrayList<class_2960> keySet = new ArrayList<class_2960>(properties.keySet());
        Lists.reverse(keySet);
        for (class_2960 k : keySet) {
            Properties p = properties.get(k);
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                Object object = e.getKey();
                if (!(object instanceof String)) continue;
                String key = (String)object;
                String[] split = key.split("\\.");
                try {
                    this.parseColor(split, e.getValue(), k);
                }
                catch (Exception e1) {
                    Polytone.LOGGER.error("Failed to parse color property {} in file {}", (Object)key, (Object)k);
                }
            }
        }
        this.regenSheepColors();
    }

    private void parseColor(String[] prop, Object obj, class_2960 colorPropFileId) {
        if (!(obj instanceof String)) {
            return;
        }
        String str = (String)obj;
        if (this.is(prop, 0, "map")) {
            String name = this.get(prop, 1);
            class_3620 color = MapColorHelper.byName(name);
            if (color != null) {
                int col = ColorManager.parseHex(obj);
                if (!this.vanillaMapColors.containsKey((Object)color)) {
                    this.vanillaMapColors.put((Object)color, color.field_16011);
                }
                color.field_16011 = col;
            } else {
                Polytone.LOGGER.warn("Unknown MapColor with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "dye")) {
            String name = this.get(prop, 1);
            class_1767 color = class_1767.method_7793((String)name, null);
            if (color != null) {
                String param = this.get(prop, 2);
                int col = ColorManager.parseHex(obj);
                if (param == null || param.equals("diffuse")) {
                    if (!this.vanillaDiffuseColors.containsKey(color)) {
                        this.vanillaDiffuseColors.put(color, color.method_7787());
                    }
                    color.field_7943 = class_9848.method_61334((int)col);
                } else if (param.equals("firework")) {
                    if (!this.vanillaFireworkColors.containsKey(color)) {
                        this.vanillaFireworkColors.put(color, color.field_7960);
                    }
                    color.field_7960 = col;
                } else if (param.equals("text")) {
                    if (!this.vanillaTextColors.containsKey(color)) {
                        this.vanillaTextColors.put(color, color.field_16537);
                    }
                    color.field_16537 = col;
                }
            } else {
                Polytone.LOGGER.warn("Unknown DyeColor with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "particle") && prop.length > 1) {
            String s = prop[1];
            class_2960 id = class_2960.method_60654((String)s.replace("\\", ""));
            try {
                int hex = ColorManager.parseHex(str);
                Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, String.valueOf(hex));
            }
            catch (Exception e) {
                Polytone.PARTICLE_MODIFIERS.addCustomParticleColor(id, str);
            }
        } else if (this.is(prop, 0, "world_border") && prop.length > 1) {
            String name = this.get(prop, 1);
            try {
                class_2789 status = class_2789.valueOf((String)name.toLowerCase(Locale.ROOT));
                int col = ColorManager.parseHex(obj);
                if (!this.vanillaBorderStatus.containsKey(status)) {
                    this.vanillaBorderStatus.put(status, status.method_11999());
                }
                status.field_12755 = col;
            }
            catch (Exception ignored) {
                Polytone.LOGGER.warn("Unknown BorderStatus with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "potion") || this.is(prop, 0, "effect")) {
            class_2960 id = class_2960.method_60654((String)prop[1].replace("\\", ""));
            int col = ColorManager.parseHex(obj);
            if (!id.method_12832().equals("empty")) {
                if (id.method_12832().equals("water")) {
                    class_1844.field_49277 = col;
                } else {
                    class_1291 effect = class_7923.field_41174.method_17966(id).orElse(null);
                    if (effect != null) {
                        if (!this.vanillaEffectColors.containsKey((Object)effect)) {
                            this.vanillaEffectColors.put((Object)effect, effect.method_5556());
                        }
                        effect.field_5886 = col;
                    } else {
                        Polytone.LOGGER.warn("Unknown Mob Effect with name {}", (Object)id);
                    }
                }
            }
        } else if (this.is(prop, 0, "sheep")) {
            String name = this.get(prop, 1);
            class_1767 color = class_1767.method_7793((String)name, null);
            if (color != null) {
                int col = class_9848.method_61334((int)ColorManager.parseHex(obj));
                this.customSheepColors.put(color, col);
            } else {
                Polytone.LOGGER.warn("Unknown Dye Color with name {}", (Object)name);
            }
        } else if (this.is(prop, 0, "xporb")) {
            if (this.is(prop, 1, "color")) {
                this.xpOrbColor = new BlockContextExpression(str);
            } else if (this.is(prop, 1, "red")) {
                this.xpOrbColorR = new BlockContextExpression(str);
            } else if (this.is(prop, 1, "green")) {
                this.xpOrbColorG = new BlockContextExpression(str);
            } else if (this.is(prop, 1, "blue")) {
                this.xpOrbColorB = new BlockContextExpression(str);
            }
        } else if (this.is(prop, 0, "redstone")) {
            String ind = this.get(prop, 1);
            if (ind != null) {
                int code = Integer.parseInt(ind);
                if (code < class_2457.field_24466.length) {
                    int col = ColorManager.parseHex(obj);
                    float[] rgb = ColorUtils.unpack(col);
                    class_2457.field_24466[code] = class_9848.method_61318((float)1.0f, (float)rgb[0], (float)rgb[1], (float)rgb[2]);
                    if (code == 15) {
                        int maxPower;
                        class_2390.field_28272 = maxPower = class_9848.method_61318((float)1.0f, (float)rgb[0], (float)rgb[1], (float)rgb[2]);
                        ((DustParticleOptionAccessor)class_2390.field_11188).setColor(maxPower);
                    }
                } else {
                    Polytone.LOGGER.warn("Redstone color index must be between 0 and 15");
                }
            }
        } else if (this.is(prop, 0, "text")) {
            int col = ColorManager.parseHex(obj);
            class_124 text = null;
            if (this.is(prop, 1, "splash")) {
                this.splash = col;
            } else if (this.is(prop, 1, "xpbar")) {
                this.xpBar = col;
            } else if (this.is(prop, 1, "code")) {
                s = this.get(prop, 2);
                if (s != null) {
                    int code = Integer.parseInt(s);
                    text = class_124.method_534((int)code);
                }
            } else {
                s = this.get(prop, 1);
                text = class_124.method_533((String)s);
            }
            if (text != null) {
                if (!this.vanillaChatFormatting.containsKey(text)) {
                    this.vanillaChatFormatting.put(text, text.method_532());
                }
                text.field_1053 = col;
                class_5251 tc = class_5251.method_27718(text);
                tc.field_24364 = col;
            }
        } else if (this.is(prop, 0, "palette") && this.is(prop, 1, "block") && prop.length > 2 && obj instanceof String) {
            String path = prop[2].replace("~/colormap/", colorPropFileId.method_12836() + ":");
            Polytone.BLOCK_MODIFIERS.addSimpleColormap(class_2960.method_60654((String)path), str);
        }
    }

    private boolean is(String[] array, int index, String value) {
        if (array.length <= index) {
            return false;
        }
        return array[index].equals(value);
    }

    @Nullable
    private String get(String[] array, int index) {
        if (array.length <= index) {
            return null;
        }
        return array[index];
    }

    @Nullable
    private <T> T get(String[] array, int index, Function<String, T> fun) {
        if (array.length <= index) {
            return null;
        }
        return fun.apply(array[index]);
    }

    private static int parseHex(Object obj) {
        if (obj instanceof String) {
            String value = (String)obj;
            value = value.replace("#", "").replace("0x", "");
            return Integer.parseInt(value.trim(), 16);
        }
        throw new JsonParseException("Failed to parse object " + String.valueOf(obj) + ". Expected a String");
    }

    @Override
    protected void applyWithLevel(class_7225.class_7874 access, boolean isLogIn) {
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        class_3620 color;
        class_1844.field_49277 = 3694022;
        this.xpBar = 8453920;
        this.xpOrbColor = null;
        this.xpOrbColorR = null;
        this.xpOrbColorG = null;
        this.xpOrbColorB = null;
        for (Map.Entry entry : this.vanillaMapColors.entrySet()) {
            color = (class_3620)entry.getKey();
            color.field_16011 = (Integer)entry.getValue();
        }
        this.vanillaMapColors.clear();
        for (Map.Entry entry : this.vanillaDiffuseColors.entrySet()) {
            color = (class_1767)entry.getKey();
            color.field_7943 = (Integer)entry.getValue();
        }
        this.vanillaDiffuseColors.clear();
        for (Map.Entry entry : this.vanillaFireworkColors.entrySet()) {
            color = (class_1767)entry.getKey();
            color.field_7960 = (Integer)entry.getValue();
        }
        this.vanillaFireworkColors.clear();
        for (Map.Entry entry : this.vanillaTextColors.entrySet()) {
            color = (class_1767)entry.getKey();
            color.field_16537 = (Integer)entry.getValue();
        }
        this.vanillaTextColors.clear();
        for (Map.Entry entry : this.vanillaChatFormatting.entrySet()) {
            class_124 text = (class_124)entry.getKey();
            text.field_1053 = (Integer)entry.getValue();
            class_5251 tc = class_5251.method_27718((class_124)text);
            tc.field_24364 = (Integer)entry.getValue();
        }
        class_2457.field_24466 = Arrays.copyOf(this.originalRedstoneWireColors, this.originalRedstoneWireColors.length);
        class_2390.field_28272 = DEFAULT_COLOR;
        ((DustParticleOptionAccessor)class_2390.field_11188).setColor(class_2390.field_28272);
    }

    public void regenSheepColors() {
        class_1472.field_6867 = new EnumMap(class_1767.class);
        for (class_1767 d : class_1767.values()) {
            class_1472.field_6867.put(d, SheepAccessor.invokeCreateSheepColor(d));
        }
        class_1472.field_6867.putAll(this.customSheepColors);
        this.customSheepColors.clear();
    }

    public float @Nullable [] getXpOrbColor(class_10022 orb, float partialTicks) {
        class_243 orbPos = new class_243(orb.field_53325, orb.field_53326, orb.field_53327);
        class_638 level = class_310.method_1551().field_1687;
        if (this.xpOrbColor != null) {
            int color = (int)this.xpOrbColor.getValue(orbPos, orb.field_53328 + partialTicks, (class_1937)level);
            return ColorUtils.unpack(color);
        }
        if (this.xpOrbColorR == null && this.xpOrbColorG == null && this.xpOrbColorB == null) {
            return null;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        if (this.xpOrbColorR != null) {
            r = (float)this.xpOrbColorR.getValue(orbPos, orb.field_53328 + partialTicks, (class_1937)level);
        }
        if (this.xpOrbColorG != null) {
            g = (float)this.xpOrbColorG.getValue(orbPos, orb.field_53328 + partialTicks, (class_1937)level);
        }
        if (this.xpOrbColorB != null) {
            b = (float)this.xpOrbColorB.getValue(orbPos, orb.field_53328 + partialTicks, (class_1937)level);
        }
        return new float[]{r, g, b};
    }
}

