/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.Utils;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.StringUtils;

public abstract class PartialReloader<T> {
    public static final Gson GSON = new Gson();
    protected String[] names;

    protected PartialReloader(String ... name) {
        this.names = name;
    }

    public String toString() {
        return StringUtils.capitalize((String)(this.names[0].replace("_", " ") + " Reloader"));
    }

    protected Map<ResourceLocation, JsonElement> getJsonsInDirectories(ResourceManager resourceManager) {
        Map<ResourceLocation, JsonElement> jsons = Utils.sortedMap();
        for (String name : this.names) {
            HashMap<ResourceLocation, JsonElement> js = new HashMap<ResourceLocation, JsonElement>();
            PartialReloader.scanDirectory(resourceManager, "polytone/" + name, GSON, js);
            PartialReloader.greedyAddAll(js, jsons);
        }
        return jsons;
    }

    public static void scanDirectory(ResourceManager resourceManager, String string, Gson gson, Map<ResourceLocation, JsonElement> map) {
        FileToIdConverter fileToIdConverter = FileToIdConverter.json((String)string);
        for (Map.Entry entry : fileToIdConverter.listMatchingResources(resourceManager).entrySet()) {
            ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
            ResourceLocation resourceLocation2 = fileToIdConverter.fileToId(resourceLocation);
            try (BufferedReader reader = ((Resource)entry.getValue()).openAsReader();){
                JsonElement jsonElement = (JsonElement)GsonHelper.fromJson((Gson)gson, (Reader)reader, JsonElement.class);
                JsonElement jsonElement2 = map.put(resourceLocation2, jsonElement);
                if (jsonElement2 == null) continue;
                throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(resourceLocation2));
            }
            catch (JsonParseException | IOException | IllegalArgumentException var14) {
                Polytone.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourceLocation2, (Object)resourceLocation, (Object)var14);
            }
        }
    }

    private static <T> void greedyAddAll(Map<ResourceLocation, T> js, Map<ResourceLocation, T> jsons) {
        for (Map.Entry<ResourceLocation, T> entry : js.entrySet()) {
            ResourceLocation r = entry.getKey();
            T j = entry.getValue();
            jsons.put(r, j);
        }
    }

    protected Map<ResourceLocation, ArrayImage> getImagesInDirectories(ResourceManager resourceManager) {
        HashMap<ResourceLocation, ArrayImage> images = new HashMap<ResourceLocation, ArrayImage>();
        for (String name : this.names) {
            HashMap<ResourceLocation, ArrayImage> im = new HashMap<ResourceLocation, ArrayImage>();
            ArrayImage.scanDirectory(resourceManager, "polytone/" + name, im);
            PartialReloader.greedyAddAll(im, images);
        }
        return images;
    }

    protected Map<ResourceLocation, ArrayImage.Group> getGroupedImagesInDirectories(ResourceManager manager) {
        return ArrayImage.groupTextures(this.getImagesInDirectories(manager));
    }

    protected void earlyProcess(ResourceManager resourceManager) {
    }

    protected abstract T prepare(ResourceManager var1);

    protected abstract void parseWithLevel(T var1, RegistryOps<JsonElement> var2, HolderLookup.Provider var3);

    protected abstract void applyWithLevel(HolderLookup.Provider var1, boolean var2);

    protected abstract void resetWithLevel(boolean var1);
}

