/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.sound;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.polytone.particle.ParticleContextExpression;
import net.mehvahdjukaar.polytone.particle.ParticleTickable;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;

public record ParticleSoundEmitter(SoundEvent sound, SoundSource category, ParticleContextExpression chance, ParticleContextExpression x, ParticleContextExpression y, ParticleContextExpression z, ParticleContextExpression volume, ParticleContextExpression pitch, boolean distanceDelay, Optional<HolderSet<Biome>> biomes) implements ParticleTickable
{
    private static final Codec<SoundSource> SOUND_SOURCE_CODEC = Codec.STRING.comapFlatMap(s -> DataResult.success((Object)SoundSource.valueOf((String)s.toLowerCase(Locale.ROOT))), s -> s.getName().toLowerCase(Locale.ROOT));
    public static final Codec<ParticleSoundEmitter> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("sound").forGetter(ParticleSoundEmitter::sound), (App)SOUND_SOURCE_CODEC.optionalFieldOf("source", (Object)SoundSource.BLOCKS).forGetter(ParticleSoundEmitter::category), (App)ParticleContextExpression.CODEC.optionalFieldOf("chance", (Object)ParticleContextExpression.ONE).forGetter(ParticleSoundEmitter::chance), (App)ParticleContextExpression.CODEC.optionalFieldOf("x", (Object)ParticleContextExpression.ZERO).forGetter(ParticleSoundEmitter::x), (App)ParticleContextExpression.CODEC.optionalFieldOf("y", (Object)ParticleContextExpression.ZERO).forGetter(ParticleSoundEmitter::y), (App)ParticleContextExpression.CODEC.optionalFieldOf("z", (Object)ParticleContextExpression.ZERO).forGetter(ParticleSoundEmitter::z), (App)ParticleContextExpression.CODEC.optionalFieldOf("volume", (Object)ParticleContextExpression.ZERO).forGetter(ParticleSoundEmitter::volume), (App)ParticleContextExpression.CODEC.optionalFieldOf("pitch", (Object)ParticleContextExpression.ZERO).forGetter(ParticleSoundEmitter::pitch), (App)Codec.BOOL.optionalFieldOf("distance_delay", (Object)false).forGetter(ParticleSoundEmitter::distanceDelay), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).optionalFieldOf("biomes").forGetter(ParticleSoundEmitter::biomes)).apply((Applicative)i, ParticleSoundEmitter::new));

    @Override
    public void tick(Particle particle, Level level) {
        double spawnChance = this.chance.getValue(particle, level);
        if ((double)level.random.nextFloat() < spawnChance) {
            if (this.biomes.isPresent()) {
                Holder biome = level.getBiome(BlockPos.containing((double)particle.x, (double)particle.y, (double)particle.z));
                if (!this.biomes.get().contains(biome)) {
                    return;
                }
            }
            Vec3 vec = new Vec3(particle.x, particle.y, particle.z).add(this.x.getValue(particle, level), this.y.getValue(particle, level), this.z.getValue(particle, level));
            float v = (float)this.volume.getValue(particle, level);
            float p = (float)this.pitch.getValue(particle, level);
            level.playLocalSound(vec.x, vec.y, vec.z, this.sound, this.category, v, p, false);
        }
    }
}

