/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.slotify.TargetSlots;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.inventory.Slot;

public record SlotModifier(TargetSlots targets, int color, int color2, int xOffset, int yOffset, int zOffset, Optional<Integer> targetX, Optional<Integer> targetY, Optional<String> targetClass) {
    public static final Codec<SlotModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)TargetSlots.CODEC.fieldOf("slots").forGetter(SlotModifier::targets), (App)ColorUtils.CODEC.optionalFieldOf("color", (Object)-1).forGetter(SlotModifier::color), (App)ColorUtils.CODEC.optionalFieldOf("color_2", (Object)-1).forGetter(SlotModifier::color2), (App)Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(SlotModifier::xOffset), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(SlotModifier::yOffset), (App)Codec.INT.optionalFieldOf("z_offset", (Object)0).forGetter(SlotModifier::zOffset), (App)Codec.INT.optionalFieldOf("target_x").forGetter(SlotModifier::targetX), (App)Codec.INT.optionalFieldOf("target_y").forGetter(SlotModifier::targetY), (App)Codec.STRING.xmap(PlatStuff::maybeRemapName, PlatStuff::maybeRemapName).optionalFieldOf("target_class_name").forGetter(SlotModifier::targetClass)).apply((Applicative)i, SlotModifier::new));

    public void modify(Slot slot) {
        if (this.targetX.isPresent() && slot.x != this.targetX.get()) {
            return;
        }
        if (this.targetY.isPresent() && slot.y != this.targetY.get()) {
            return;
        }
        if (this.targetClass.isPresent()) {
            String name = this.targetClass.get();
            if (!slot.getClass().getSimpleName().equals(name) && !slot.getClass().getName().equals(name)) {
                return;
            }
        }
        slot.x += this.xOffset;
        slot.y += this.yOffset;
    }

    public boolean hasCustomColor() {
        return this.color != -1 || this.color2 != -1 || this.zOffset != 0;
    }

    public void renderCustomHighlight(GuiGraphics graphics, int x, int y, int offset) {
        int c1 = this.color;
        int c2 = this.color2 == -1 ? this.color : this.color2;
        SlotModifier.renderSlotHighlight(graphics, x, y, c1, c2, offset + this.zOffset);
    }

    public static void renderSlotHighlight(GuiGraphics graphics, int x, int y, int slotColor, int slotColor2, int offset) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        graphics.fillGradient(x, y, x + 16, y + 16, slotColor, slotColor2, offset);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public boolean hasOffset() {
        return this.xOffset != 0 || this.yOffset != 0;
    }

    public SlotModifier merge(SlotModifier newMod) {
        HashSet combinedSlots = new HashSet();
        this.targets.getSlots().forEach(combinedSlots::add);
        newMod.targets.getSlots().forEach(combinedSlots::add);
        return new SlotModifier(new TargetSlots.ListTarget(new ArrayList<Integer>(combinedSlots)), newMod.hasCustomColor() ? newMod.color : this.color, newMod.hasCustomColor() ? newMod.color2 : this.color, newMod.hasOffset() ? newMod.xOffset : this.xOffset, newMod.hasOffset() ? newMod.yOffset : this.yOffset, newMod.zOffset, newMod.targetX, newMod.targetY, newMod.targetClass);
    }
}

