/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.slotify.GuiModifier;
import net.mehvahdjukaar.polytone.slotify.ScreenModifier;
import net.mehvahdjukaar.polytone.slotify.SlotModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.mehvahdjukaar.polytone.utils.Parsed;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiModifierManager
extends JsonPartialReloader {
    private final Map<MenuType<?>, Int2ObjectArrayMap<SlotModifier>> slotsByMenuId = new IdentityHashMap();
    private final Map<Class<?>, Int2ObjectArrayMap<SlotModifier>> slotsByClass = new IdentityHashMap();
    private final Map<String, Int2ObjectArrayMap<SlotModifier>> slotsByTitle = new HashMap<String, Int2ObjectArrayMap<SlotModifier>>();
    public final Map<MenuType<?>, ScreenModifier> byMenuId = new IdentityHashMap();
    public final Map<Class<?>, ScreenModifier> byClass = new IdentityHashMap();
    public final Map<String, ScreenModifier> byTitle = new HashMap<String, ScreenModifier>();
    private static final ResourceLocation INVENTORY = ResourceLocation.parse((String)"inventory");

    public GuiModifierManager() {
        super("gui_modifiers");
    }

    @Override
    protected void resetWithLevel(boolean logOff) {
        this.slotsByMenuId.clear();
        this.slotsByClass.clear();
        this.slotsByTitle.clear();
        this.byMenuId.clear();
        this.byClass.clear();
        this.byTitle.clear();
    }

    @Override
    protected void parseWithLevel(Map<ResourceLocation, JsonElement> jsons, RegistryOps<JsonElement> ops, HolderLookup.Provider access) {
        ArrayList<GuiModifier> allModifiers = new ArrayList<GuiModifier>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation id;
            JsonElement json = entry.getValue();
            GuiModifier modifier = Parsed.parseOrNull(GuiModifier.CODEC, json, ops, id = entry.getKey(), "gui modifier");
            if (modifier == null) continue;
            allModifiers.add(modifier);
        }
        for (GuiModifier mod : allModifiers) {
            if (mod.targetsClass()) {
                String target = mod.target();
                try {
                    Class cl = target.equals("InventoryMenu") ? InventoryMenu.class : (target.equals("ItemPickerMenu") ? CreativeModeInventoryScreen.ItemPickerMenu.class : Class.forName(target));
                    this.byClass.merge(cl, ScreenModifier.fromGuiMod(mod), ScreenModifier::merge);
                    if (mod.slotModifiers().isEmpty()) continue;
                    Int2ObjectArrayMap map = this.slotsByClass.computeIfAbsent(cl, i -> new Int2ObjectArrayMap());
                    GuiModifierManager.unwrapSlots(mod, (Int2ObjectArrayMap<SlotModifier>)map);
                }
                catch (ClassNotFoundException ignored) {
                    Polytone.LOGGER.error("Could not find class target with name {}", (Object)target);
                }
                continue;
            }
            if (mod.targetsMenuId()) {
                ResourceLocation menuId = ResourceLocation.parse((String)mod.target());
                boolean isInventory = menuId.equals((Object)INVENTORY);
                Optional menu = BuiltInRegistries.MENU.getOptional(menuId);
                if (!menu.isPresent() && !isInventory) continue;
                this.byMenuId.merge(menu.orElse(null), ScreenModifier.fromGuiMod(mod), ScreenModifier::merge);
                if (mod.slotModifiers().isEmpty()) continue;
                Int2ObjectArrayMap map = this.slotsByMenuId.computeIfAbsent(menu.orElse(null), i -> new Int2ObjectArrayMap());
                GuiModifierManager.unwrapSlots(mod, (Int2ObjectArrayMap<SlotModifier>)map);
                continue;
            }
            String title = mod.target();
            this.byTitle.merge(title, ScreenModifier.fromGuiMod(mod), ScreenModifier::merge);
            if (mod.slotModifiers().isEmpty()) continue;
            Int2ObjectArrayMap map = this.slotsByTitle.computeIfAbsent(title, i -> new Int2ObjectArrayMap());
            GuiModifierManager.unwrapSlots(mod, (Int2ObjectArrayMap<SlotModifier>)map);
        }
    }

    @Override
    protected void applyWithLevel(HolderLookup.Provider access, boolean isLogIn) {
        if (!(this.slotsByMenuId.isEmpty() && this.slotsByClass.isEmpty() && this.slotsByTitle.isEmpty())) {
            Polytone.LOGGER.info("Loaded GUI modifiers for: {} {} {} {}", this.slotsByMenuId.keySet(), this.slotsByClass.keySet(), this.byMenuId.keySet(), this.byClass.keySet());
        }
    }

    private static void unwrapSlots(GuiModifier mod, Int2ObjectArrayMap<SlotModifier> map) {
        for (SlotModifier s : mod.slotModifiers()) {
            for (int i : s.targets().getSlots()) {
                map.merge(i, (Object)s, SlotModifier::merge);
            }
        }
    }

    private ScreenModifier getScreenModifier(AbstractContainerScreen<?> screen) {
        ScreenModifier m = null;
        AbstractContainerMenu menu = screen.getMenu();
        if (screen.getClass() == InventoryScreen.class) {
            m = this.byClass.get(InventoryMenu.class);
        } else if (screen.getClass() == CreativeModeInventoryScreen.class) {
            m = this.byClass.get(CreativeModeInventoryScreen.ItemPickerMenu.class);
        }
        if (menu != null) {
            m = this.byClass.get(menu.getClass());
        }
        if (m == null) {
            MenuType type;
            try {
                type = menu.getType();
            }
            catch (Exception e) {
                type = null;
            }
            m = this.byMenuId.get(type);
        }
        return m;
    }

    @Nullable
    public ScreenModifier getGuiModifier(Screen screen) {
        MutableComponent mc;
        ComponentContents componentContents;
        Component c;
        ScreenModifier m = this.byClass.get(screen.getClass());
        if (m == null && screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen as = (AbstractContainerScreen)screen;
            m = this.getScreenModifier(as);
        }
        try {
            c = screen.getTitle();
        }
        catch (Exception e) {
            return null;
        }
        if (m == null) {
            m = this.byTitle.get(c.getString());
        }
        if (m == null && c instanceof MutableComponent && (componentContents = (mc = (MutableComponent)c).getContents()) instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            m = this.byTitle.get(tc.getKey());
        }
        return m;
    }

    @Nullable
    public SlotModifier getSlotModifier(AbstractContainerScreen<?> screen, Slot slot) {
        MutableComponent mc;
        ComponentContents componentContents;
        Int2ObjectArrayMap<SlotModifier> m = null;
        Component c = screen.getTitle();
        m = this.slotsByTitle.get(c.getString());
        if (m == null && c instanceof MutableComponent && (componentContents = (mc = (MutableComponent)c).getContents()) instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            m = this.slotsByTitle.get(tc.getKey());
        }
        if (m == null) {
            m = this.slotsByClass.get(screen.getClass());
        }
        if (m == null) {
            this.slotsByClass.get(screen.getMenu().getClass());
        }
        if (m == null) {
            MenuType type;
            try {
                type = screen.getMenu().getType();
            }
            catch (Exception e) {
                type = null;
            }
            m = this.slotsByMenuId.get(type);
        }
        if (m != null) {
            return (SlotModifier)m.get(slot.index);
        }
        return null;
    }

    @Nullable
    public SlotModifier getSlotModifier(AbstractContainerMenu menu, Slot slot) {
        Int2ObjectArrayMap<SlotModifier> m = this.slotsByClass.get(menu.getClass());
        if (m == null) {
            MenuType type;
            try {
                type = menu.getType();
            }
            catch (Exception e) {
                type = null;
            }
            m = this.slotsByMenuId.get(type);
        }
        if (m != null) {
            return (SlotModifier)m.get(slot.index);
        }
        return null;
    }

    public void maybeModifySlot(AbstractContainerMenu menu, Slot slot) {
        SlotModifier mod = this.getSlotModifier(menu, slot);
        if (mod != null) {
            mod.modify(slot);
        }
    }

    public boolean maybeChangeColor(AbstractContainerScreen<?> screen, @NotNull Slot slot, GuiGraphics graphics, int x, int y, int offset) {
        SlotModifier mod = this.getSlotModifier(screen, slot);
        if (mod != null && mod.hasCustomColor()) {
            mod.renderCustomHighlight(graphics, x, y, offset);
            return false;
        }
        return true;
    }
}

