/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.mehvahdjukaar.polytone.utils.exp.BaseExpression;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class ColormapExpressionProvider
extends BaseExpression
implements IColormapNumberProvider {
    private static final String BIOME_VALUE = "BIOME_VALUE";
    private static final String DAMAGE = "DAMAGE";
    public static final Codec<ColormapExpressionProvider> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new ColormapExpressionProvider((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.getUnparsed()));
    private final boolean usesBiome;
    private final boolean hasState;

    private ColormapExpressionProvider(String unparsed) {
        super(unparsed);
        this.usesBiome = unparsed.contains("TEMPERATURE") || unparsed.contains("DOWNFALL") || unparsed.contains(BIOME_VALUE);
        this.hasState = unparsed.contains("state_prop");
    }

    @Override
    protected void buildVars(BaseExpression.VarBuilder builder) {
        super.buildVars(builder);
        builder.addAll(BIOME_VALUE, DAMAGE);
    }

    @Override
    protected void buildFunctions(BaseExpression.FunBuilder builder) {
        super.buildFunctions(builder);
        builder.addAll(STATE_PROP_INT, STATE_PROP);
    }

    @Override
    public boolean usesBiome() {
        return this.usesBiome;
    }

    @Override
    public boolean usesPos() {
        return this.hasPos;
    }

    @Override
    public boolean usesState() {
        return this.hasState;
    }

    @Override
    public float getValue(@Nullable BlockState state, @Nullable BlockPos pos, @Nullable Biome biome, @Nullable BiomeIdMapper mapper, @Nullable ItemStack stack) {
        Entity e;
        if (pos == null) {
            pos = BlockPos.ZERO;
            ExpressionUtils.randomizeRandom();
        } else {
            ExpressionUtils.seedRandom((long)pos.hashCode() * pos.asLong());
        }
        if (this.hasPos) {
            this.expression.setVariable("POS_X", pos.getX());
            this.expression.setVariable("POS_Y", pos.getY());
            this.expression.setVariable("POS_Z", pos.getZ());
        }
        if (this.hasTime) {
            this.expression.setVariable("TIME", ClientFrameTicker.getGameTime());
        }
        if (this.hasDayTime) {
            this.expression.setVariable("DAY_TIME", ClientFrameTicker.getDayTime());
        }
        if (this.hasSunTime) {
            this.expression.setVariable("SUN_TIME", ClientFrameTicker.getSunTime());
        }
        if (this.hasRain) {
            this.expression.setVariable("RAIN", ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasSkyLight) {
            this.expression.setVariable("SKY_LIGHT", Minecraft.getInstance().level.getBrightness(LightLayer.SKY, pos));
        }
        if (this.hasBlockLight) {
            this.expression.setVariable("BLOCK_LIGHT", Minecraft.getInstance().level.getBrightness(LightLayer.BLOCK, pos));
        }
        if (this.hasTemperature) {
            this.expression.setVariable("TEMPERATURE", biome != null ? (double)ColorUtils.getClimateSettings((Biome)biome).temperature : 0.0);
        }
        if (this.hasDownfall) {
            this.expression.setVariable("DOWNFALL", biome != null ? (double)ColorUtils.getClimateSettings((Biome)biome).downfall : 0.0);
        }
        if (this.hasPlayer) {
            e = Minecraft.getInstance().getCameraEntity();
            this.expression.setVariable("PLAYER_X", e.getX());
            this.expression.setVariable("PLAYER_Y", e.getY());
            this.expression.setVariable("PLAYER_Z", e.getZ());
        }
        if (this.hasDistance) {
            e = Minecraft.getInstance().getCameraEntity();
            double x = (double)pos.getX() - e.getX();
            double y = (double)pos.getY() - e.getY();
            double z = (double)pos.getZ() - e.getZ();
            this.expression.setVariable("DISTANCE_SQUARED", x * x + y * y + z * z);
        }
        if (this.hasPlayerSpeed) {
            this.expression.setVariable("PLAYER_SPEED_SQUARED", ClientFrameTicker.getPlayerSpeed());
        }
        if (this.hasRenderDistance) {
            this.expression.setVariable("RENDER_DISTANCE", ClientFrameTicker.getRenderDistance());
        }
        if (stack != null) {
            float damage = 1.0f - (float)stack.getDamageValue() / (float)stack.getMaxDamage();
            this.expression.setVariable(DAMAGE, damage);
        } else {
            this.expression.setVariable(DAMAGE, 0.0);
        }
        if (this.hasState) {
            STATE_HACK.set(state);
        }
        float result = (float)this.expression.evaluate();
        STATE_HACK.remove();
        return result;
    }
}

